# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations
import django.db.models.deletion
import datetime


class Migration(migrations.Migration):

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Ammo',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('author', models.CharField(max_length=32)),
                ('created_at', models.DateTimeField(null=0)),
                ('dsc', models.CharField(max_length=128)),
                ('flag', models.PositiveSmallIntegerField(verbose_name=1, default=0)),
                ('hidden', models.PositiveSmallIntegerField(verbose_name=1, default=0)),
                ('last_used', models.DateTimeField(null=0)),
                ('mdsum', models.CharField(max_length=32, default='')),
                ('path', models.CharField(max_length=256)),
                ('private', models.PositiveSmallIntegerField(verbose_name=1, default=0)),
                ('size', models.IntegerField(verbose_name=20, default=0)),
            ],
            options={
                'db_table': 'ammo',
            },
        ),
        migrations.CreateModel(
            name='Artifact',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('storage_key', models.CharField(max_length=256)),
            ],
            options={
                'db_table': 'artifact',
            },
        ),
        migrations.CreateModel(
            name='Component',
            fields=[
                ('n', models.AutoField(primary_key=True, serialize=False)),
                ('tag', models.CharField(max_length=128, null=1)),
                ('name', models.CharField(max_length=128)),
                ('dsc', models.TextField(null=1)),
                ('include_qs', models.CharField(max_length=128, default='')),
                ('exclude_qs', models.CharField(max_length=128, default='')),
                ('job_order', models.CharField(max_length=32, default='n_ordered')),
                ('priority', models.SmallIntegerField(verbose_name=1, default=0)),
                ('services_json', models.TextField(null=1, default='[]')),
            ],
            options={
                'db_table': 'component',
            },
        ),
        migrations.CreateModel(
            name='CustomUserReport',
            fields=[
                ('n', models.AutoField(primary_key=True, serialize=False)),
                ('user', models.CharField(max_length=64)),
                ('name', models.CharField(max_length=32)),
                ('active', models.PositiveSmallIntegerField(verbose_name=1, default=1)),
                ('plots_json', models.TextField(null=1, default='[]')),
            ],
            options={
                'db_table': 'custom_user_report',
            },
        ),
        migrations.CreateModel(
            name='DeletedJob',
            fields=[
                ('n', models.PositiveIntegerField(primary_key=True, serialize=False)),
                ('task', models.CharField(max_length=120, null=1, default='')),
                ('fd', models.DateTimeField(default=datetime.datetime.now)),
                ('td', models.DateTimeField(null=1, default=None)),
                ('person', models.CharField(max_length=64, null=1, default='')),
                ('name', models.CharField(max_length=120, null=1, default='')),
                ('dsc', models.TextField(null=1, default='')),
                ('command_line', models.CharField(max_length=512, null=1, default='')),
                ('ammo_path', models.CharField(max_length=256, null=1, default='')),
                ('loop_cnt', models.FloatField(null=1, default=0)),
                ('quit_status', models.PositiveSmallIntegerField(verbose_name=1, null=1, default=0)),
                ('srv_port', models.PositiveIntegerField(verbose_name=8, default=0)),
                ('instances', models.PositiveIntegerField(verbose_name=8, default=0)),
                ('flag', models.PositiveSmallIntegerField(verbose_name=1, default=0)),
                ('component', models.PositiveIntegerField(verbose_name=6, default=0)),
                ('ver', models.CharField(max_length=120, null=1, default='')),
                ('configinfo', models.TextField(null=1, default='')),
                ('configinitial', models.TextField(null=1, default='')),
                ('finalized', models.PositiveSmallIntegerField(verbose_name=1, default=1)),
                ('status', models.CharField(max_length=32, default='')),
            ],
            options={
                'db_table': 'deleted_job',
            },
        ),
        migrations.CreateModel(
            name='Job',
            fields=[
                ('n', models.AutoField(primary_key=True, serialize=False)),
                ('task', models.CharField(max_length=120, null=1, default='')),
                ('fd', models.DateTimeField(default=datetime.datetime.now)),
                ('td', models.DateTimeField(null=1, default=None)),
                ('person', models.CharField(max_length=64, null=1, default='')),
                ('name', models.CharField(max_length=120, null=1, default='')),
                ('dsc', models.TextField(null=1, default='')),
                ('command_line', models.CharField(max_length=512, null=1, default='')),
                ('ammo_path', models.CharField(max_length=256, null=1, default='')),
                ('loop_cnt', models.FloatField(null=1, default=0)),
                ('quit_status', models.PositiveSmallIntegerField(verbose_name=1, null=1, default=0)),
                ('srv_port', models.PositiveIntegerField(verbose_name=8, default=0)),
                ('instances', models.PositiveIntegerField(verbose_name=8, default=0)),
                ('flag', models.PositiveSmallIntegerField(verbose_name=1, default=0)),
                ('component', models.PositiveIntegerField(verbose_name=6, default=0)),
                ('ver', models.CharField(max_length=120, null=1, default='')),
                ('configinfo', models.TextField(null=1, default='')),
                ('configinitial', models.TextField(null=1, default='')),
                ('finalized', models.PositiveSmallIntegerField(default=1)),
                ('status', models.CharField(max_length=32, default='')),
            ],
            options={
                'db_table': 'job',
            },
        ),
        migrations.CreateModel(
            name='JobEvent',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('text', models.TextField(null=1, default='')),
                ('author', models.CharField(max_length=32, null=1)),
                ('timestamp', models.DateTimeField(null=1)),
                ('tag', models.CharField(max_length=512, null=1, default='')),
                ('job', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='common.Job')),
            ],
            options={
                'db_table': 'job_event',
            },
        ),
        migrations.CreateModel(
            name='JobImbalance',
            fields=[
                ('n', models.AutoField(primary_key=True, serialize=False)),
                ('hum_isimbalance', models.IntegerField(verbose_name=1, default=0)),
                ('hum_imbalance', models.IntegerField(verbose_name=8, default=0)),
                ('rob_isimbalance', models.IntegerField(verbose_name=1, default=0)),
                ('rob_warning_sec', models.IntegerField(verbose_name=8, default=0)),
                ('rob_imbalance', models.IntegerField(verbose_name=8, default=0)),
                ('rob_imbalance_sec', models.IntegerField(verbose_name=8, default=0)),
                ('hum_processed', models.IntegerField(verbose_name=1, default=0)),
                ('user', models.CharField(max_length=64, null=1)),
                ('up', models.ForeignKey(db_column='up', to='common.Job')),
            ],
            options={
                'db_table': 'job_imbalance',
            },
        ),
        migrations.CreateModel(
            name='JobTrail',
            fields=[
                ('n', models.AutoField(primary_key=True, serialize=False)),
                ('min_rps', models.IntegerField(verbose_name=10)),
                ('max_rps', models.IntegerField(verbose_name=10)),
                ('http', models.CharField(max_length=64)),
                ('net', models.PositiveSmallIntegerField(verbose_name=1)),
                ('avg_resps', models.FloatField(null=True)),
                ('trail_start', models.DateTimeField(null=1)),
                ('trail_stop', models.DateTimeField(null=1)),
                ('avg_expect', models.FloatField(null=1)),
                ('avg_connect_time', models.FloatField(null=True)),
                ('avg_send_time', models.FloatField(null=True)),
                ('avg_latency', models.FloatField(null=True)),
                ('avg_receive_time', models.FloatField(null=True)),
                ('q50', models.FloatField(null=1)),
                ('q75', models.FloatField(null=1)),
                ('q80', models.FloatField(null=1)),
                ('q85', models.FloatField(null=1)),
                ('q90', models.FloatField(null=1)),
                ('q95', models.FloatField(null=1)),
                ('q98', models.FloatField(null=1)),
                ('q99', models.FloatField(null=1)),
                ('up', models.ForeignKey(db_column='up', to='common.Job')),
            ],
            options={
                'db_table': 'job_trail',
            },
        ),
        migrations.CreateModel(
            name='KPI',
            fields=[
                ('n', models.AutoField(primary_key=True, serialize=False)),
                ('ktype', models.CharField(max_length=128, default='')),
                ('component_id', models.PositiveIntegerField(verbose_name=6)),
                ('essential', models.PositiveSmallIntegerField(verbose_name=1, default=0)),
                ('params_json', models.TextField(null=1)),
                ('dsc', models.TextField(null=1)),
            ],
            options={
                'db_table': 'kpi',
            },
        ),
        migrations.CreateModel(
            name='LoadScheme',
            fields=[
                ('n', models.AutoField(primary_key=True, serialize=False)),
                ('sec_from', models.PositiveIntegerField(verbose_name=10)),
                ('sec_to', models.PositiveIntegerField(verbose_name=10)),
                ('load_type', models.PositiveIntegerField(verbose_name=2)),
                ('load_from', models.FloatField(verbose_name=2)),
                ('load_to', models.FloatField(verbose_name=2)),
                ('dsc', models.CharField(max_length=128)),
                ('up', models.ForeignKey(db_column='up', to='common.Job')),
            ],
            options={
                'db_table': 'loadscheme',
            },
        ),
        migrations.CreateModel(
            name='MobileJobDataKey',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('mobile_data_key', models.CharField(max_length=256)),
                ('job', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='common.Job')),
            ],
            options={
                'db_table': 'mobile_data_key',
            },
        ),
        migrations.CreateModel(
            name='RegressionComment',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('text', models.CharField(max_length=256, null=1)),
                ('author', models.CharField(max_length=32)),
                ('created_at', models.DateTimeField(null=1)),
                ('job', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='common.Job')),
            ],
            options={
                'db_table': 'regression_comment',
            },
        ),
        migrations.CreateModel(
            name='Server',
            fields=[
                ('n', models.AutoField(primary_key=True, serialize=False)),
                ('host', models.CharField(max_length=128)),
                ('is_test', models.PositiveSmallIntegerField(verbose_name=1, default=0)),
                ('fd', models.DateTimeField(default=datetime.datetime.now)),
                ('td', models.DateTimeField(null=1, default=None)),
                ('config', models.TextField(null=1, default='')),
                ('dsc', models.TextField(null=1, default='')),
                ('last_ip', models.CharField(max_length=20, default='')),
                ('last_dc', models.SmallIntegerField(verbose_name=2, default=0)),
            ],
            options={
                'db_table': 'server',
            },
        ),
        migrations.CreateModel(
            name='TankUserAgent',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('user_agent', models.CharField(max_length=512)),
                ('job', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='common.Job')),
            ],
        ),
        migrations.CreateModel(
            name='Task',
            fields=[
                ('n', models.AutoField(primary_key=True, serialize=False)),
                ('key', models.CharField(max_length=64, null=1)),
            ],
            options={
                'db_table': 'task',
            },
        ),
        migrations.CreateModel(
            name='TaskServer',
            fields=[
                ('n', models.AutoField(primary_key=True, serialize=False)),
                ('task', models.CharField(max_length=120, null=1, default='')),
                ('openstack_id', models.CharField(max_length=64, null=1)),
                ('status', models.CharField(max_length=16, null=1, default='')),
            ],
            options={
                'db_table': 'task_server',
            },
        ),
        migrations.CreateModel(
            name='UISettings',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('person', models.CharField(max_length=64)),
                ('param', models.CharField(max_length=256)),
                ('onoff', models.PositiveSmallIntegerField(verbose_name=1, default=1)),
            ],
        ),
        migrations.CreateModel(
            name='UploadToken',
            fields=[
                ('n', models.AutoField(primary_key=True, serialize=False)),
                ('job', models.BigIntegerField(verbose_name=10, null=True)),
                ('token', models.CharField(max_length=64, default='')),
            ],
            options={
                'db_table': 'upload_token',
            },
        ),
        migrations.AddField(
            model_name='job',
            name='srv',
            field=models.ForeignKey(null=1, default=None, db_column='srv', related_name='target_job', to='common.Server'),
        ),
        migrations.AddField(
            model_name='job',
            name='tank',
            field=models.ForeignKey(null=1, default=None, db_column='tank', related_name='tank_job', to='common.Server'),
        ),
        migrations.AddField(
            model_name='deletedjob',
            name='srv',
            field=models.ForeignKey(null=1, default=None, db_column='srv', related_name='srv', to='common.Server'),
        ),
        migrations.AddField(
            model_name='deletedjob',
            name='tank',
            field=models.ForeignKey(null=1, default=None, db_column='tank', related_name='tank', to='common.Server'),
        ),
        migrations.AddField(
            model_name='artifact',
            name='job',
            field=models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='common.Job'),
        ),
    ]
