from django.db import models

# Create your models here.

from common.util.clients import CacheClient


class CompareJobsManager(object):
    use_in_migrations = True
    cache_key_prefix = 'compare_jobs_for_user_{}'


    def __init__(self, user_login):
        self.user_login = user_login

        self.cache_client = CacheClient()
        self.cache_key = self.cache_key_prefix.format(user_login)

    def get_jobs(self):
        """

        :return: int[]
        """
        return self.cache_client.get(self.cache_key) or []

    def set_jobs(self, jobs):
        """

        :param jobs: int[]
        :return: void
        """

        self.cache_client.delete(self.cache_key)
        self.cache_client.set(self.cache_key, jobs)

    def clear_jobs(self):
        """

        :return: void
        """
        self.cache_client.delete(self.cache_key)

    def add_jobs(self, jobs_to_add):
        """

        :param jobs_to_add: int[]
        :return: void
        """
        current_jobs = self.get_jobs()
        self.cache_client.delete(self.cache_key)
        for job in jobs_to_add:
            if job not in current_jobs:
                current_jobs.append(job)
        self.cache_client.set(self.cache_key, current_jobs)

    def remove_jobs(self, jobs_to_remove):
        """

        :param jobs_to_remove: int[]
        :return: void
        """
        current_jobs = self.get_jobs()
        for job in jobs_to_remove:
            if job in current_jobs:
                current_jobs.remove(job)
        self.cache_client.delete(self.cache_key)
        self.cache_client.set(self.cache_key, current_jobs)

    @property
    def count(self):
        return len(self.get_jobs())
