# coding=utf-8
"""
Created on Jul 25, 2014

@author: noob
"""
import yaml


# FIXME: https://st.yandex-team.ru/LUNAPARK-3359
yatank_base_defaults_url = 'https://github.com/yandex/yandex-tank/blob/develop/yandextank/core/config/00-base.yaml'


yatank_base_defaults = yaml.safe_load('''android:
  enabled: false
  package: yandextank.plugins.Android
autostop:
  enabled: true
  package: yandextank.plugins.Autostop
bfg:
  enabled: false
  package: yandextank.plugins.Bfg
console:
  enabled: true
  package: yandextank.plugins.Console
jmeter:
  enabled: false
  package: yandextank.plugins.JMeter
json_report:
  enabled: true
  package: yandextank.plugins.JsonReport
phantom:
  enabled: true
  package: yandextank.plugins.Phantom
rcheck:
  enabled: true
  package: yandextank.plugins.ResourceCheck
shellexec:
  enabled: true
  package: yandextank.plugins.ShellExec
telegraf:
  enabled: true
  package: yandextank.plugins.Telegraf
rcassert:
  enabled: true
  package: yandextank.plugins.RCAssert
overload:
  enabled: false
  package: yandextank.plugins.DataUploader
influx:
  enabled: false
  package: yandextank.plugins.Influx
metaconf:
  enabled: false
  package: yandextank.plugins.MetaConf}''')


yaml_defaults = {
    'console': {
        'enabled': [True],
        'package': ['yandextank.plugins.Console']
    },
    'json_report': {
        'enabled': [True],
        'package': ['yandextank.plugins.JsonReport']
    },
    'rcassert': {
        'enabled': [True],
        'fail_code': [10],
        'package': ['yandextank.plugins.RCAssert']
    },
    'rcheck': {
        'enabled': [True],
        'package': ['yandextank.plugins.ResourceCheck'],
        'disk_limit': [2048],
        'interval': ['10s'],
        'mem_limit': [1024],
    },
    'shellexec': {
        'enabled': [True],
        'package': ['yandextank.plugins.ShellExec'],
        'catch_out': [False],
    },
    'phantom': {
        'enabled': [True],
        'additional_libs': [[]],
        'phantom_modules_path': ['/usr/lib/phantom'],
        'force_stepping': [0],
        'writelog': ['0'],
        'use_caching': [True],
        'file_cache': [8192],
        'buffered_seconds': [2],
        'loop': [-1],
        'ssl': [0],
        'headers': [[]],
        'cache_dir': ['/var/lib/tankapi/tests/stpd-cache'],
        'autocases': [0],
        'ammo_limit': [-1],
        'connection_test': [True],
        'enum_ammo': [False],
        'tank_type': ['http'],
        'exclude_markers': [[]],
        'instances': [1000],
        'timeout': ['11s'],
        'multi': [[]],
        'phantom_http_entity': ['8M'],
        'phantom_http_field': ['8K'],
        'phantom_http_field_num': [128],
        'phantom_http_line': ['1K'],
        'phantom_path': ['phantom'],
        'threads': ['null', None],
        'method_prefix': ['method_stream'],
    },
    'uploader': {
        'copy_config_to': ['config_copy'],
        'ignore_target_lock': [False],
        'lock_targets': ['auto'],
        'regress': ['0'],
        'strict_lock': [False],
        'notify': [[]],
        'chunk_size': [500000],
        'api_address': ['https://lunapark.yandex-team.ru/', 'https://overload.yandex.net/']
    },
    'autostop': {
        'autostop': [[]],
        'enabled': [True],
        'package': ['yandextank.plugins.Autostop'],
    },
    'bfg': {
        'ammo_type': ['caseline'],
        'loop': [-1],
        'ammo_limit': [-1],
        'header_http': ['1.0'],
        'autocases': [0],
        'enum_ammo': [False],
        'use_caching': [1],
        'file_cache': [8192],
        'cache_dir': ['logs'],
        'force_stepping': [0],
        'cached_stpd': [0],
        'result_cache_size': [5],
    },
    'telegraf': {
        'disguise_hostnames': [False],
        'kill_old': [False],
        'ssh_timeout': ['5s'],
        'default_target': ['localhost'],
    },
    'metaconf': {
        'enabled': [False],
        'package': ['yandextank.plugins.MetaConf'],
    },
}

# Обновляем дефолты для включения или выключения плагинов
for key in yaml_defaults:
    if key in yatank_base_defaults:
        yaml_defaults[key]['enabled'] = [yatank_base_defaults[key].get('enabled', True)]


yaml_rudimentary_params = {
    'uploader': [
        'writer_endpoint',
        'jobno',
        'target_lock_duration',
        'artifacts_base_dir',
        'upload_token',
        'cmdline',
        'target_host',
        'target_port',
        'loop_count',
        'ammo_path',
        'jobno_file',
        'log_data_requests',
        'maintenance_timeout',
        'network_attempts',
        'launched_from',
        'log_other_requests',
        'connection_timeout',
        'log_monitoring_requests',
        'api_attempts',
        'api_timeout',
        'network_timeout',
        'send_status_period',
        'log_status_requests',
        'threads_timeout',
        'maintenance_attempts',
    ],
    'json_report': [
        'monitoring_log',
        'test_data_log',
    ],
    'autostop': [
        'report_file',
    ],
    'phantom': [
        'eta_file',
        #                                   'stpd_file', # special behavior for this parameter
        'phout_file',
        'phantom_path',
        'threads',
        'method_prefix',
        'file_cache',
        'tank_type',
    ],
    'bfg': [
        'stpd_file',
    ],
    'overload': [
        'jobno_file',
        'task',
        'jobno',
        'api_timeout',
        'operator',
        'notify',
        'copy_config_to',
        'regress',

    ],
    'tips': [
        'enabled',
        'package',
    ],
    'telegraf': [
        'config',
    ]
}

yaml_uploader_meta_rudimentary_params = [
    'jobno',
    'cmdline',
    'target_host',
    'target_port',
    'ammo_path',
    'loop_count',
    'launched_from',
]

section_defaults = {
    'phantom': {
        'ammo_type': [''],
        'config': [''],
        'port': [''],
        'headers': [''],
        'gatling_ip': [''],
        'additional_libs': [''],
        'phantom_http_line': [''],
        'phantom_http_entity': [''],
        'phantom_http_field': [''],
        'phantom_http_field_num': [''],
        'phantom_modules_path': ['/usr/lib/phantom'],
        'source_log_prefix': [''],
        'chosen_cases': [''],
        'force_stepping': ['0'],
        'writelog': ['none'],
        'method_options': [''],
        'use_caching': ['1'],
        'buffered_seconds': ['2'],
        'loop': ['-1'],
        'ssl': ['0'],
        'cache_dir': ['/var/lib/tankapi/tests/stpd-cache'],
        'autocases': ['0'],
        'ammo_limit': ['-1'],
        'connection_test': ['1'],
        'enum_ammo': ['False'],
        'tank_type': ['http'],
        'client_cipher_suites': [''],
        'affinity': [''],
        'client_key': [''],
        'client_certificate': [''],
        'exclude_markers': ['[]'],
        'instances': ['1000'],
        'timeout': ['11s'],
    },
    'meta': {
        '__name__': ['meta'],
        'token_file': [''],
        'job_dsc': [''],
        'ver': [''],
        'jobno_file': [''],
        'copy_config_to': ['', 'config_copy'],
        'ignore_target_lock': ['0'],
        'lock_targets': ['auto'],
        'regress': ['0'],
        'component': [''],
        'notify': [''],
        'strict_lock': ['0'],
        'writer_endpoint': [''],
    },
    'tank': {
        '__name__': ['tank'],
        'lock_dir': ['/var/lock'],
        'plugin_aggreg': ['Tank/Plugins/Aggregator.py', 'yandextank.plugins.Aggregator'],
        'plugin_aggregate': ['yandextank.plugins.Aggregator'],
        'plugin_report': ['Tank/Plugins/Report.py'],
        'plugin_phantom': ['Tank/Plugins/Phantom.py', 'yandextank.plugins.Phantom'],
        'plugin_autostop': ['Tank/Plugins/Autostop.py', 'yandextank.plugins.Autostop'],
        'plugin_totalautostop': ['Tank/Plugins/TotalAutostop.py', 'yandextank.plugins.TotalAutostop'],
        'plugin_shellexec': ['Tank/Plugins/ShellExec.py', 'yandextank.plugins.ShellExec'],
        'plugin_loadosophia': [''],
        'plugin_web': [''],
        'flush_config_to': [''],
        'plugin_graphite': [''],
        'plugin_console': ['Tank/Plugins/ConsoleOnline.py', 'yandextank.plugins.ConsoleOnline',
                           'yandextank.plugins.Console'],
        'plugin_monitoring': ['Tank/Plugins/Monitoring.py', 'yandextank.plugins.Monitoring',
                              'yandextank.plugins.Telegraf'],
        'artifacts_dir': [''],
        'plugin_tips': ['Tank/Plugins/TipsAndTricks.py', 'yandextank.plugins.TipsAndTricks', ''],
        'plugin_rcassert': ['Tank/Plugins/RCAssert.py', 'yandextank.plugins.RCAssert'],
        'artifacts_base_dir': ['logs'],
        'plugin_rcheck': ['Tank/Plugins/ResourceCheck.py', 'yandextank.plugins.ResourceCheck'],
        'plugin_uploader': ['Tank/Plugins/DataUploader.py', 'yatank_internal_DataUploader'],
        'plugin_lunapark': ['yandextank.plugins.DataUploader'],
        'ignore_locks': ['0'],
        'plugin_dolbilo': [''],
        'affinity': [''],
        'taskset_path': ['taskset'],
        'plugin_jsonreport': ['yandextank.plugins.JsonReport'],
    },
    'tips': {
        '__name__': ['tips'],
        'disable': ['0'],
    },
    'autostop': {
        '__name__': ['autostop'],
        'autostop': [''],
        'report_file': ['autostop_report.txt'],
    },
    'shellexec': {
        '__name__': ['shellexec'],
        'post_process': [''],
        'start': [''],
        'poll': [''],
        'end': [''],
        'prepare': [''],
        'catch_out': ['False'],
    },
    'report': {
        '__name__': ['report'],
        'show_graph': [''],
        'template': ['/usr/lib/yandex-tank/Tank/Plugins/report.tpl'],
    },
    'json_report': {
        'monitoring_log': ['monitoring.log'],
        'test_data_log': ['test_data.log'],
    },
    'rcheck': {
        '__name__': ['rcheck'],
        'mem_limit': ['1024'],
        'interval': ['10s'],
        'disk_limit': ['2048'],
    },
    'rcassert': {
        '__name__': ['rcassert'],
        'fail_code': ['10'],
        'pass': [''],
    },
    'console': {
        '__name__': ['console'],
        'short_only': ['0'],
        'info_panel_width': ['33'],
        'disable_all_colors': ['0'],
        'disable_colors': [''],
    },
    'aggregator': {
        '__name__': ['aggregator'],
        'precise_cumulative': ['0'],
        'verbose_histogram': ['1'],
        'time_periods': [
            '1ms 2 3 4 5 6 7 8 9 10 20 30 40 50 60 70 80 90 100 150 200 250 300 350 400 450 500 600 650 700 750 800 \
            850 900 950 1s 1500 2s 2500 3s 3500 4s 4500 5s 5500 6s 6500 7s 7500 8s 8500 9s 9500 10s 11s'],
    },
    'dolbilo': {
        '__name__': ['dolbilo'],
        'dout_file': [''],
        'compresstimeout': [''],
        'rps-max': [''],
        'echo': [''],
        'seed': [''],
        'dump-shots': [''],
        'min-success-rate': [''],
        'plan-memory': [''],
        'keep-alive': [''],
        'dump-data': [''],
        'circular': [''],
        'replace-port': [''],
        'queries-limit': [''],
        'time-limit': [''],
        'multiplier': [''],
        'replace-limit': [''],
        'rps-fixed': [''],
        'warm-time': [''],
        'simultaneous': [''],
        'mode': [''],
        'augmenturl': [''],
        'buffered_seconds': ['2'],
        'rps-min': [''],
        'slb': [''],
        'replace-host': [''],
    },
    'bfg': {
        '__name__': ['bfg'],
        'ammo_type': ['caseline'],
        'loop': ['-1'],
        'ammo_limit': ['-1'],
        'instances_schedule': [''],
        'uris': [''],
        'headers': [''],
        'header_http': ['1.0'],
        'autocases': ['0'],
        'enum_ammo': ['False'],
        'use_caching': ['1'],
        'file_cache': ['8192'],
        'cache_dir': ['logs'],
        'force_stepping': ['0'],
        'chosen_cases': [''],
        'cached_stpd': ['0'],
        'zmq': [''],
        'result_cache_size': ['5'],
    },
    'monitoring': {
        '__name__': ['monitoring'],
    },
    'overload': {
        '__name__': ['overload'],
        'api_address': ['https://overload.yandex.net/'],
        'component': [''],
    },
    'jmeter': {
        '__name__': ['jmeter'],
        'jmeter_path': ['/usr/lib/yandex/apache-jmeter/bin/jmeter'],
    },
    'telegraf': {
        '__name__': ['telegraf'],
        'ssh_timeout': ['5s'],
        'disguise_hostnames': ['0'],
    },
}

rudimentary_params = {
    'meta': [
        'api_address',
        'writer_endpoint',
        'jobno',
        'target_lock_duration',
        'artifacts_base_dir',
        'upload_token',
        'cmdline',
        'target_host',
        'target_port',
        'loop_count',
        'ammo_path',
        'jobno_file',
        'operator',
        'log_data_requests',
        'maintenance_timeout',
        'network_attempts',
        'launched_from',
        'log_other_requests',
        'connection_timeout',
        'log_monitoring_requests',
        'api_attempts',
        'api_timeout',
        'network_timeout',
        'send_status_period',
        'log_status_requests',
        'threads_timeout',
        'maintenance_attempts',
    ],
    'tank': [
        'pid',
        'api_jobno',
        'plugin_clickhouse',
        'uuid',
        'plugin_telegraf',
        'message',
    ],
    'phantom': [
        '__name__',  # this one is here, because there might be multiple phantom sections
        'eta_file',
        #                                   'stpd_file', # special behavior for this parameter
        'phout_file',
        'phantom_path',
        'threads',
        'method_prefix',
        'file_cache',
        'tank_type',
    ],
    'bfg': [
        'stpd_file',
    ],
    'clickhouse': [
        'api_address',
    ],
    'overload': [
        'jobno_file',
        'task',
        'jobno',
        'api_timeout',
        'operator',
        'notify',
        'copy_config_to',
        'regress',

    ]
}
