from django.db import models


class APK(models.Model):
    id = models.AutoField(primary_key=True)
    author = models.CharField(max_length=32)
    created_at = models.DateTimeField(null=0)
    dsc = models.CharField(max_length=128)
    mdsum = models.CharField(max_length=32, default='')
    path = models.CharField(max_length=256)
    size = models.IntegerField(20, default=0)

    class Meta:
        db_table = 'mobile_apk'


class APKTests(models.Model):
    id = models.AutoField(primary_key=True)
    author = models.CharField(max_length=32)
    created_at = models.DateTimeField(null=0)
    dsc = models.CharField(max_length=128)
    mdsum = models.CharField(max_length=32, default='')
    path = models.CharField(max_length=256)
    size = models.IntegerField(20, default=0)

    class Meta:
        db_table = 'mobile_apk_tests'


'''
CREATE TABLE mobile_apk (
    id integer primary key,
    author varchar(32) NOT NULL,
    created_at timestamp NOT NULL,
    dsc varchar(128) NOT NULL,
	mdsum varchar(32) NOT NULL,
	path varchar(256) NOT NULL,
	size integer NOT NULL
);

CREATE SEQUENCE mobile_apk_id_seq start 1;

alter table only mobile_apk alter column id set default nextval('mobile_apk_id_seq'::regclass);

CREATE TABLE mobile_apk_tests (
    id integer primary key,
    author varchar(32) NOT NULL,
    created_at timestamp NOT NULL,
    dsc varchar(128) NOT NULL,
	mdsum varchar(32) NOT NULL,
	path varchar(256) NOT NULL,
	size integer NOT NULL
);

CREATE SEQUENCE mobile_apk_tests_id_seq start 1;

alter table only mobile_apk_tests alter column id set default nextval('mobile_apk_tests_id_seq'::regclass);

'''