# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations
import datetime


class Migration(migrations.Migration):

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='MobileComponent',
            fields=[
                ('n', models.AutoField(primary_key=True, serialize=False)),
                ('tag', models.CharField(max_length=128, null=1)),
                ('name', models.CharField(max_length=128)),
                ('dsc', models.TextField(null=1)),
                ('job_order', models.CharField(max_length=32, default='n_ordered')),
            ],
        ),
        migrations.CreateModel(
            name='MobileJob',
            fields=[
                ('n', models.AutoField(primary_key=True, serialize=False)),
                ('task', models.CharField(max_length=120, null=1, default='')),
                ('test_id', models.CharField(max_length=120, null=1, default='')),
                ('name', models.CharField(max_length=120, null=1, default='')),
                ('dsc', models.TextField(null=1, default='')),
                ('fd', models.DateTimeField(default=datetime.datetime.now)),
                ('td', models.DateTimeField(null=1, default=None)),
                ('person', models.CharField(max_length=64, null=1, default='')),
                ('tank', models.CharField(max_length=512, null=1, default='')),
                ('device_id', models.CharField(max_length=512, null=1, default='')),
                ('device_model', models.CharField(max_length=512, null=1, default='')),
                ('device_os', models.CharField(max_length=512, null=1, default='')),
                ('app', models.CharField(max_length=512, null=1, default='')),
                ('ver', models.CharField(max_length=512, null=1, default='')),
                ('quit_status', models.PositiveSmallIntegerField(verbose_name=1, null=1, default=0)),
                ('flag', models.PositiveSmallIntegerField(verbose_name=1, default=0)),
                ('component', models.PositiveIntegerField(verbose_name=6, null=1, default=0)),
                ('finalized', models.PositiveSmallIntegerField(verbose_name=1, default=1)),
                ('status', models.CharField(max_length=32, default='')),
                ('test_start', models.BigIntegerField(null=1, default=0)),
                ('sys_uts_offset', models.BigIntegerField(null=1, default=0)),
                ('log_uts_offset', models.BigIntegerField(null=1, default=0)),
                ('sync_sample', models.BigIntegerField(null=1, default=0)),
                ('version', models.CharField(max_length=512, null=1, default='')),
                ('meta', models.TextField(null=1, default='')),
            ],
            options={
                'db_table': 'mobile_job',
            },
        ),
    ]
