# -*- coding: utf-8 -*-

"""
Created on Nov 17, 2016

@author: noob
"""
from django.db import models
import datetime


class MobileJob(models.Model):
    n = models.AutoField(primary_key=True)
    task = models.CharField(max_length=120, null=1, default='')
    test_id = models.CharField(max_length=120, null=1, default='')
    name = models.CharField(max_length=120, null=1, default='')
    dsc = models.TextField(null=1, default='')
    fd = models.DateTimeField(default=datetime.datetime.now)
    td = models.DateTimeField(null=1, default=None)
    person = models.CharField(max_length=64, null=1, default='')
    tank = models.CharField(max_length=512, null=1, default='')
    device_id = models.CharField(max_length=512, null=1, default='')
    device_model = models.CharField(max_length=512, null=1, default='')
    device_os = models.CharField(max_length=512, null=1, default='')
    app = models.CharField(max_length=512, null=1, default='')
    ver = models.CharField(max_length=512, null=1, default='')
    quit_status = models.PositiveSmallIntegerField(1, null=1, default=0)
    flag = models.PositiveSmallIntegerField(1, default=0)
    component = models.PositiveIntegerField(6, null=1, default=0)
    finalized = models.PositiveSmallIntegerField(1, default=1)
    status = models.CharField(max_length=32, default='')

    test_start = models.BigIntegerField(null=1, default=0)
    sys_uts_offset = models.BigIntegerField(null=1, default=0)
    log_uts_offset = models.BigIntegerField(null=1, default=0)
    sync_sample = models.BigIntegerField(null=1, default=0)
    version = models.CharField(max_length=512, null=1, default='')
    meta = models.TextField(null=1, default='')

    class Meta:
        db_table = 'mobile_job'

    @property
    def id(self):
        """
        alias
        """
        return int(self.n)

    @property
    def current_table(self):
        if self.version == '2':
            return 'currents'
        else:
            return 'current'

    @property
    def events_table(self):
        if self.version == '2':
            return 'events'
        else:
            return 'logs'

    @property
    def logentries_table(self):
        if self.version == '2':
            return 'logentries'
        else:
            return 'logs'

    @property
    def syncs_table(self):
        if self.version == '2':
            return 'syncs'
        else:
            return 'logs'

    @property
    def fragments_table(self):
        if self.version == '2':
            return 'fragments'
        else:
            return 'logs'


class MobileComponent(models.Model):
    n = models.AutoField(primary_key=True)
    tag = models.CharField(max_length=128, null=1)
    name = models.CharField(max_length=128)
    dsc = models.TextField(null=1)
    job_order = models.CharField(max_length=32, default='n_ordered')
