# -*- coding: utf-8 -*-

"""
Created on Apr 12, 2013

@author: noob
"""

from django.conf.urls import url
from .views import onlinepage, render_custom_report_form, refresh_meta_info, refresh_tags, \
    refresh_monitoring_controls, progress_bar_info
from .views.layout import get_layout, get_single_report_controls
from .views.plots_to_show import get_plots_to_show
from .views.plot_data import get_plot_chunk
from offlinepage.views import job_edit

urlpatterns = [
    url(r'^(\d+)/?$', onlinepage),
    url(r'^(\d+)/layout.json$', get_layout),
    url(r'^(\d+)/plots_to_show.json$', get_plots_to_show),
    url(r'^(\d+)/plot_chunk.json$', get_plot_chunk),
    url(r'^(\d+)/edit$', job_edit),  # method from offlinepage to prevent duplicates
    url(r'^(\d+)/custom_report.json$', get_single_report_controls),
    url(r'^render_custom_report_form$', render_custom_report_form),
    url(r'^refresh_meta_info.json$', refresh_meta_info),
    url(r'^refresh_tags.json$', refresh_tags),
    url(r'^refresh_monitoring_controls.json$',refresh_monitoring_controls),
    url(r'^progress_bar.json$', progress_bar_info),
]
