"""
Created on Apr 2, 2014

@author: noob
"""

import re
from django import template
from django.conf import settings

numeric_test = re.compile('^\d+$')
register = template.Library()


@register.filter(name='getattribute')
def getattribute(value, arg):
    """
    Gets an attribute of an object dynamically from a string name
    """

    if hasattr(value, str(arg)):
        return getattr(value, arg)
    elif hasattr(value, 'has_key') and arg in value:
        return value[arg]
    elif numeric_test.match(str(arg)) and len(value) > int(arg):
        return value[int(arg)]
    else:
        return settings.TEMPLATE_STRING_IF_INVALID
