from .base import *

# External urls
STARTREK_URL = 'https://st-api.yandex-team.ru'
STARTREK_TVM2_ID = 176
STARTREK_TVM2_CLIENT_ID = 2023456

DEBUG = False

DB_NAME = 'lunaparkdb'
DB_HOSTS = [
    ('lunaparkdb01h.db.yandex.net', 'sas'),
    ('lunaparkdb01f.db.yandex.net', 'myt'),
    ('lunaparkdb01i.db.yandex.net', 'man'),
]
DB_PGAAS_HOST = HostManager(DB_HOSTS).host_string
DATABASES = {
    'default': {
        'ENGINE': 'django_pgaas.backend',
        'HOST': DB_PGAAS_HOST,
        'PORT': DB_PORT,
        'USER': 'lunapark',
        'PASSWORD': DB_PASSWORD,
        'NAME': DB_NAME,
        'OPTIONS': {
            'sslmode': 'require',
            'target_session_attrs': 'read-write'
        },
        'CONN_MAX_AGE': 49,
    },
    'slave': {
        'ENGINE': 'django_pgaas.backend',
        'HOST': DB_PGAAS_HOST,
        'PORT': DB_PORT,
        'USER': 'lunapark',
        'PASSWORD': DB_PASSWORD,
        'NAME': DB_NAME,
        'OPTIONS': {'target_session_attrs': 'any'},
    },
}

MIDDLEWARE_CLASSES = (
    'django.middleware.common.CommonMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'csp.middleware.CSPMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django_yauth.middleware.YandexAuthMiddleware',
)

LOGGING['handlers']['badman']['level'] = 'INFO'
LOGGING['root']['level'] = 'INFO'
logging.config.dictConfig(LOGGING)

YAUTH_TVM2_CLIENT_ID = 2023037

ALLOWED_HOSTS += [
    '.lunapark.yandex-team.ru',
    '.lunapark.yandex-team.ru.',
    'lunapark.yandex-team.ru',
    'lunapark.yandex-team.ru.',
    '.lunapark.n.yandex-team.ru',
    '.lunapark.n.yandex-team.ru.',
    'lunapark.n.yandex-team.ru',
    'lunapark.n.yandex-team.ru.',
    'lunapark-production.in.yandex-team.ru',
]
