# coverage run --source='.' manage.py test <app> --settings=settings.unittest

from .base import *

DATABASES = {
    'default': {
        'ENGINE': 'django_pgaas.backend',
        'NAME': 'lunapark',
        'USER': 'postgres',
        'PASSWORD': 'load_test',
        'HOST': 'localhost',
        'PORT': '5432',
        'CONN_MAX_AGE': 49,
    },
}

STARTREK_URL = 'https://st-api.test.yandex-team.ru'
STARTREK_TVM2_ID = 177
STARTREK_TVM2_CLIENT_ID = 2023458

CLICKHOUSE_HOST = 'localhost'
CLICKHOUSE_PORT = 9000

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'verbose': {
            'format': '%(levelname)s %(asctime)s %(module)s %(process)d %(thread)d %(message)s'
        },
        'specific': {
            'format': '%(asctime)s %(message)s'
        },
    },
    'handlers': {
        'badman': {
            'level': 'ERROR',
            'class': 'StreamHandler',
            'formatter': 'verbose',
            'encoding': 'utf-8'
        },
    },
    'root': {
        'handlers': ['badman'],
        'level': 'DEBUG',
    },
}
