from django.conf.urls import include, url
from django.contrib import admin
from django.views.generic.base import RedirectView
from django.views.static import serve
import warnings

from api.views.ping import ping
from common.views import error_500, daily_jobs_per_project, daily_mobilejobs_per_project, clear_compare, \
    check_task, ui_set, get_st_favicon, last, active
from taskpage.views import taskpage_jobs, taskpage_mobilejobs
from offlinepage.views import offlinepage, job_edit
from mainpage.views import mainpage
from projectpage.views import project_page
from firestarter.views import repeat

from settings import DEBUG, MEDIA_ROOT

admin.autodiscover()
warnings.filterwarnings("ignore", category=DeprecationWarning)


urlpatterns = [
    url(r'^$', mainpage),
    url(r'^ping$', ping),
    url(r'^favicon\.ico$', RedirectView.as_view(url='/media/favicon.ico')),
    url(r'^admin/', include(admin.site.urls)),
    url(r'^error500$', error_500),
    url(r'^([a-zA-Z-]+\d+)$', taskpage_jobs.task_page),
    url(r'^(\w+\-\d+)/more_mobilejobs\.json$', taskpage_mobilejobs.more_jobs),
    url(r'^(\w+\-\d+)/more_jobs\.json$', taskpage_jobs.more_jobs),
    url(r'^(\w+\-\d+)/addtofav\.json$', taskpage_jobs.addtofav),
    url(r'^(\w+\-\d+)/render_task_info$', taskpage_jobs.render_task_info),
    url(r'^(\w+\-\d+)/render_mobile_block', taskpage_mobilejobs.render_mobile_block),
    url(r'^deletefavfires\.json$', taskpage_jobs.deletefavfires),
    url(r'^mass_fav\.json', taskpage_jobs.mass_fav),
    url(r'^mass_compare\.json', taskpage_jobs.mass_compare),
    url(r'^mass_delete\.json', taskpage_jobs.mass_delete),
    url(r'^mass_move\.json', taskpage_jobs.mass_move),
    url(r'^preview$', taskpage_jobs.generate_preview),

    url(r'^projectpage/', include('projectpage.urls')),
    url(r'^online/', include('onlinepage.urls')),

    url(r'^api/', include('api.urls')),
    url(r'^bb/daylyjobsperproject.csv', daily_jobs_per_project),
    url(r'^bb/daylymobilejobsperproject.csv', daily_mobilejobs_per_project),

    url(r'^api/monitoring/', include('monitoring.api_urls')),
    url(r'^compare/', include('comparepage.urls')),
    url(r'^mobilecompare/', include('mobilecompare.urls')),
    url(r'^mobileregress/', include('mobileregression.urls')),
    url(r'^mobilefirestarter/', include('mobilefirestarter.urls')),
    url(r'^(\d+)/?$', offlinepage),
    url(r'^(\d+)/edit$', job_edit),
    url(r'^(\d+)/repeat$', repeat),
    url(r'^offlinepage/', include('offlinepage.urls')),
    url(r'^mobile/', include('mobilepage.urls')),
    url(r'^regress/', include('regression.urls')),
    url(r'^mainpage/', include('mainpage.urls')),
    url(r'^firestarter/', include('firestarter.urls')),
    url(r'^last/?', last),
    url(r'^lasta/?', active),
    url(r'^(\w+)$', project_page),
    url(r'^ui_set/', ui_set),
    url(r'^clear_compare/', clear_compare),
    url(r'^util/check_task', check_task),

    url(r'^st_favicon.ico$', get_st_favicon),

]

if DEBUG:
    urlpatterns += [
        url(r'^media/(?P<path>.*)$', serve, {'document_root': MEDIA_ROOT}),
    ]
