# coding: utf-8
from sqlalchemy import BigInteger, Boolean, CheckConstraint, Column, DateTime, Float, ForeignKey, Index, Integer, \
    Numeric, SmallInteger, String, Table, Text, text
from sqlalchemy.dialects.postgresql import OID
from sqlalchemy.orm import relationship
from sqlalchemy.ext.declarative import declarative_base

Base = declarative_base()
metadata = Base.metadata


class Ammo(Base):
    __tablename__ = 'ammo'

    id = Column(Integer, primary_key=True, server_default=text("nextval('ammo_id_seq'::regclass)"))
    author = Column(String(32), nullable=False)
    created_at = Column(DateTime, nullable=False)
    last_used = Column(DateTime, nullable=False)
    dsc = Column(String(128), nullable=False)
    path = Column(String(256), nullable=False)
    mdsum = Column(String(32), nullable=False)
    size = Column(Integer, nullable=False)
    flag = Column(SmallInteger, nullable=False)
    hidden = Column(SmallInteger, nullable=False)
    private = Column(SmallInteger, nullable=False)


class AuthGroup(Base):
    __tablename__ = 'auth_group'

    id = Column(Integer, primary_key=True, server_default=text("nextval('auth_group_id_seq'::regclass)"))
    name = Column(String(80), nullable=False, unique=True)


class AuthGroupPermission(Base):
    __tablename__ = 'auth_group_permissions'
    __table_args__ = (
        Index('auth_group_permissions_group_id_permission_id', 'group_id', 'permission_id', unique=True),
    )

    id = Column(Integer, primary_key=True, server_default=text("nextval('auth_group_permissions_id_seq'::regclass)"))
    group_id = Column(Integer, nullable=False, index=True)
    permission_id = Column(Integer, nullable=False, index=True)


class AuthPermission(Base):
    __tablename__ = 'auth_permission'
    __table_args__ = (
        Index('auth_permission_content_type_id_codename', 'content_type_id', 'codename', unique=True),
    )

    id = Column(Integer, primary_key=True, server_default=text("nextval('auth_permission_id_seq'::regclass)"))
    name = Column(String(255), nullable=False)
    content_type_id = Column(Integer, nullable=False, index=True)
    codename = Column(String(100), nullable=False)


class AuthUser(Base):
    __tablename__ = 'auth_user'

    id = Column(Integer, primary_key=True, server_default=text("nextval('auth_user_id_seq'::regclass)"))
    username = Column(String(150), nullable=False, unique=True)
    first_name = Column(String(30), nullable=False)
    last_name = Column(String(30), nullable=False)
    email = Column(String(254), nullable=False)
    password = Column(String(128), nullable=False)
    is_staff = Column(Boolean, nullable=False)
    is_active = Column(Boolean, nullable=False)
    is_superuser = Column(Boolean, nullable=False)
    last_login = Column(DateTime)
    date_joined = Column(DateTime, nullable=False)


class Badge(Base):
    __tablename__ = 'badges'

    id = Column(Integer, primary_key=True, server_default=text("nextval('badges_id_seq'::regclass)"))
    e_name = Column(String(64), nullable=False)
    r_name = Column(String(64), nullable=False)
    dsc = Column(String(1024), nullable=False)
    dsc_s = Column(String(1024), nullable=False)
    nums = Column(String(256))
    color = Column(String(7))


class CommonUisetting(Base):
    __tablename__ = 'common_uisettings'

    id = Column(Integer, primary_key=True, server_default=text("nextval('common_uisettings_id_seq'::regclass)"))
    person = Column(String(64), nullable=False)
    param = Column(String(256), nullable=False)
    onoff = Column(SmallInteger, nullable=False)


class Component(Base):
    __tablename__ = 'component'

    n = Column(Integer, primary_key=True, server_default=text("nextval('component_n_seq'::regclass)"))
    name = Column(String(128), nullable=False)
    dsc = Column(Text)
    priority = Column(Integer, nullable=False)
    include_qs = Column(String(128), nullable=False)
    exclude_qs = Column(String(128), nullable=False)
    job_order = Column(String(32), nullable=False)
    tag = Column(String(128))
    services_json = Column(Text)


class CustomUserReport(Base):
    __tablename__ = 'custom_user_report'

    n = Column(Integer, primary_key=True, server_default=text("nextval('custom_user_report_n_seq'::regclass)"))
    user = Column(String(64), nullable=False)
    name = Column(String(32), nullable=False)
    active = Column(SmallInteger, nullable=False)
    plots_json = Column(Text)


class DjangoContentType(Base):
    __tablename__ = 'django_content_type'
    __table_args__ = (
        Index('django_content_type_app_label_model', 'app_label', 'model', unique=True),
    )

    id = Column(Integer, primary_key=True, server_default=text("nextval('django_content_type_id_seq'::regclass)"))
    app_label = Column(String(100), nullable=False)
    model = Column(String(100), nullable=False)


class DjangoMigration(Base):
    __tablename__ = 'django_migrations'

    id = Column(Integer, primary_key=True, server_default=text("nextval('django_migrations_id_seq'::regclass)"))
    app = Column(String(255), nullable=False)
    name = Column(String(255), nullable=False)
    applied = Column(DateTime(True), nullable=False)


class DjangoSession(Base):
    __tablename__ = 'django_session'

    session_key = Column(String(40), primary_key=True)
    session_data = Column(Text, nullable=False)
    expire_date = Column(DateTime, nullable=False, index=True)


class DjangoSite(Base):
    __tablename__ = 'django_site'

    id = Column(Integer, primary_key=True, server_default=text("nextval('django_site_id_seq'::regclass)"))
    domain = Column(String(100), nullable=False)
    name = Column(String(50), nullable=False)


class JobMonitoringConfig(Base):
    __tablename__ = 'job_monitoring_config'

    id = Column(Integer, primary_key=True, server_default=text("nextval('job_monitoring_config_id_seq'::regclass)"))
    job_id = Column(Integer, index=True)
    contents = Column(Text)


class Kpi(Base):
    __tablename__ = 'kpi'

    n = Column(Integer, primary_key=True, server_default=text("nextval('kpi_n_seq'::regclass)"))
    component_id = Column(BigInteger, nullable=False)
    essential = Column(SmallInteger, nullable=False)
    dsc = Column(Text)
    ktype = Column(String(128), nullable=False)
    params_json = Column(Text)


class Loadscheme(Base):
    __tablename__ = 'loadscheme'

    n = Column(Integer, primary_key=True, server_default=text("nextval('loadscheme_n_seq'::regclass)"))
    up = Column(Integer, nullable=False)
    sec_from = Column(BigInteger, nullable=False)
    sec_to = Column(BigInteger, nullable=False)
    load_type = Column(BigInteger, nullable=False)
    load_from = Column(Float, nullable=False)
    load_to = Column(Float, nullable=False)
    dsc = Column(String(128), nullable=False)


class MobileApk(Base):
    __tablename__ = 'mobile_apk'

    id = Column(Integer, primary_key=True, server_default=text("nextval('mobile_apk_id_seq'::regclass)"))
    author = Column(String(32), nullable=False)
    created_at = Column(DateTime, nullable=False)
    dsc = Column(String(128), nullable=False)
    mdsum = Column(String(32), nullable=False)
    path = Column(String(256), nullable=False)
    size = Column(Integer, nullable=False)


class MobileApkTest(Base):
    __tablename__ = 'mobile_apk_tests'

    id = Column(Integer, primary_key=True, server_default=text("nextval('mobile_apk_tests_id_seq'::regclass)"))
    author = Column(String(32), nullable=False)
    created_at = Column(DateTime, nullable=False)
    dsc = Column(String(128), nullable=False)
    mdsum = Column(String(32), nullable=False)
    path = Column(String(256), nullable=False)
    size = Column(Integer, nullable=False)


class MobileDeviceStorage(Base):
    __tablename__ = 'mobile_device_storage'

    id = Column(Integer, primary_key=True, server_default=text("nextval('mobile_device_storage_id_seq'::regclass)"))
    device_serial = Column(String(120))
    location_type = Column(String(32))
    location_name = Column(String(120))
    modified = Column(DateTime, nullable=False)


class MobileJob(Base):
    __tablename__ = 'mobile_job'

    n = Column(Integer, primary_key=True, server_default=text("nextval('mobile_job_n_seq'::regclass)"))
    task = Column(String(120))
    test_id = Column(String(120))
    name = Column(String(120))
    dsc = Column(Text)
    fd = Column(DateTime, nullable=False)
    td = Column(DateTime)
    tank = Column(String(512))
    device_id = Column(String(512))
    device_model = Column(String(512))
    device_os = Column(String(512))
    app = Column(String(512))
    ver = Column(String(512))
    quit_status = Column(Integer)
    flag = Column(SmallInteger, nullable=False)
    component = Column(BigInteger)
    finalized = Column(SmallInteger, nullable=False)
    status = Column(String(32), nullable=False)
    person = Column(String(64))
    test_start = Column(BigInteger)
    sys_uts_offset = Column(BigInteger)
    log_uts_offset = Column(BigInteger)
    sync_sample = Column(BigInteger)
    version = Column(String(512))
    meta = Column(Text)


class MobilepageMobilecomponent(Base):
    __tablename__ = 'mobilepage_mobilecomponent'

    n = Column(Integer, primary_key=True, server_default=text("nextval('mobilepage_mobilecomponent_n_seq'::regclass)"))
    name = Column(String(128), nullable=False)
    dsc = Column(Text)
    job_order = Column(String(32), nullable=False)
    tag = Column(String(128))


class MonitoringMetric(Base):
    __tablename__ = 'monitoring_metric'

    id = Column(Integer, primary_key=True, server_default=text("nextval('monitoring_metric_id_seq'::regclass)"))
    name = Column(String(255), nullable=False)
    code = Column(String(100), nullable=False, index=True)
    description = Column(String(5000), nullable=False)
    created_at = Column(DateTime, nullable=False)
    modified_at = Column(DateTime, nullable=False)


class PandoraBinary(Base):
    __tablename__ = 'pandora_binary'

    id = Column(Integer, primary_key=True, server_default=text("nextval('pandora_binary_id_seq'::regclass)"))
    author = Column(String(32), nullable=False)
    created_at = Column(DateTime, nullable=False)
    last_used = Column(DateTime, nullable=False)
    dsc = Column(String(128), nullable=False)
    path = Column(String(256), nullable=False)
    mdsum = Column(String(32), nullable=False)
    size = Column(Integer, nullable=False)
    flag = Column(SmallInteger, nullable=False)
    hidden = Column(SmallInteger, nullable=False)
    private = Column(SmallInteger, nullable=False)


t_pg_stat_kcache = Table(
    'pg_stat_kcache', metadata,
    Column('datname', String),
    Column('reads', Numeric),
    Column('reads_blks', Numeric),
    Column('writes', Numeric),
    Column('writes_blks', Numeric),
    Column('user_time', Float(53)),
    Column('system_time', Float(53))
)


t_pg_stat_kcache_detail = Table(
    'pg_stat_kcache_detail', metadata,
    Column('query', Text),
    Column('datname', String),
    Column('rolname', String),
    Column('reads', BigInteger),
    Column('reads_blks', BigInteger),
    Column('writes', BigInteger),
    Column('writes_blks', BigInteger),
    Column('user_time', Float(53)),
    Column('system_time', Float(53))
)


t_pg_stat_statements = Table(
    'pg_stat_statements', metadata,
    Column('userid', OID),
    Column('dbid', OID),
    Column('queryid', BigInteger),
    Column('query', Text),
    Column('calls', BigInteger),
    Column('total_time', Float(53)),
    Column('min_time', Float(53)),
    Column('max_time', Float(53)),
    Column('mean_time', Float(53)),
    Column('stddev_time', Float(53)),
    Column('rows', BigInteger),
    Column('shared_blks_hit', BigInteger),
    Column('shared_blks_read', BigInteger),
    Column('shared_blks_dirtied', BigInteger),
    Column('shared_blks_written', BigInteger),
    Column('local_blks_hit', BigInteger),
    Column('local_blks_read', BigInteger),
    Column('local_blks_dirtied', BigInteger),
    Column('local_blks_written', BigInteger),
    Column('temp_blks_read', BigInteger),
    Column('temp_blks_written', BigInteger),
    Column('blk_read_time', Float(53)),
    Column('blk_write_time', Float(53))
)


t_pg_stat_ucache = Table(
    'pg_stat_ucache', metadata,
    Column('uid', BigInteger),
    Column('calls', BigInteger),
    Column('reads', BigInteger),
    Column('reads_blks', BigInteger),
    Column('writes', BigInteger),
    Column('writes_blks', BigInteger),
    Column('user_time', Float(53)),
    Column('system_time', Float(53))
)


class Server(Base):
    __tablename__ = 'server'

    n = Column(Integer, primary_key=True, server_default=text("nextval('server_n_seq'::regclass)"))
    host = Column(String(128), nullable=False)
    is_test = Column(SmallInteger)
    fd = Column(DateTime, nullable=False, server_default=text('now()'))
    td = Column(DateTime)
    config = Column(Text)
    dsc = Column(Text)
    last_ip = Column(String(20))
    last_dc = Column(Integer)


class SouthMigrationhistory(Base):
    __tablename__ = 'south_migrationhistory'

    id = Column(Integer, primary_key=True, server_default=text("nextval('south_migrationhistory_id_seq'::regclass)"))
    app_name = Column(String(255), nullable=False)
    migration = Column(String(255), nullable=False)
    applied = Column(DateTime, nullable=False)


class Task(Base):
    __tablename__ = 'task'

    n = Column(Integer, primary_key=True, server_default=text("nextval('task_n_seq'::regclass)"))
    key = Column(String(64))


class TaskServer(Base):
    __tablename__ = 'task_server'

    n = Column(Integer, primary_key=True, server_default=text("nextval('task_server_n_seq'::regclass)"))
    openstack_id = Column(String(64))
    status = Column(String(16))
    task = Column(String(120))


class TastypieApiacces(Base):
    __tablename__ = 'tastypie_apiaccess'
    __table_args__ = (
        CheckConstraint('accessed >= 0'),
    )

    id = Column(Integer, primary_key=True, server_default=text("nextval('tastypie_apiaccess_id_seq'::regclass)"))
    identifier = Column(String(255), nullable=False)
    url = Column(String(255), nullable=False)
    request_method = Column(String(10), nullable=False)
    accessed = Column(Integer, nullable=False)


class UploadToken(Base):
    __tablename__ = 'upload_token'

    n = Column(Integer, primary_key=True, server_default=text("nextval('upload_token_n_seq'::regclass)"))
    job = Column(BigInteger)
    token = Column(String(64), nullable=False)


class Achieve(Base):
    __tablename__ = 'achieve'

    id = Column(Integer, primary_key=True, server_default=text("nextval('achieve_id_seq'::regclass)"))
    badge_id = Column(ForeignKey('badges.id'), nullable=False, index=True)
    num = Column(BigInteger)
    fd = Column(DateTime, nullable=False)
    td = Column(DateTime)
    type = Column(Integer, nullable=False)
    wfor = Column(BigInteger, nullable=False)
    user_id = Column(ForeignKey('auth_user.id'), index=True)

    badge = relationship('Badge')
    user = relationship('AuthUser')


class DeletedJob(Base):
    __tablename__ = 'deleted_job'

    n = Column(Integer, primary_key=True)
    fd = Column(DateTime, nullable=False, server_default=text('now()'))
    td = Column(DateTime)
    person = Column(String(32))
    name = Column(String(120))
    dsc = Column(Text)
    tank = Column(ForeignKey('server.n'), index=True)
    command_line = Column(String(512))
    ammo_path = Column(String(256))
    loop_cnt = Column(Float)
    quit_status = Column(SmallInteger)
    srv = Column(ForeignKey('server.n'), index=True)
    srv_port = Column(BigInteger, nullable=False)
    instances = Column(BigInteger, nullable=False)
    flag = Column(SmallInteger)
    component = Column(BigInteger, nullable=False)
    ver = Column(String(120))
    configinfo = Column(Text)
    finalized = Column(SmallInteger, nullable=False)
    status = Column(String(32), nullable=False)
    configinitial = Column(Text)
    task = Column(String(120))

    server = relationship('Server', primaryjoin='DeletedJob.srv == Server.n')
    server1 = relationship('Server', primaryjoin='DeletedJob.tank == Server.n')


class DjangoAdminLog(Base):
    __tablename__ = 'django_admin_log'

    id = Column(Integer, primary_key=True, server_default=text("nextval('django_admin_log_id_seq'::regclass)"))
    action_time = Column(DateTime, nullable=False)
    user_id = Column(ForeignKey('auth_user.id'), nullable=False, index=True)
    content_type_id = Column(ForeignKey('django_content_type.id'), index=True)
    object_id = Column(Text)
    object_repr = Column(String(200), nullable=False)
    action_flag = Column(Integer, nullable=False)
    change_message = Column(Text, nullable=False)

    content_type = relationship('DjangoContentType')
    user = relationship('AuthUser')


class FirestarterJobtank(Base):
    __tablename__ = 'firestarter_jobtank'

    id = Column(Integer, primary_key=True, server_default=text("nextval('firestarter_jobtank_id_seq'::regclass)"))
    job_id = Column(BigInteger, nullable=False)
    tank = Column(ForeignKey('server.n'), index=True)

    server = relationship('Server')


class Job(Base):
    __tablename__ = 'job'

    n = Column(Integer, primary_key=True, index=True, server_default=text("nextval('job_n_seq'::regclass)"))
    fd = Column(DateTime, nullable=False, server_default=text('now()'))
    td = Column(DateTime)
    person = Column(String(64))
    name = Column(String(120))
    dsc = Column(Text)
    tank = Column(ForeignKey('server.n'), index=True)
    command_line = Column(String(512))
    ammo_path = Column(String(256))
    loop_cnt = Column(Float)
    quit_status = Column(SmallInteger)
    srv = Column(ForeignKey('server.n'), index=True)
    srv_port = Column(BigInteger, nullable=False)
    instances = Column(BigInteger, nullable=False)
    flag = Column(SmallInteger, nullable=False)
    component = Column(ForeignKey('component.n'), nullable=False, index=True)
    ver = Column(String(120))
    configinfo = Column(Text)
    finalized = Column(SmallInteger, nullable=False)
    status = Column(String(32), nullable=False)
    configinitial = Column(Text)
    task = Column(String(120))

    component1 = relationship('Component')
    server = relationship('Server', primaryjoin='Job.srv == Server.n')
    server1 = relationship('Server', primaryjoin='Job.tank == Server.n')


class TastypieApikey(Base):
    __tablename__ = 'tastypie_apikey'

    id = Column(Integer, primary_key=True, server_default=text("nextval('tastypie_apikey_id_seq'::regclass)"))
    user_id = Column(ForeignKey('auth_user.id', deferrable=True, initially='DEFERRED'), nullable=False, unique=True)
    key = Column(String(256), nullable=False, index=True)
    created = Column(DateTime(True), nullable=False)

    user = relationship('AuthUser', uselist=False)


class Thank(Base):
    global text
    __tablename__ = 'thanks'

    id = Column(Integer, primary_key=True, server_default=text("nextval('thanks_id_seq'::regclass)"))
    date = Column(DateTime, nullable=False)
    text = Column(Text, nullable=False)
    job_id = Column(Integer)
    to_user_id = Column(ForeignKey('auth_user.id'), index=True)
    from_user_id = Column(ForeignKey('auth_user.id'), index=True)

    from_user = relationship('AuthUser', primaryjoin='Thank.from_user_id == AuthUser.id')
    to_user = relationship('AuthUser', primaryjoin='Thank.to_user_id == AuthUser.id')


class Artifact(Base):
    __tablename__ = 'artifact'

    id = Column(Integer, primary_key=True, server_default=text("nextval('artifact_id_seq'::regclass)"))
    job_id = Column(ForeignKey('job.n'), nullable=False, index=True)
    storage_key = Column(String(256), nullable=False)

    job = relationship('Job')


class CommonTankuseragent(Base):
    __tablename__ = 'common_tankuseragent'

    id = Column(Integer, primary_key=True, server_default=text("nextval('common_tankuseragent_id_seq'::regclass)"))
    job_id = Column(ForeignKey('job.n'), nullable=False, index=True)
    user_agent = Column(String(512), nullable=False)

    job = relationship('Job')


class JobEvent(Base):
    __tablename__ = 'job_event'

    id = Column(Integer, primary_key=True, server_default=text("nextval('job_event_id_seq'::regclass)"))
    job_id = Column(ForeignKey('job.n'), nullable=False, index=True)
    text = Column(Text)
    author = Column(String(32))
    timestamp = Column(DateTime)
    tag = Column(String(512))

    job = relationship('Job')


class JobImbalance(Base):
    __tablename__ = 'job_imbalance'

    n = Column(Integer, primary_key=True, server_default=text("nextval('job_imbalance_n_seq'::regclass)"))
    up = Column(ForeignKey('job.n'), nullable=False, index=True)
    hum_isimbalance = Column(Integer, nullable=False)
    hum_imbalance = Column(Integer, nullable=False)
    rob_isimbalance = Column(Integer, nullable=False)
    rob_warning_sec = Column(Integer, nullable=False)
    rob_imbalance = Column(Integer, nullable=False)
    rob_imbalance_sec = Column(Integer, nullable=False)
    hum_processed = Column(Integer, nullable=False)
    user = Column(String(64))

    job = relationship('Job')


class JobTrail(Base):
    __tablename__ = 'job_trail'

    n = Column(Integer, primary_key=True, server_default=text("nextval('job_trail_n_seq'::regclass)"))
    up = Column(ForeignKey('job.n'), nullable=False, index=True)
    min_rps = Column(Integer)
    max_rps = Column(Integer)
    http = Column(String(64), nullable=False)
    net = Column(Integer, nullable=False)
    trail_start = Column(DateTime)
    trail_stop = Column(DateTime)
    avg_expect = Column(Float(53))
    avg_connect_time = Column(Float(53))
    avg_send_time = Column(Float(53))
    avg_latency = Column(Float(53))
    avg_receive_time = Column(Float(53))
    q50 = Column(Float(53))
    q75 = Column(Float(53))
    q80 = Column(Float(53))
    q85 = Column(Float(53))
    q90 = Column(Float(53))
    q95 = Column(Float(53))
    q98 = Column(Float(53))
    q99 = Column(Float(53))
    avg_resps = Column(Float(53))

    job = relationship('Job')


class MobileDataKey(Base):
    __tablename__ = 'mobile_data_key'

    id = Column(Integer, primary_key=True, server_default=text("nextval('mobile_data_key_id_seq'::regclass)"))
    job_id = Column(ForeignKey('job.n'), nullable=False, index=True)
    mobile_data_key = Column(String(256), nullable=False)

    job = relationship('Job')


class RegressionComment(Base):
    __tablename__ = 'regression_comment'

    id = Column(Integer, primary_key=True, server_default=text("nextval('regression_comment_id_seq'::regclass)"))
    job_id = Column(ForeignKey('job.n'), nullable=False, index=True)
    text = Column(String(256))
    author = Column(String(32), nullable=False)
    created_at = Column(DateTime)

    job = relationship('Job')
