module.exports = {
    title:  {
        text: `Тестирующие потоки`,
    },
    xAxis: {
        type: 'datetime',
        labels: {
            formatter: function(){
                return moment.unix(this.value).format("HH:mm:ss")
            }
        },
    },
    yAxis: [{ 
        title: {
         text: 'instances, count'
      }
    }, { 
        title: {
           text: 'rps'
     },
    opposite: true
    }],
    tooltip: {
        shared: true,
        formatter: function () {
            return this.points.reduce(function (s, point) {
                return s + '<br/><span style="color: ' + point.series.color + ';">' + point.series.name + '</span>: <b>' + point.y + '</b>'
            }, '<b>' + moment.unix(this.x).format("HH:mm:ss") + '</b>');
        },
    },
    plotOptions: {
        line: {
            pointStart: 1940,
            marker: {
                enabled: false,
                symbol: 'circle',
                radius: 1,
                states: {
                    hover: {
                        enabled: true
                    }
                }
            },
            states: {
                hover: {
                    lineWidthPlus: 0,
                },
            }
        }
    },
};
