const protoResult = ChartEditor.getLoadedData().lunapark_api;
var params = ChartEditor.getParams()
//console.log('Data', protoResult);

var series = [];

Object.keys(protoResult.cases[params.case_id]).forEach((code) => {
    switch (code[0]) {
        case "0":
            color = 'grey'
            visible = true
            break;
        case "2":
            color = 'green'
            visible = false
            break;
        case "3":
            color = 'teal'
            visible = true
            break;
        case "4":
            color = 'yellow'
            visible = true
            break;
        default:
            color = 'red'
            visible = true
    }
    series.push(
        {
            yAxis: 0,
            type: 'area',
            name: code,
            data: protoResult.cases[params.case_id][code],
            color: color,         
            visible: visible,
        }
    )
});

series.push({
        yAxis: 1,
        type: 'line',
        id: 'rps',
        title: 'rps',
        color: 'brown',
        opacity: 1,
        data: protoResult.responses_per_second
    }
);


module.exports  = {
    graphs: series,
    categories_ms: protoResult.ts
}
