

rts = {
    colors: ['#b2b8c8',
                '#7cb3f1',
                '#8bbc21',
                '#66af5f',
                '#b8e13d',
                '#e9f66e',
                '#f2ce65',
                '#fca43f',
                '#fe8233'],
    title:  {
        text: `Квантили времен ответов`,
    },
    xAxis: {
        type: 'datetime',
        labels: {
            formatter: function(){
                return moment.unix(this.value).format("HH:mm:ss")
            }
        },
    },
    yAxis: [{ 
        title: {
         text: 'ms'
      },
    }, { 
        title: {
         text: 'rps'
      },
    opposite: true
    }],
    tooltip: {
        shared: true,
        formatter: function () {
            return this.points.reduce(function (s, point) {
                return s + '<br/><span style="color: ' + point.series.color + ';">' + point.series.name + '</span>: <b>' + point.y + '</b>'
            }, '<b>' + moment.unix(this.x).format("HH:mm:ss") + '</b>');
        },
    },
    plotOptions: {
        series: {
            opacity: 0.8,            
        },
        area: {
            pointStart: 1940,
            marker: {
                enabled: false,
                symbol: 'circle',
                radius: 1,
                states: {
                    hover: {
                        enabled: true
                    }
                }
            },
            states: {
                hover: {
                    lineWidthPlus: 0,
                },
            }
        }
    },
};
