const moment = require('vendor/moment/v2.21');
const jobResult = ChartEditor.getLoadedData().lunapark_api;
//console.log('Data', jobResult);

var jobs = [];

jobResult.jobs.forEach((item) => {
    jobs.push({
          title: item.job + '-' + item.name + ' ' + moment.unix(item.date).format("DD/MM/YYYY HH:mm:ss"),
          value: item.job,
    });
});

module.exports = [
    {
        type: 'select',
        param: 'job_id',        
        label: 'Стрельбы в тикете',        
        width: '640px',
        multiselect: false,        
        // добавить поисковую строку 
        // по умолчанию: true
        searchable: true,        
        // cодержимое селекта    
        content: jobs,      
        updateOnChange: true,
        // updateControlsOnChange: true
    }
]
