const tableResult = ChartEditor.getLoadedData().lunapark_api;
const params = ChartEditor.getParams()

//пример выдачи для тестирования
/*tableResult = {
"cases": {
    "overall": {"0":{"amount":60.0,"percentage":60.0}, "200":{"amount":40.0,"percentage":40.0}},
    "case1": {"0":{"amount":0.0,"percentage":0.0}, "200":{"amount":40.0,"percentage":100.0}},
    "case2": {"0":{"amount":60.0,"percentage":100.0}, "200":{"amount":0.0,"percentage":0.0}},
},
"codes": ["0", "200"]
}*/

//console.log('data', tableResult)
const head = [
    {
        id: 'сode',
        name: 'Код',
        type: 'text',
        css: {
            'font-weight': 'bold'
        }
    },
    {
        id: 'ammount',
        name: 'Кол-во',
        type: 'number',
        formatter: {
            precision: 0
        },
        css: {
            'font-weight': 'bold'
        }
    },
    {
        id: 'percentage',
        name: 'Доля',
        type: 'number',
        formatter: {
            suffix: '%',
            precision: 3
        },
        css: {
            'font-weight': 'bold'
        }
    }
]

const rows = []

Object.keys(tableResult.cases[params.case_id]).forEach((code) => {
    rows.push({
        cells:[
            {
                value: code,
                css: { 
                    'font-weight': 600,
                }
            },
            {
                value: tableResult.cases[params.case_id][code].amount,
            },
            {
                value: tableResult.cases[params.case_id][code].percentage,
            }            
        ]
    });
});

module.exports = {head, rows};

