def get_monitoring_data(client, job, from_time=None, to_time=None):
    """
    Retrieve monitoring data from Clickhouse.
    Returns pandas dataframe with all metrics for job in query.
    """
    sql_query = '''
    select toUnixTimestamp(time) as ts, target_host, metric_type, metric_name, value
    from monitoring_verbose_data_buffer
    where job_id = %(job_id)d'''
    query_params = {'job_id': job.n}

    if from_time is not None:
        sql_query += ''' and time >= toDateTime(%(from_time)d)'''
        query_params['from_time'] = from_time
    if to_time is not None:
        sql_query += ''' and time <= toDateTime(%(to_time)d)'''
        query_params['to_time'] = to_time

    return client.query_dataframe(sql_query, query_params)
