import flask


__all__ = ('init_plugin',)


openapi_bp = flask.Blueprint('redoc', __name__)


@openapi_bp.route("/api/v3/swagger.json")
def swagger_json():
    from load.projects.lunaparkapi.web import api
    return flask.jsonify(api.v3.Api.dict)


def init_plugin(app):
    app.register_blueprint(openapi_bp)
