from six.moves.urllib import parse as urlparse

from sandbox.common import api as common_api


def server_url(settings=None):
    if not settings:
        settings = {}
    return str('https://{host}:{port}'.format(host='', port=''))


url = urlparse.urlparse(server_url())
host = url.netloc
schemes = [url.scheme]


class Api(common_api.Api):
    swagger = '2.0'
    schemes = schemes
    host = host
    basePath = ''
    info = dict(
        title='Lunapark API',
        description='Lunapark API',
        contact=dict(email='load@yandex-team.ru'),
        version='0.1'
    )
    consumes = ['application/json; charset=utf-8']
    produces = ['application/json; charset=utf-8']
