from sandbox.common import api as common_api

from .api import Api
from . import schemas


class Job(Api.Path('/job/{id}')):

    class Get(common_api.Get):
        """ Job detailed info """
        id = common_api.Id('Job id', scope=common_api.Scope.PATH)

    class Ok(common_api.Response):
        schema = schemas.job.Job

    class NotFound(common_api.Response):
        """ Job not found """
