from sandbox.common import api as common_api
from ..api import Api


class JobBase(Api.Schema):
    """Base class for jobs"""
    id = common_api.Id()
    name = common_api.String('Job name')


class Job(JobBase):
    """ Job base fields """

    fd = common_api.DateTime('Job start time')
    td = common_api.DateTime('Job end time')
    person = common_api.String('Job author')
    task = common_api.String('Job corresponding ticket')
    is_online = common_api.Boolean('Is job online')
    cases = common_api.Array(common_api.String, '')  # TODO make separate class for Case
    scheme_type = common_api.String('Loadscheme type')  # TODO make enum
