from ticket_parser2.api.v1 import BlackboxClientId
from tvm2 import TVM2
from load.projects.lunaparkapi.settings import base


tvm_client = TVM2(
    client_id=base['TVM_ID'],
    secret=base['TVM_SECRET'],
    allowed_clients=('*',),
    blackbox_client=BlackboxClientId.ProdYateam,
    destinations=(223,),
    )


def get_blackbox_service_ticket():
    return tvm_client.get_service_ticket(base['BLACKBOX_TVM_ID'])
