from setuptools import setup, find_packages

setup(
    name='tankapi',
    version='1.9.9',
    description='HTTP API for Yandex.Tank',
    author='Alexey Lavrenuke (load testing)',
    author_email='direvius@yandex-team.ru',
    maintainer='Yandex Load team',
    maintainer_email='load@yandex-team.ru',
    packages=find_packages(exclude=["tests", "tmp", "docs", "data"]),
    install_requires=[
        'yandextank>=1.11.0',
    ],
    setup_requires=[
        'pytest-runner',
    ],
    tests_require=[
        'pytest',
    ],
    license='LGPLv2',
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Environment :: Console',
        'Environment :: Web Environment',
        'Intended Audience :: End Users/Desktop',
        'Intended Audience :: Developers',
        'Intended Audience :: System Administrators',
        'License :: OSI Approved :: GNU Lesser General Public License v2 or later (LGPLv2+)',
        'Operating System :: POSIX',
        'Topic :: Software Development :: Quality Assurance',
        'Topic :: Software Development :: Testing',
        'Topic :: Software Development :: Testing :: Traffic Generation',
        'Programming Language :: Python :: 2',
        'Programming Language :: Python :: 3',
    ],
    entry_points={
        'console_scripts': [
            'tankapi = tankapi.server.server:main',
            'tankapi-control = tankapi.server.control:main',
        ],
    },
    package_data={
        'tankapi.server': ['data/*'],
    },
    use_2to3=True, )
