(function (){
	'use strict';
	var job_n = $('#global-job-number').data('job');
	
	$('.b-editable').bind('mouseenter', function() {
		$('span#'+this.id+'_pencil').show();
	});
	$('.b-editable').bind('mouseleave', function() {
		$('span#'+this.id+'_pencil').hide();
	});
	
	$('.b-overload-offlinepage__action').on('click', function (event) {
		var button = $(this);
		var action = button.data('action');

		switch (action) {
			case 'remove':
				if (!confirm("Seriously? Delete test # "+job_n+"?")) {
					return false;
				}
				$.post('/deletejob.json', {
					"job_id" : job_n
				}).success(function(data) {
					if (data.status == "1") {
						window.location.href = "/";
					} 
				});
				break;
			case 'compare':
				var action = button.data('actiondetail');
				var url;
				if (action == 'add') {
                    url = '/compare/add_jobs'
                }
                else {
                    url = '/compare/remove_jobs'
                }
				$.post(url, {
					"jobs" : job_n,
				}).success(function(data) {
					if (action == 'add') {
						button.data('actiondetail', 'remove')
					}
					else {
						button.data('actiondetail', 'add')
					}
					button.toggleClass('text-muted');
					button.toggleClass('text-success');
					if (data) {
						if (data.status == "1") {
							$(".b_compare_count").html(data.count);
							if (data.count > 0) {
								$(".b_compare_count__delete").show();
							} else {
								$(".b_compare_count__delete").hide();
							}
						}
					}

				});
				break;
			case 'edit':
				window.location.href = job_n + "/edit";
				break;
			case 'star':
				$.post('/addtofav.json', {
					job_id : job_n
				}).success(function() {
					button.toggleClass('b-overload-offlinepage__action_active');
				});
				break;
			default:
				break;
		}
	});
	
	
	/*
	 * При клике на редактирование имени стрельбы
	 */
	$('.b-overload-offline-meta__title.b-editable').on('click', function(event) {
		$('.b-editable[data-action="edit-name"]').hide();
		$('.b_editname_block').show();
		$("#b_editname_block__firename__").val($('.b-editable[data-action="edit-name"]').text());
		$("#b_editname_block__firename__").focus();

		$("#b_editname_block__okey__").show();
		$("#b_editname_block__cancel__").show();
		$("#b_editname_block__ajax__").hide();
	});
	/*
	 * Завершение редактирования имени
	 */
	$('#b_editname_block__cancel__').on('click', function(event) {
		$('.b_editname_block').hide();
		$('.b-editable[data-action="edit-name"]').show();
	});
	/*
	 * Результат редактирования стрельбы
	 */
	$('#b_editname_block__okey__').on('click', function(event) {
		var text = $("#b_editname_block__firename__").val();
		var block = this;

		$("#b_editname_block__okey__").hide();
		$("#b_editname_block__cancel__").hide();
		$("#b_editname_block__ajax__").show();

		$.ajax("/api/jobedit_frontend?job_n="+job_n, {
			type : 'POST',
			dataType : 'json',
			data : {
				'name' : text
			},
			success : function(data) {
				if (data) {
					if (data.success == 1) {
						$('.b-editable[data-action="edit-name"]').text(text);
						$('.b_editname_block').hide();
						$('.b-editable[data-action="edit-name"]').show();
					} else {
						reterror(data.error);
					}
				} else {
					reterror('error');
				}

			},
			error : function() {
				reterror('error');
			}
		});
		var reterror = function(typeoferror) {
			$("#b_editname_block__okey__"+job_n).show();
			$("#b_editname_block__cancel__"+job_n).show();
			$("#b_editname_block__ajax__"+job_n).hide();
		};
	});

	/*
	 * Редактирование описания
	 */
	$('.b-overload-offline-meta__description.b-editable').on('click', function(event) {
		$('.b-editable[data-action="edit-dsc"]').hide();
		$('.b_editdsc_block').show();
		$("#b_editname_block__dsc__").val($('.b-editable[data-action="edit-dsc"]').text());
		$("#b_editname_block__dsc__").focus();

		$("#b_editdsc_block__okey__").show();
		$("#b_editdsc_block__cancel__").show();
		$("#b_editdsc_block__ajax__").hide();
	});

	$('#b_editdsc_block__cancel__').on('click', function(event) {
		$('.b_editdsc_block').hide();
		$('.b-editable[data-action="edit-dsc"]').show();
	});

	$('#b_editdsc_block__okey__').on('click', function(event) {
		var text = $("#b_editdsc_block__dsc__").val();
		var block = this;

		$("#b_editdsc_block__okey__").hide();
		$("#b_editdsc_block__cancel__").hide();
		$("#b_editdsc_block__ajax__").show();
		$.ajax("/api/jobedit_frontend?job_n="+job_n, {
			type : 'POST',
			dataType : 'json',
			data : {
				'description' : text
			},
			success : function(data) {
				if (data) {
					if (data.success == 1) {
						$('.b-editable[data-action="edit-dsc"]').text(text);
						$('.b_editdsc_block').hide();
						$('.b-editable[data-action="edit-dsc"]').show();
					} else {
						reterror(data.error);
					}
				} else {
					console.log('error')
				}
			},
			error : function() {
				console.log('error')
			}
		});
		var reterror = function(typeoferror) {
			$("#b_editdsc_block__okey__").show();
			$("#b_editdsc_block__cancel__").show();
			$("#b_editdsc_block__ajax__").hide();
		};
	});
	
})();