# -*- coding: utf-8 -*-

from django.conf.urls import url

from .views.jobclose import JobClose
from .views.jobconfiginfo import JobConfigInfo
from .views.jobcreate import JobCreate
from .views.jobmetainfo import JobMetaInfo
from .views.jobtrailpush import JobTrailPush
from .views.jobsetimbalance import JobSetImbalance
from .views.jobmonitoringconfig import JobMonitoringConfig
from .views.jobconfiginitial import JobConfigInitial

from .views.check_upload_token import CheckUploadToken
from .views.get_api_token import get_api_token
from .views.jobclose import jobclose_frontend
from .views.jobmetainfo import jobedit_frontend
from .views.jobconfiginfo import job_configinfo
from .views.jobsonline import jobs_online
from .views.jobsoffline import jobs_offline

from .views.customreportdelete import delete_custom_report
from .views.customreportadd import add_custom_report
from .views.hide_notification import hide_notification

urlpatterns = [
    url(r'^job/(\d+)/configinfo\.(txt)', JobConfigInfo.as_view()),
    url(r'^job/(\d+)/configinitial\.(txt)', JobConfigInitial.as_view()),
    url(r'^job/(\d+)/jobmonitoringconfig\.(txt)', JobMonitoringConfig.as_view()),
    url(r'^job/(\d+)/edit.(json)', JobMetaInfo.as_view()),
    url(r'^job/(\d+)/close.(json)', JobClose.as_view()),
    url(r'^job/(\d+)/push_data.(json)$', JobTrailPush.as_view()),
    url(r'^job/(\d+)/check_upload_token.(json)$', CheckUploadToken.as_view()),
    url(r'^job/(\d+)/set_imbalance.(json)', JobSetImbalance.as_view()),
    url(r'^job/create.(json)$', JobCreate.as_view()),
    url(r'^delete_custom_report', delete_custom_report),
    url(r'^add_custom_report', add_custom_report),
    url(r'^hide_notification.json', hide_notification),
    url(r'^get_api_token.json', get_api_token),

    url(r'jobclose_frontend', jobclose_frontend),
    url(r'jobedit_frontend', jobedit_frontend),
    url(r'job_configinfo', job_configinfo),
    url(r'^job/online.(json|xml|csv|csvs)$', jobs_online),
    url(r'^job/offline.(json|xml|csv|csvs)$', jobs_offline),
]
