"""
Created on Jun 26, 2016

@author: noob
"""

from common.models import ApiToken
from django.contrib.auth.decorators import login_required
from django.http import HttpResponse
from json import dumps


@login_required
def get_api_token(request):
    api_token = ApiToken.objects.get_or_create(user=request.user)[0]
    return HttpResponse(dumps({
        'token': api_token.token if api_token.approved else '',
        'approved': api_token.approved,
    }),
        content_type='application/json')
