from django.core.management.base import BaseCommand
from common.util import parse_duration
import time
from json import dumps


class Command(BaseCommand):
    help = ''

    def add_arguments(self, parser):
        parser.add_argument(
            '--text',
            default='',
            help='Enter notification text',
        )

        parser.add_argument(
            '--exp',
            default='1d',
            help='Expiration period for notification (defaults to 1d)',
        )

    def handle(self, *args, **options):
        text = options['text']
        expire = options['exp']

        now = time.time()
        expire = now + parse_duration(str(expire))

        with open('/tmp/notification', 'w') as notifile:
            notifile.write(dumps({'text': text,
                                  'expire': int(expire),
                                  'author': 'admin_shell',
                                  })
                           )