# -*- coding: utf-8 -*-
# Generated by Django 1.11.8 on 2018-03-15 02:27
from __future__ import unicode_literals

import datetime
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='ApiToken',
            fields=[
                ('n', models.AutoField(primary_key=True, serialize=False)),
                ('token', models.CharField(default=b'', max_length=64)),
                ('created', models.DateTimeField(default=datetime.datetime.now)),
                ('expires', models.DateTimeField(null=True)),
                ('approved', models.PositiveSmallIntegerField(default=1, verbose_name=1)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'user_api_token',
            },
        ),
        migrations.CreateModel(
            name='CustomUserReport',
            fields=[
                ('n', models.AutoField(primary_key=True, serialize=False)),
                ('user', models.CharField(max_length=64)),
                ('name', models.CharField(max_length=32)),
                ('active', models.PositiveSmallIntegerField(default=1, verbose_name=1)),
                ('plots_json', models.TextField(null=1)),
            ],
            options={
                'db_table': 'custom_user_report',
            },
        ),
        migrations.CreateModel(
            name='DeletedJob',
            fields=[
                ('n', models.PositiveIntegerField(primary_key=True, serialize=False)),
                ('fd', models.DateTimeField(default=datetime.datetime.now)),
                ('td', models.DateTimeField(null=1)),
                ('name', models.CharField(default=b'', max_length=120, null=1)),
                ('dsc', models.TextField(null=1)),
                ('type', models.PositiveSmallIntegerField(default=b'1', verbose_name=3)),
                ('command_line', models.CharField(max_length=512, null=1)),
                ('ammo_path', models.CharField(max_length=256, null=1)),
                ('loop_cnt', models.FloatField(null=1)),
                ('quit_status', models.PositiveSmallIntegerField(null=1, verbose_name=1)),
                ('test_type', models.PositiveSmallIntegerField(default=0, null=1, verbose_name=1)),
                ('srv_port', models.PositiveIntegerField(default=0, verbose_name=8)),
                ('instances', models.PositiveIntegerField(verbose_name=8)),
                ('flag', models.PositiveSmallIntegerField(default=0, verbose_name=1)),
                ('ver', models.CharField(max_length=120, null=1)),
                ('configinfo', models.TextField(default=b'', null=1)),
                ('finalized', models.PositiveSmallIntegerField(default=1, verbose_name=1)),
            ],
            options={
                'db_table': 'deleted_job',
            },
        ),
        migrations.CreateModel(
            name='Job',
            fields=[
                ('n', models.AutoField(primary_key=True, serialize=False)),
                ('fd', models.DateTimeField(default=datetime.datetime.now)),
                ('td', models.DateTimeField(null=1)),
                ('name', models.CharField(default=b'', max_length=120)),
                ('dsc', models.TextField(null=1)),
                ('type', models.PositiveSmallIntegerField(default=b'1', verbose_name=3)),
                ('command_line', models.CharField(max_length=512, null=1)),
                ('ammo_path', models.CharField(max_length=256, null=1)),
                ('loop_cnt', models.FloatField(null=1)),
                ('quit_status', models.PositiveSmallIntegerField(null=1, verbose_name=1)),
                ('test_type', models.PositiveSmallIntegerField(default=0, null=1, verbose_name=1)),
                ('srv_port', models.PositiveIntegerField(default=0, null=1, verbose_name=8)),
                ('instances', models.PositiveIntegerField(verbose_name=8)),
                ('flag', models.PositiveSmallIntegerField(default=0, verbose_name=1)),
                ('ver', models.CharField(max_length=120, null=1)),
                ('configinfo', models.TextField(null=1)),
                ('finalized', models.PositiveSmallIntegerField(default=1, verbose_name=1)),
            ],
            options={
                'db_table': 'job',
            },
        ),
        migrations.CreateModel(
            name='JobComment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('job', models.PositiveIntegerField(null=0)),
                ('author', models.CharField(max_length=64, null=1)),
                ('text', models.TextField(null=1)),
                ('reply', models.PositiveSmallIntegerField(default=0, verbose_name=1)),
                ('thread', models.PositiveIntegerField(null=0, verbose_name=8)),
                ('created_at', models.DateTimeField(default=datetime.datetime.now)),
                ('edited_at', models.DateTimeField(null=1)),
            ],
            options={
                'db_table': 'job_comment',
            },
        ),
        migrations.CreateModel(
            name='JobImbalance',
            fields=[
                ('n', models.AutoField(primary_key=True, serialize=False)),
                ('hum_isimbalance', models.IntegerField(default=0, verbose_name=1)),
                ('hum_imbalance', models.IntegerField(default=0, verbose_name=8)),
                ('rob_isimbalance', models.IntegerField(default=0, verbose_name=1)),
                ('rob_warning_sec', models.IntegerField(default=0, verbose_name=8)),
                ('rob_imbalance', models.IntegerField(default=0, verbose_name=8)),
                ('rob_imbalance_sec', models.IntegerField(default=0, verbose_name=8)),
                ('hum_processed', models.IntegerField(default=0, verbose_name=1)),
                ('user', models.CharField(max_length=64, null=1)),
                ('up', models.ForeignKey(db_column=b'up', on_delete=django.db.models.deletion.CASCADE, to='common.Job')),
            ],
            options={
                'db_table': 'job_imbalance',
            },
        ),
        migrations.CreateModel(
            name='LoadScheme',
            fields=[
                ('n', models.AutoField(primary_key=True, serialize=False)),
                ('sec_from', models.PositiveIntegerField(verbose_name=10)),
                ('sec_to', models.PositiveIntegerField(verbose_name=10)),
                ('load_type', models.PositiveIntegerField(verbose_name=2)),
                ('load_from', models.FloatField(verbose_name=2)),
                ('load_to', models.FloatField(verbose_name=2)),
                ('dsc', models.CharField(max_length=128)),
                ('up', models.ForeignKey(db_column=b'up', on_delete=django.db.models.deletion.CASCADE, to='common.Job')),
            ],
            options={
                'db_table': 'loadscheme',
            },
        ),
        migrations.CreateModel(
            name='Project',
            fields=[
                ('n', models.AutoField(primary_key=True, serialize=False)),
                ('owner', models.CharField(max_length=64)),
                ('name', models.CharField(default=b'default', max_length=120)),
            ],
            options={
                'db_table': 'project',
            },
        ),
        migrations.CreateModel(
            name='Server',
            fields=[
                ('n', models.AutoField(primary_key=True, serialize=False)),
                ('host', models.CharField(max_length=128)),
                ('is_test', models.PositiveSmallIntegerField(default=0, verbose_name=1)),
                ('fd', models.DateTimeField(default=datetime.datetime.now)),
                ('td', models.DateTimeField(null=1)),
                ('config', models.TextField(null=1)),
                ('dsc', models.TextField(null=1)),
                ('last_ip', models.CharField(default=b'', max_length=20)),
                ('last_dc', models.SmallIntegerField(default=0, verbose_name=2)),
            ],
            options={
                'db_table': 'server',
            },
        ),
        migrations.CreateModel(
            name='UISettings',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('param', models.CharField(max_length=256)),
                ('onoff', models.PositiveSmallIntegerField(default=1, verbose_name=1)),
                ('user', models.ForeignKey(null=1, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='UploadToken',
            fields=[
                ('n', models.AutoField(primary_key=True, serialize=False)),
                ('job', models.BigIntegerField(null=True, verbose_name=10)),
                ('token', models.CharField(default=b'', max_length=64)),
            ],
            options={
                'db_table': 'upload_token',
            },
        ),
        migrations.AddField(
            model_name='job',
            name='project',
            field=models.ForeignKey(db_column=b'project', on_delete=django.db.models.deletion.CASCADE, to='common.Project'),
        ),
        migrations.AddField(
            model_name='job',
            name='srv',
            field=models.ForeignKey(db_column=b'srv', on_delete=django.db.models.deletion.CASCADE, related_name='target_job', to='common.Server'),
        ),
        migrations.AddField(
            model_name='job',
            name='tank',
            field=models.ForeignKey(db_column=b'tank', on_delete=django.db.models.deletion.CASCADE, related_name='tank_job', to='common.Server'),
        ),
        migrations.AddField(
            model_name='job',
            name='user',
            field=models.ForeignKey(null=1, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='deletedjob',
            name='srv',
            field=models.ForeignKey(db_column=b'srv', on_delete=django.db.models.deletion.CASCADE, related_name='srv', to='common.Server'),
        ),
        migrations.AddField(
            model_name='deletedjob',
            name='tank',
            field=models.ForeignKey(db_column=b'tank', on_delete=django.db.models.deletion.CASCADE, related_name='tank', to='common.Server'),
        ),
        migrations.AddField(
            model_name='deletedjob',
            name='user',
            field=models.ForeignKey(null=1, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
    ]
