# -*- coding: utf-8 -*-

from django.conf.urls import include, url
from settings import DEBUG
from django.contrib import admin
from django.conf import settings
from django.views.generic.base import RedirectView

from offlinepage.views.offlinepage import addtofav, deletejob, offlinepage, job_edit
from mainpage.views.mainpage import generate_preview, mainpage, home, validation_sent, logout, done, ajax_auth, \
    require_email
from api.views.maintenance import maintenance
from common.views import ui_set, ping
from django.conf.urls.static import static

admin.autodiscover()

import warnings
warnings.filterwarnings("ignore", category=DeprecationWarning)

# ===============================================================================
# MONKEYPATCHES
# патчим либу social_auth, чтобы шифровать сенситивные пользователские данные
# импортируем их тут, потому что если импортировать в settings, сломается возможность запускать команды из консоли
# в частности это ломает убиватор протухших стрельб. А он для оверлоада довольно актуален
# ===============================================================================
import monkeypatches

urlpatterns = [
    url(r'^ping$', ping),
    url(r'^favicon\.ico$', RedirectView.as_view(url='/media/favicon.ico')),
    url(r'^addtofav\.json$', addtofav),
    url(r'^deletejob\.json$', deletejob),
    url(r'^preview$', generate_preview),
    url(r'^online/', include('onlinepage.urls')),
    url(r'^api/monitoring/', include('monitoring.api_urls')),
    url(r'^api/', include('api.urls')),
    url(r'^(\d+)/edit$', job_edit),
    url(r'^([a-zA-Z-]+\d+)/edit$', job_edit),
    url(r'^(\d+)/?$', offlinepage),
    url(r'^([a-zA-Z-]+\d+)/?$', offlinepage),
    url(r'^offlinepage/', include('offlinepage.urls')),
    url(r'^mainpage/', include('mainpage.urls')),
    url(r'^maintenance/$', maintenance),
    url(r'^ui_set/', ui_set),
    url(r'^$', mainpage),
    url(r'^takeout/', include('takeout.urls')),
    url('', include('social_django.urls', namespace='social')),
    url(r'^$', home),
    url(r'^email-sent/', validation_sent),
    url(r'^login/$', home),
    url(r'^logout/$', logout),
    url(r'^done/$', done, name='done'),
    url(r'^ajax-monkeypatches/(?P<backend>[^/]+)/$', ajax_auth, name='ajax-monkeypatches'),
    url(r'^email/$', require_email, name='require_email'),
]

if DEBUG:
    urlpatterns += static(settings.STATIC_URL, document_root=settings.MEDIA_ROOT)

if settings.ADMIN_ENABLED:
    urlpatterns += [
        url(r'^admin/', include(admin.site.urls)),
    ]
