import os
from flask import Flask
from flask_caching import Cache

config = {
    'testing': 'load.projects.tank_finder.lib.config.TestingtConfig',
    'production': 'load.projects.tank_finder.lib.config.ProductionConfig'
}

app = Flask(__name__)
cache = Cache()


class Error404(Exception):
    pass


class Error400(Exception):
    pass


def create_app(name):
    config_name = os.environ.get("ENV_TYPE") or 'testing'
    app.config.from_object(config[config_name])
    cache.init_app(app, config=app.config['REDIS_CACHE'])
    import load.projects.tank_finder.lib.handlers # noqa
    return app
