import argparse
from threading import Thread

from load.projects.tank_finder.lib.app import create_app
from load.projects.tank_finder.lib.thread import get_tanks_status


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('-u', '--host', default='::', help='server host')
    parser.add_argument('-p', '--port', type=int, default=80, help='server port')
    parser.add_argument('-d', '--debug', action='store_true', help='flask debug')
    params, _ = parser.parse_known_args()

    app = create_app('tank_finder')

    status_thread = Thread(target=get_tanks_status, args=(app, ))
    status_thread.daemon = True
    status_thread.start()

    app.run(host=params.host, port=params.port, debug=params.debug)

if __name__ == '__main__':
    main()
