#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
    Скрипт для управления Lunapark API сервером.
    Позволяет запустить, остановить сервер, получить информацию о текущем статусе.
"""

import sys

import tankapi.server_defaults as server_defaults
import tankapi.control as control
from optparse import OptionParser

DEFAULT_MODE = 'info'
LUNAPARK_API_MODES = {
    'info': control.print_lunapark_api_info,
    'start': control.start_lunapark_server,
    'restart': control.restart_lunapark_server,
    'stop': control.stop_lunapark_server,
}


def check_mode_option(args):
    """
        Проверить указанный режим работы. Если указан неправильный режим работы,
            выводится сообщение с предложением вывести справку и завершается весь скрипт
    """
    incorrect = False

    if len(args) > 1:
        incorrect = True
    elif len(args) == 1:
        mode = args[0]
        if mode not in LUNAPARK_API_MODES.keys():
            incorrect = True
    else:
        mode = DEFAULT_MODE

    if incorrect:
        print("Incorrect arguments. Use --help options for details.")
        exit(1)

    return mode


def get_parameters():
    """
        Получить параметры, заданные при запуске сервера
        @return: словарь с параметрами, ключи словаря:
         port - порт сервера
         log_path - путь до файла логов
    """
    sys.path.append('/usr/share/tankapi')

    usage = "usage: %%prog [options] [%s] (default is %s)" % (
        '|'.join(LUNAPARK_API_MODES.keys()), DEFAULT_MODE)
    parser = OptionParser(usage=usage)

    parser.add_option('-p',
                      '--port',
                      type='int',
                      action='store',
                      default=server_defaults.port,
                      help='Port for tank API server.')
    parser.add_option('-w',
                      '--workdir',
                      type='string',
                      action='store',
                      default=server_defaults.workdir,
                      help='Path to tank API server workdir.')
    parser.add_option('-s',
                      '--sourcedir',
                      type='string',
                      action='store',
                      default=server_defaults.sourcedir,
                      help='Path to tank API server source dir.')

    script_options, args = parser.parse_args()
    script_options.mode = check_mode_option(args)
    return script_options


def main():
    options = get_parameters()
    # вызваем фукнцию по указанному режиму
    LUNAPARK_API_MODES[options.mode](options)
    print('Done.')
    exit(0)
