import os.path
import yaml
import logging

logger = logging.getLogger(__name__)


class Config():

    def __init__(self):
        self.path = '/etc/yandex-tank/experiment/experiment.yaml'

    def init_config(self):
        if os.path.exists(self.path):
            try:
                with open(self.path, 'r') as stream:
                    config_loaded = yaml.safe_load(stream)
            except (yaml.YAMLError):
                logger.debug('Running test without experiments. Check your experiment config: %s' % self.path)
                return

            return config_loaded
        else:
            logger.debug('Running test without experiments')
            return
