from yandextank.core.tankworker import load_core_base_cfg, load_local_base_cfgs
from yandextank.validator.validator import TankConfig, ValidationError


def response(full_cfg, errors):
    return {'config': full_cfg, 'errors': errors}


def get_validation_result(cfg):
    conf = TankConfig([load_core_base_cfg()] +
                      load_local_base_cfgs() +
                      [cfg],
                      with_dynamic_options=False)
    try:
        config, configinitial = conf.validate()
        return response(configinitial, {})
    except ValidationError as e:
        return response(None, e.errors)
