package main

import (
	"time"
	"a.yandex-team.ru/load/projects/pandora/cli"
	"a.yandex-team.ru/load/projects/pandora/core"
	"a.yandex-team.ru/load/projects/pandora/core/aggregator/netsample"
	coreimport "a.yandex-team.ru/load/projects/pandora/core/import"
	"a.yandex-team.ru/load/projects/pandora/core/register"
)

// Ammo is the structure of the meta information for requests
type Ammo struct {
	Tag       string
	Sleep     int
}

// Sample is structure for the X3 che.go
type Sample struct {
	URL              string
	ShootTimeSeconds float64
}

//GunConfig is structure for the Gun
type GunConfig struct {
	Target string `validate:"required"`
}

// Gun is structure for the load generator
type Gun struct {
	expire time.Time
	conf   GunConfig
	aggr core.Aggregator
	core.GunDeps
}

// NewGun is the constructor for the loadf generator
func NewGun(conf GunConfig) *Gun {
	return &Gun{conf: conf}
}

// Bind is the configurator for the load generator
func (g *Gun) Bind(aggr core.Aggregator, deps core.GunDeps) error {
	g.expire = time.Now().AddDate(0, 0, 1)
	g.aggr = aggr
	g.GunDeps = deps
	return nil
}

// Shoot is the launcher for firing
func (g *Gun) Shoot(ammo core.Ammo) {
	customAmmo := ammo.(*Ammo)
	g.shoot(customAmmo)
}

func (g *Gun) shoot(ammo *Ammo) {
	code := 200
	sample := netsample.Acquire(ammo.Tag)
	time.Sleep(time.Duration(ammo.Sleep) * time.Millisecond)
	defer func() {
		sample.SetProtoCode(code)
		g.aggr.Report(sample)
	}()
}

func main() {
	fs := coreimport.GetFs()
	coreimport.Import(fs)
	coreimport.RegisterCustomJSONProvider("cheammo", func() core.Ammo { return &Ammo{} })
	register.Gun("cheagun", NewGun, func() GunConfig {
		return GunConfig{
			Target: "default target",
		}
	})
	cli.Run()
}
