#!/bin/bash

set -x -euo pipefail
DAEMON_NAME=cloud-yandex-tank

log_fatal (){
    logger -ip daemon.error -t ${DAEMON_NAME} "$@"
    exit 1
}

log_info (){
    logger -ip daemon.info -t ${DAEMON_NAME} "$@"
}

# Directory for temporary files
TMPDIR=$(mktemp -d)

system_upgrade() {
    DEBIAN_FRONTEND=noninteractive apt-get update -qq || log_fatal "Can't update repos"
    DEBIAN_FRONTEND=noninteractive LANG=C apt-get purge -y unattended-upgrades || log_fatal "Can't purge unattended-upgrades"
    DEBIAN_FRONTEND=noninteractive LANG=C apt-get install -y locales || log_fatal "Can't install locales"
    locale-gen en_US.UTF-8 || log_fatal "Failed to set locales"
    dpkg-reconfigure --frontend=noninteractive locales || log_fatal "Can't rebuild locales"
}

install_utils() {
    DEBIAN_FRONTEND=noninteractive apt-get install --no-install-recommends -yq net-tools \
        python3.9 \
        python3-pip \
        python3-venv \
        jq \
        nginx-extras \
        libnginx-mod-http-echo \
        libnginx-mod-http-lua \
        supervisor || log_fatal "Can't install utils" 
}

highload_twick() {
    echo "* hard nofile 65536" >> /etc/security/limits.conf
    echo "* soft nofile 65536" >> /etc/security/limits.conf
    echo "root hard nofile 65536" >> /etc/security/limits.conf
    echo "root soft nofile 65536" >> /etc/security/limits.conf
    echo "net.core.netdev_max_backlog=10000" >> /etc/sysctl.d/12-highload-network.conf
    echo "net.core.somaxconn=262144" >> /etc/sysctl.d/12-highload-network.conf
    echo "net.ipv4.tcp_max_tw_buckets=720000" >> /etc/sysctl.d/12-highload-network.conf
    echo "net.ipv4.tcp_timestamps=1" >> /etc/sysctl.d/12-highload-network.conf
    echo "net.ipv4.tcp_tw_reuse=1" >> /etc/sysctl.d/12-highload-network.conf
    echo "net.ipv4.tcp_fin_timeout=30" >> /etc/sysctl.d/12-highload-network.conf
    echo "net.ipv4.tcp_keepalive_time=1800" >> /etc/sysctl.d/12-highload-network.conf
    echo "net.core.rmem_max=26214400" >> /etc/sysctl.d/12-highload-network.conf
    echo "net.core.rmem_default=6250000" >> /etc/sysctl.d/12-highload-network.conf
    echo "net.core.wmem_max=26214400" >> /etc/sysctl.d/12-highload-network.conf
    echo "net.core.wmem_default=6250000" >> /etc/sysctl.d/12-highload-network.conf
    echo "net.ipv4.tcp_rmem='4096 6250000 26214400'" >> /etc/sysctl.d/12-highload-network.conf
    echo "net.ipv4.tcp_wmem='4096 6250000 26214400'" >> /etc/sysctl.d/12-highload-network.conf
}

clean_apt() {
    DEBIAN_FRONTEND=noninteractive apt-get clean
}

cleanup () {
    rm -rf /var/log/apt/*
    rm -rf /var/log/{auth,dpkg,syslog,wtmp,kern,alternatives,auth,btmp,dmesg}.log
    rm -rf /var/lib/dhcp/*
    rm -rf /etc/apt/sources.list.d/yandex-load-ubuntu-main-focal.list
    rm -rf /etc/apt/trusted.gpg.d/yandex-load_ubuntu_main.gpg

}

setup_oslogin() {
    mv /tmp/bootstrap/hosts.debian.tmpl /etc/cloud/templates/hosts.debian.tmpl
    mv /tmp/bootstrap/instance_configs.cfg /etc/default/instance_configs.cfg.template
    chmod 0444 /etc/default/instance_configs.cfg.template
    DEBIAN_FRONTEND=noninteractive apt-get install --no-install-recommends -yq python3-google-compute-engine=20190801-0ubuntu4.1 \
    google-compute-engine-oslogin=20190801-0ubuntu4.1 \
    gce-compute-image-packages=20190801-0ubuntu4.1 || log_fatal "Can't install oslogin"
    rm -rf /etc/apt/apt.conf.d/99ipv4-only
    touch /etc/oslogin_passwd.cache
    google_oslogin_control activate
}

main() {
    system_upgrade
    install_utils
    highload_twick
    setup_oslogin
    clean_apt
    cleanup
}

main
