import requests


class BaseResourceLoader:
    """
    No abstracts, just to be compatible with python2 ((
    """

    def key(self):
        raise NotImplementedError()

    def download_resource(self, specification):
        raise NotImplementedError()

    def copy(self):
        """
        If loader has state, copy shoult return an object with dropped state.
        """
        return self


class URLLoader(BaseResourceLoader):
    def __init__(self, auth=None):
        self.auth = auth

    def key(self):
        return 'url'

    def download_resource(self, url):
        r = requests.get(url, auth=self.auth)
        r.raise_for_status()
        return r.text


class FileLoader(BaseResourceLoader):
    def key(self):
        return 'file'

    def download_resource(self, path):
        with open(path) as d:
            return d.read()
