/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.protobuf;

import com.google.common.base.Preconditions;
import com.google.protobuf.MessageLite;
import io.grpc.ExperimentalApi;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import io.grpc.protobuf.lite.ProtoLiteUtils;
import javax.annotation.Nullable;

@ExperimentalApi
public final class StatusProto {
    private static final Metadata.Key<com.google.rpc.Status> STATUS_DETAILS_KEY = Metadata.Key.of((String)"grpc-status-details-bin", (Metadata.BinaryMarshaller)ProtoLiteUtils.metadataMarshaller((MessageLite)com.google.rpc.Status.getDefaultInstance()));

    private StatusProto() {
    }

    public static StatusRuntimeException toStatusRuntimeException(com.google.rpc.Status statusProto) {
        return StatusProto.toStatus(statusProto).asRuntimeException(StatusProto.toMetadata(statusProto));
    }

    public static StatusRuntimeException toStatusRuntimeException(com.google.rpc.Status statusProto, Metadata metadata) {
        return StatusProto.toStatus(statusProto).asRuntimeException(StatusProto.toMetadata(statusProto, metadata));
    }

    public static StatusException toStatusException(com.google.rpc.Status statusProto) {
        return StatusProto.toStatus(statusProto).asException(StatusProto.toMetadata(statusProto));
    }

    public static StatusException toStatusException(com.google.rpc.Status statusProto, Metadata metadata) {
        return StatusProto.toStatus(statusProto).asException(StatusProto.toMetadata(statusProto, metadata));
    }

    private static Status toStatus(com.google.rpc.Status statusProto) {
        Status status = Status.fromCodeValue((int)statusProto.getCode());
        Preconditions.checkArgument((status.getCode().value() == statusProto.getCode() ? 1 : 0) != 0, (Object)"invalid status code");
        return status.withDescription(statusProto.getMessage());
    }

    private static Metadata toMetadata(com.google.rpc.Status statusProto) {
        Metadata metadata = new Metadata();
        metadata.put(STATUS_DETAILS_KEY, (Object)statusProto);
        return metadata;
    }

    private static Metadata toMetadata(com.google.rpc.Status statusProto, Metadata metadata) {
        Preconditions.checkNotNull((Object)metadata, (Object)"metadata must not be null");
        metadata.discardAll(STATUS_DETAILS_KEY);
        metadata.put(STATUS_DETAILS_KEY, (Object)statusProto);
        return metadata;
    }

    @Nullable
    public static com.google.rpc.Status fromThrowable(Throwable t) {
        for (Throwable cause = (Throwable)Preconditions.checkNotNull((Object)t, (Object)"t"); cause != null; cause = cause.getCause()) {
            if (cause instanceof StatusException) {
                StatusException e = (StatusException)cause;
                return StatusProto.fromStatusAndTrailers(e.getStatus(), e.getTrailers());
            }
            if (!(cause instanceof StatusRuntimeException)) continue;
            StatusRuntimeException e = (StatusRuntimeException)cause;
            return StatusProto.fromStatusAndTrailers(e.getStatus(), e.getTrailers());
        }
        return null;
    }

    @Nullable
    public static com.google.rpc.Status fromStatusAndTrailers(Status status, Metadata trailers) {
        com.google.rpc.Status statusProto;
        if (trailers != null && (statusProto = (com.google.rpc.Status)trailers.get(STATUS_DETAILS_KEY)) != null) {
            Preconditions.checkArgument((status.getCode().value() == statusProto.getCode() ? 1 : 0) != 0, (Object)"com.google.rpc.Status code must match gRPC status code");
            return statusProto;
        }
        return null;
    }
}

