/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template.builder;

import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import org.msgpack.template.AbstractTemplate;
import org.msgpack.template.FieldOption;
import org.msgpack.template.Template;
import org.msgpack.template.TemplateRegistry;
import org.msgpack.template.builder.AbstractTemplateBuilder;
import org.msgpack.template.builder.BuildContext;
import org.msgpack.template.builder.DefaultBuildContext;
import org.msgpack.template.builder.FieldEntry;

public class JavassistTemplateBuilder
extends AbstractTemplateBuilder {
    private static Logger LOG = Logger.getLogger(JavassistTemplateBuilder.class.getName());
    protected ClassPool pool = new ClassPool();
    protected int seqId = 0;
    protected ClassLoader loader;

    public JavassistTemplateBuilder(TemplateRegistry registry) {
        this(registry, null);
    }

    public JavassistTemplateBuilder(TemplateRegistry registry, ClassLoader cl) {
        super(registry);
        this.pool.appendClassPath((ClassPath)new ClassClassPath(this.getClass()));
        boolean appended = false;
        this.loader = cl;
        if (this.loader == null) {
            this.loader = this.pool.getClassLoader();
        }
        try {
            if (this.loader != null) {
                this.pool.appendClassPath((ClassPath)new LoaderClassPath(this.loader));
                appended = true;
            }
        }
        catch (SecurityException e) {
            LOG.fine("Cannot append a search path of classloader");
            e.printStackTrace();
        }
        if (!appended) {
            this.pool.appendSystemPath();
        }
    }

    @Override
    public boolean matchType(Type targetType, boolean hasAnnotation) {
        Class targetClass = (Class)targetType;
        boolean matched = JavassistTemplateBuilder.matchAtClassTemplateBuilder(targetClass, hasAnnotation);
        if (matched && LOG.isLoggable(Level.FINE)) {
            LOG.fine("matched type: " + targetClass.getName());
        }
        return matched;
    }

    public void addClassLoader(ClassLoader cl) {
        this.pool.appendClassPath((ClassPath)new LoaderClassPath(cl));
    }

    protected CtClass makeCtClass(String className) {
        return this.pool.makeClass(className);
    }

    protected CtClass getCtClass(String className) throws NotFoundException {
        return this.pool.get(className);
    }

    protected int nextSeqId() {
        return this.seqId++;
    }

    protected BuildContext createBuildContext() {
        return new DefaultBuildContext(this);
    }

    @Override
    public <T> Template<T> buildTemplate(Class<T> targetClass, FieldEntry[] entries) {
        Template[] tmpls = this.toTemplate(entries);
        BuildContext bc = this.createBuildContext();
        return bc.buildTemplate(targetClass, entries, tmpls);
    }

    private Template<?>[] toTemplate(FieldEntry[] from) {
        Template[] tmpls = new Template[from.length];
        for (int i = 0; i < from.length; ++i) {
            Template tmpl;
            FieldEntry e = from[i];
            tmpls[i] = !e.isAvailable() ? null : (tmpl = this.registry.lookup(e.getGenericType()));
        }
        return tmpls;
    }

    @Override
    public void writeTemplate(Type targetType, String directoryName) {
        Class targetClass = (Class)targetType;
        this.checkClassValidation(targetClass);
        FieldOption implicitOption = this.getFieldOption(targetClass);
        FieldEntry[] entries = this.toFieldEntries(targetClass, implicitOption);
        this.writeTemplate(targetClass, entries, directoryName);
    }

    private void writeTemplate(Class<?> targetClass, FieldEntry[] entries, String directoryName) {
        Template[] tmpls = this.toTemplate(entries);
        BuildContext bc = this.createBuildContext();
        bc.writeTemplate(targetClass, entries, tmpls, directoryName);
    }

    @Override
    public <T> Template<T> loadTemplate(Type targetType) {
        Class targetClass = (Class)targetType;
        try {
            String tmplName = targetClass.getName() + "_$$_Template";
            ClassLoader cl = targetClass.getClassLoader();
            if (cl == null) {
                return null;
            }
            cl.loadClass(tmplName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        FieldOption implicitOption = this.getFieldOption(targetClass);
        FieldEntry[] entries = this.toFieldEntries(targetClass, implicitOption);
        Template[] tmpls = this.toTemplate(entries);
        BuildContext bc = this.createBuildContext();
        return bc.loadTemplate(targetClass, entries, tmpls);
    }

    protected ClassLoader getClassLoader() {
        return this.loader;
    }

    public static abstract class JavassistTemplate<T>
    extends AbstractTemplate<T> {
        public Class<T> targetClass;
        public Template<?>[] templates;

        public JavassistTemplate(Class<T> targetClass, Template<?>[] templates) {
            this.targetClass = targetClass;
            this.templates = templates;
        }
    }
}

