/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.bcel.util.ModularRuntimeImage;

public class ClassPath
implements Closeable {
    private static final FilenameFilter ARCHIVE_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return (name = name.toLowerCase(Locale.ENGLISH)).endsWith(".zip") || name.endsWith(".jar");
        }
    };
    private static final FilenameFilter MODULES_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            name = name.toLowerCase(Locale.ENGLISH);
            return name.endsWith(".jmod");
        }
    };
    public static final ClassPath SYSTEM_CLASS_PATH = new ClassPath(ClassPath.getClassPath());
    private final String classPath;
    private ClassPath parent;
    private final AbstractPathEntry[] paths;

    private static void addJdkModules(String javaHome, List<String> list) {
        File modulesDir;
        String modulesPath = System.getProperty("java.modules.path");
        if (modulesPath == null || modulesPath.trim().isEmpty()) {
            modulesPath = javaHome + File.separator + "jmods";
        }
        if ((modulesDir = new File(modulesPath)).exists()) {
            String[] modules = modulesDir.list(MODULES_FILTER);
            for (int i = 0; i < modules.length; ++i) {
                list.add(modulesDir.getPath() + File.separatorChar + modules[i]);
            }
        }
    }

    public static String getClassPath() {
        String classPathProp = System.getProperty("java.class.path");
        String bootClassPathProp = System.getProperty("sun.boot.class.path");
        String extDirs = System.getProperty("java.ext.dirs");
        String javaHome = System.getProperty("java.home");
        ArrayList<String> list = new ArrayList<String>();
        Path modulesPath = Paths.get(javaHome, new String[0]).resolve("lib/modules");
        if (Files.exists(modulesPath, new LinkOption[0]) && Files.isRegularFile(modulesPath, new LinkOption[0])) {
            list.add(modulesPath.toAbsolutePath().toString());
        }
        ClassPath.addJdkModules(javaHome, list);
        ClassPath.getPathComponents(classPathProp, list);
        ClassPath.getPathComponents(bootClassPathProp, list);
        ArrayList<String> dirs = new ArrayList<String>();
        ClassPath.getPathComponents(extDirs, dirs);
        for (String d : dirs) {
            File ext_dir = new File(d);
            String[] extensions = ext_dir.list(ARCHIVE_FILTER);
            if (extensions == null) continue;
            for (String extension : extensions) {
                list.add(ext_dir.getPath() + File.separatorChar + extension);
            }
        }
        StringBuilder buf = new StringBuilder();
        String separator = "";
        for (String path : list) {
            buf.append(separator);
            separator = File.pathSeparator;
            buf.append(path);
        }
        return buf.toString().intern();
    }

    private static void getPathComponents(String path, List<String> list) {
        if (path != null) {
            StringTokenizer tokenizer = new StringTokenizer(path, File.pathSeparator);
            while (tokenizer.hasMoreTokens()) {
                String name = tokenizer.nextToken();
                File file = new File(name);
                if (!file.exists()) continue;
                list.add(name);
            }
        }
    }

    static String packageToFolder(String name) {
        return name.replace('.', '/');
    }

    @Deprecated
    public ClassPath() {
        this(ClassPath.getClassPath());
    }

    public ClassPath(ClassPath parent, String classPath) {
        this(classPath);
        this.parent = parent;
    }

    public ClassPath(String classPath) {
        this.classPath = classPath;
        ArrayList<AbstractPathEntry> list = new ArrayList<AbstractPathEntry>();
        StringTokenizer tokenizer = new StringTokenizer(classPath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String path = tokenizer.nextToken();
            if (path.isEmpty()) continue;
            File file = new File(path);
            try {
                if (!file.exists()) continue;
                if (file.isDirectory()) {
                    list.add(new Dir(path));
                    continue;
                }
                if (path.endsWith(".jmod")) {
                    list.add(new Module(new ZipFile(file)));
                    continue;
                }
                if (path.endsWith(ModularRuntimeImage.MODULES_PATH)) {
                    list.add(new JrtModules(ModularRuntimeImage.MODULES_PATH));
                    continue;
                }
                list.add(new Jar(new ZipFile(file)));
            }
            catch (IOException e) {
                if (!path.endsWith(".zip") && !path.endsWith(".jar")) continue;
                System.err.println("CLASSPATH component " + file + ": " + e);
            }
        }
        this.paths = new AbstractPathEntry[list.size()];
        list.toArray(this.paths);
    }

    @Override
    public void close() throws IOException {
        if (this.paths != null) {
            for (AbstractPathEntry path : this.paths) {
                path.close();
            }
        }
    }

    public boolean equals(Object o) {
        if (o instanceof ClassPath) {
            ClassPath cp = (ClassPath)o;
            return this.classPath.equals(cp.toString());
        }
        return false;
    }

    public byte[] getBytes(String name) throws IOException {
        return this.getBytes(name, ".class");
    }

    /*
     * Loose catch block
     */
    public byte[] getBytes(String name, String suffix) throws IOException {
        try (FilterInputStream dis = null;){
            try (InputStream inputStream = this.getInputStream(name, suffix);){
                if (inputStream == null) {
                    throw new IOException("Couldn't find: " + name + suffix);
                }
                dis = new DataInputStream(inputStream);
                byte[] bytes = new byte[inputStream.available()];
                ((DataInputStream)dis).readFully(bytes);
                byte[] byArray = bytes;
                return byArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    public ClassFile getClassFile(String name) throws IOException {
        return this.getClassFile(name, ".class");
    }

    public ClassFile getClassFile(String name, String suffix) throws IOException {
        ClassFile cf = null;
        if (this.parent != null) {
            cf = this.parent.getClassFileInternal(name, suffix);
        }
        if (cf == null) {
            cf = this.getClassFileInternal(name, suffix);
        }
        if (cf != null) {
            return cf;
        }
        throw new IOException("Couldn't find: " + name + suffix);
    }

    private ClassFile getClassFileInternal(String name, String suffix) throws IOException {
        for (AbstractPathEntry path : this.paths) {
            ClassFile cf = path.getClassFile(name, suffix);
            if (cf == null) continue;
            return cf;
        }
        return null;
    }

    public InputStream getInputStream(String name) throws IOException {
        return this.getInputStream(ClassPath.packageToFolder(name), ".class");
    }

    public InputStream getInputStream(String name, String suffix) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = this.getClass().getClassLoader().getResourceAsStream(name + suffix);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (inputStream != null) {
            return inputStream;
        }
        return this.getClassFile(name, suffix).getInputStream();
    }

    public String getPath(String name) throws IOException {
        int index = name.lastIndexOf(46);
        String suffix = "";
        if (index > 0) {
            suffix = name.substring(index);
            name = name.substring(0, index);
        }
        return this.getPath(name, suffix);
    }

    public String getPath(String name, String suffix) throws IOException {
        return this.getClassFile(name, suffix).getPath();
    }

    public URL getResource(String name) {
        for (AbstractPathEntry path : this.paths) {
            URL url = path.getResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public InputStream getResourceAsStream(String name) {
        for (AbstractPathEntry path : this.paths) {
            InputStream is = path.getResourceAsStream(name);
            if (is == null) continue;
            return is;
        }
        return null;
    }

    public Enumeration<URL> getResources(String name) {
        Vector<URL> results = new Vector<URL>();
        for (AbstractPathEntry path : this.paths) {
            URL url = path.getResource(name);
            if (url == null) continue;
            results.add(url);
        }
        return results.elements();
    }

    public int hashCode() {
        if (this.parent != null) {
            return this.classPath.hashCode() + this.parent.hashCode();
        }
        return this.classPath.hashCode();
    }

    public String toString() {
        if (this.parent != null) {
            return this.parent + File.pathSeparator + this.classPath;
        }
        return this.classPath;
    }

    private static class Module
    extends AbstractZip {
        Module(ZipFile zip) {
            super(zip);
        }

        @Override
        protected String toEntryName(String name, String suffix) {
            return "classes/" + ClassPath.packageToFolder(name) + suffix;
        }
    }

    private static class JrtModules
    extends AbstractPathEntry {
        private final ModularRuntimeImage modularRuntimeImage = new ModularRuntimeImage();
        private final JrtModule[] modules;

        public JrtModules(String path) throws IOException {
            List<Path> list = this.modularRuntimeImage.list(path);
            this.modules = new JrtModule[list.size()];
            for (int i = 0; i < this.modules.length; ++i) {
                this.modules[i] = new JrtModule(list.get(i));
            }
        }

        @Override
        public void close() throws IOException {
            if (this.modules != null) {
                for (int i = 0; i < this.modules.length; ++i) {
                    this.modules[i].close();
                }
            }
            if (this.modularRuntimeImage != null) {
                this.modularRuntimeImage.close();
            }
        }

        @Override
        ClassFile getClassFile(String name, String suffix) throws IOException {
            for (int i = 0; i < this.modules.length; ++i) {
                ClassFile classFile = this.modules[i].getClassFile(name, suffix);
                if (classFile == null) continue;
                return classFile;
            }
            return null;
        }

        @Override
        URL getResource(String name) {
            for (int i = 0; i < this.modules.length; ++i) {
                URL url = this.modules[i].getResource(name);
                if (url == null) continue;
                return url;
            }
            return null;
        }

        @Override
        InputStream getResourceAsStream(String name) {
            for (int i = 0; i < this.modules.length; ++i) {
                InputStream inputStream = this.modules[i].getResourceAsStream(name);
                if (inputStream == null) continue;
                return inputStream;
            }
            return null;
        }

        public String toString() {
            return Arrays.toString(this.modules);
        }
    }

    private static class JrtModule
    extends AbstractPathEntry {
        private final Path modulePath;

        public JrtModule(Path modulePath) {
            this.modulePath = Objects.requireNonNull(modulePath, "modulePath");
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        ClassFile getClassFile(String name, String suffix) throws IOException {
            final Path resolved = this.modulePath.resolve(ClassPath.packageToFolder(name) + suffix);
            if (Files.exists(resolved, new LinkOption[0])) {
                return new ClassFile(){

                    @Override
                    public String getBase() {
                        return resolved.getFileName().toString();
                    }

                    @Override
                    public InputStream getInputStream() throws IOException {
                        return Files.newInputStream(resolved, new OpenOption[0]);
                    }

                    @Override
                    public String getPath() {
                        return resolved.toString();
                    }

                    @Override
                    public long getSize() {
                        try {
                            return Files.size(resolved);
                        }
                        catch (IOException e) {
                            return 0L;
                        }
                    }

                    @Override
                    public long getTime() {
                        try {
                            return Files.getLastModifiedTime(resolved, new LinkOption[0]).toMillis();
                        }
                        catch (IOException e) {
                            return 0L;
                        }
                    }
                };
            }
            return null;
        }

        @Override
        URL getResource(String name) {
            Path resovled = this.modulePath.resolve(name);
            try {
                return Files.exists(resovled, new LinkOption[0]) ? new URL("jrt:" + this.modulePath + "/" + name) : null;
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        @Override
        InputStream getResourceAsStream(String name) {
            try {
                return Files.newInputStream(this.modulePath.resolve(name), new OpenOption[0]);
            }
            catch (IOException e) {
                return null;
            }
        }

        public String toString() {
            return this.modulePath.toString();
        }
    }

    private static class Jar
    extends AbstractZip {
        Jar(ZipFile zip) {
            super(zip);
        }

        @Override
        protected String toEntryName(String name, String suffix) {
            return ClassPath.packageToFolder(name) + suffix;
        }
    }

    private static class Dir
    extends AbstractPathEntry {
        private final String dir;

        Dir(String d) {
            this.dir = d;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        ClassFile getClassFile(String name, String suffix) throws IOException {
            final File file = new File(this.dir + File.separatorChar + name.replace('.', File.separatorChar) + suffix);
            return file.exists() ? new ClassFile(){

                @Override
                public String getBase() {
                    return dir;
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return new FileInputStream(file);
                }

                @Override
                public String getPath() {
                    try {
                        return file.getCanonicalPath();
                    }
                    catch (IOException e) {
                        return null;
                    }
                }

                @Override
                public long getSize() {
                    return file.length();
                }

                @Override
                public long getTime() {
                    return file.lastModified();
                }
            } : null;
        }

        @Override
        URL getResource(String name) {
            File file = this.toFile(name);
            try {
                return file.exists() ? file.toURI().toURL() : null;
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        @Override
        InputStream getResourceAsStream(String name) {
            File file = this.toFile(name);
            try {
                return file.exists() ? new FileInputStream(file) : null;
            }
            catch (IOException e) {
                return null;
            }
        }

        private File toFile(String name) {
            return new File(this.dir + File.separatorChar + name.replace('/', File.separatorChar));
        }

        public String toString() {
            return this.dir;
        }
    }

    public static interface ClassFile {
        public String getBase();

        public InputStream getInputStream() throws IOException;

        public String getPath();

        public long getSize();

        public long getTime();
    }

    private static abstract class AbstractZip
    extends AbstractPathEntry {
        private final ZipFile zipFile;

        AbstractZip(ZipFile zipFile) {
            this.zipFile = Objects.requireNonNull(zipFile, "zipFile");
        }

        @Override
        public void close() throws IOException {
            if (this.zipFile != null) {
                this.zipFile.close();
            }
        }

        @Override
        ClassFile getClassFile(String name, String suffix) throws IOException {
            final ZipEntry entry = this.zipFile.getEntry(this.toEntryName(name, suffix));
            if (entry == null) {
                return null;
            }
            return new ClassFile(){

                @Override
                public String getBase() {
                    return zipFile.getName();
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return zipFile.getInputStream(entry);
                }

                @Override
                public String getPath() {
                    return entry.toString();
                }

                @Override
                public long getSize() {
                    return entry.getSize();
                }

                @Override
                public long getTime() {
                    return entry.getTime();
                }
            };
        }

        @Override
        URL getResource(String name) {
            ZipEntry entry = this.zipFile.getEntry(name);
            try {
                return entry != null ? new URL("jar:file:" + this.zipFile.getName() + "!/" + name) : null;
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        @Override
        InputStream getResourceAsStream(String name) {
            ZipEntry entry = this.zipFile.getEntry(name);
            try {
                return entry != null ? this.zipFile.getInputStream(entry) : null;
            }
            catch (IOException e) {
                return null;
            }
        }

        protected abstract String toEntryName(String var1, String var2);

        public String toString() {
            return this.zipFile.getName();
        }
    }

    private static abstract class AbstractPathEntry
    implements Closeable {
        private AbstractPathEntry() {
        }

        abstract ClassFile getClassFile(String var1, String var2) throws IOException;

        abstract URL getResource(String var1);

        abstract InputStream getResourceAsStream(String var1);
    }
}

