/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.owasp.html.AttributePolicy;
import org.owasp.html.ElementPolicy;
import org.owasp.html.HtmlPolicyBuilder;

@Immutable
final class ElementAndAttributePolicies {
    final String elementName;
    final ElementPolicy elPolicy;
    final ImmutableMap<String, AttributePolicy> attrPolicies;
    final boolean skipIfEmpty;

    ElementAndAttributePolicies(String elementName, ElementPolicy elPolicy, Map<String, AttributePolicy> attrPolicies, boolean skipIfEmpty) {
        this.elementName = elementName;
        this.elPolicy = elPolicy;
        this.attrPolicies = ImmutableMap.copyOf(attrPolicies);
        this.skipIfEmpty = skipIfEmpty;
    }

    ElementAndAttributePolicies and(ElementAndAttributePolicies p) {
        String attrName;
        assert (this.elementName.equals(p.elementName)) : this.elementName + " != " + p.elementName;
        ImmutableMap.Builder joinedAttrPolicies = ImmutableMap.builder();
        for (Map.Entry e : this.attrPolicies.entrySet()) {
            attrName = (String)e.getKey();
            AttributePolicy a = (AttributePolicy)e.getValue();
            AttributePolicy b = (AttributePolicy)p.attrPolicies.get((Object)attrName);
            if (b != null) {
                a = AttributePolicy.Util.join(a, b);
            }
            joinedAttrPolicies.put((Object)attrName, (Object)a);
        }
        for (Map.Entry e : p.attrPolicies.entrySet()) {
            attrName = (String)e.getKey();
            if (this.attrPolicies.containsKey((Object)attrName)) continue;
            joinedAttrPolicies.put((Object)attrName, e.getValue());
        }
        boolean combinedSkipIfEmpty = HtmlPolicyBuilder.DEFAULT_SKIP_IF_EMPTY.contains((Object)this.elementName) ? this.skipIfEmpty && p.skipIfEmpty : this.skipIfEmpty || p.skipIfEmpty;
        return new ElementAndAttributePolicies(this.elementName, ElementPolicy.Util.join(this.elPolicy, p.elPolicy), (Map<String, AttributePolicy>)joinedAttrPolicies.build(), combinedSkipIfEmpty);
    }

    ElementAndAttributePolicies andGlobals(Map<String, AttributePolicy> globalAttrPolicies) {
        String attrName;
        if (globalAttrPolicies.isEmpty()) {
            return this;
        }
        LinkedHashMap anded = null;
        for (Map.Entry entry : this.attrPolicies.entrySet()) {
            attrName = (String)entry.getKey();
            AttributePolicy globalAttrPolicy = globalAttrPolicies.get(attrName);
            if (globalAttrPolicy == null) continue;
            AttributePolicy attrPolicy = (AttributePolicy)entry.getValue();
            AttributePolicy joined = AttributePolicy.Util.join(attrPolicy, globalAttrPolicy);
            if (joined.equals(attrPolicy)) continue;
            if (anded == null) {
                anded = Maps.newLinkedHashMap();
                anded.putAll(this.attrPolicies);
            }
            anded.put(attrName, joined);
        }
        for (Map.Entry entry : globalAttrPolicies.entrySet()) {
            attrName = (String)entry.getKey();
            if (this.attrPolicies.containsKey((Object)attrName)) continue;
            if (anded == null) {
                anded = Maps.newLinkedHashMap();
                anded.putAll(this.attrPolicies);
            }
            anded.put(attrName, entry.getValue());
        }
        if (anded == null) {
            return this;
        }
        return new ElementAndAttributePolicies(this.elementName, this.elPolicy, anded, this.skipIfEmpty);
    }
}

