/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.owasp.html.Trie;

class HtmlEntities {
    public static final Trie ENTITY_TRIE;

    public static long decodeEntityAt(String html, int offset, int limit) {
        char ch = html.charAt(offset);
        if ('&' != ch) {
            return (long)offset + 1L << 32 | (long)ch;
        }
        int entityLimit = Math.min(limit, offset + 10);
        int end = -1;
        int tail = -1;
        if (entityLimit == limit) {
            end = tail = entityLimit;
        }
        block11: for (int i = offset + 1; i < entityLimit; ++i) {
            switch (html.charAt(i)) {
                case ';': {
                    end = i;
                    tail = end + 1;
                    break block11;
                }
                case '#': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    continue block11;
                }
                default: {
                    return (long)offset + 1L << 32 | 0x26L;
                }
            }
        }
        if (end < 0 || offset + 2 >= end) {
            return (long)offset + 1L << 32 | 0x26L;
        }
        char ch1 = html.charAt(offset + 1);
        char ch2 = html.charAt(offset + 2);
        int codepoint = -1;
        if ('#' == ch1) {
            if ('x' == ch2 || 'X' == ch2) {
                if (end == offset + 3) {
                    return (long)offset + 1L << 32 | 0x26L;
                }
                codepoint = 0;
                block12: for (int i = offset + 3; i < end; ++i) {
                    char digit = html.charAt(i);
                    switch (digit & 0xFFF8) {
                        case 48: 
                        case 56: {
                            int decDig = digit & 0xF;
                            if (decDig < 10) {
                                codepoint = codepoint << 4 | decDig;
                                continue block12;
                            }
                            codepoint = -1;
                            break block12;
                        }
                        case 64: 
                        case 96: {
                            int hexDig = digit & 7;
                            if (hexDig != 0 && hexDig < 7) {
                                codepoint = codepoint << 4 | hexDig + 9;
                                continue block12;
                            }
                            codepoint = -1;
                            break block12;
                        }
                        default: {
                            codepoint = -1;
                            break block12;
                        }
                    }
                }
                if (codepoint > 0x10FFFF) {
                    codepoint = 65533;
                }
            } else {
                codepoint = 0;
                block13: for (int i = offset + 2; i < end; ++i) {
                    char digit = html.charAt(i);
                    switch (digit & 0xFFF8) {
                        case 48: 
                        case 56: {
                            int decDig = digit - 48;
                            if (decDig < 10) {
                                codepoint = codepoint * 10 + decDig;
                                continue block13;
                            }
                            codepoint = -1;
                            break block13;
                        }
                        default: {
                            codepoint = -1;
                            break block13;
                        }
                    }
                }
                if (codepoint > 0x10FFFF) {
                    codepoint = 65533;
                }
            }
        } else {
            char nameChar;
            int i;
            Trie t = ENTITY_TRIE;
            for (i = offset + 1; i < end && (t = t.lookup(nameChar = html.charAt(i))) != null; ++i) {
            }
            if (t == null) {
                t = ENTITY_TRIE;
                for (i = offset + 1; i < end; ++i) {
                    nameChar = html.charAt(i);
                    if ('Z' >= nameChar && nameChar >= 'A') {
                        nameChar = (char)(nameChar | 0x20);
                    }
                    if ((t = t.lookup(nameChar)) == null) break;
                }
            }
            if (t != null && t.isTerminal()) {
                codepoint = t.getValue();
            }
        }
        if (codepoint < 0) {
            return (long)offset + 1L << 32 | 0x26L;
        }
        return (long)tail << 32 | (long)codepoint;
    }

    private HtmlEntities() {
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder = builder.put((Object)"Aacgr", (Object)902);
        builder = builder.put((Object)"aacute", (Object)225);
        builder = builder.put((Object)"Aacute", (Object)193);
        builder = builder.put((Object)"abreve", (Object)259);
        builder = builder.put((Object)"Abreve", (Object)258);
        builder = builder.put((Object)"ac", (Object)8766);
        builder = builder.put((Object)"acd", (Object)8767);
        builder = builder.put((Object)"acirc", (Object)226);
        builder = builder.put((Object)"Acirc", (Object)194);
        builder = builder.put((Object)"acute", (Object)180);
        builder = builder.put((Object)"acy", (Object)1072);
        builder = builder.put((Object)"Acy", (Object)1040);
        builder = builder.put((Object)"aelig", (Object)230);
        builder = builder.put((Object)"AElig", (Object)198);
        builder = builder.put((Object)"af", (Object)8289);
        builder = builder.put((Object)"afr", (Object)120094);
        builder = builder.put((Object)"Afr", (Object)120068);
        builder = builder.put((Object)"agr", (Object)945);
        builder = builder.put((Object)"Agr", (Object)913);
        builder = builder.put((Object)"agrave", (Object)224);
        builder = builder.put((Object)"Agrave", (Object)192);
        builder = builder.put((Object)"alefsym", (Object)8501);
        builder = builder.put((Object)"aleph", (Object)8501);
        builder = builder.put((Object)"alpha", (Object)945);
        builder = builder.put((Object)"Alpha", (Object)913);
        builder = builder.put((Object)"amacr", (Object)257);
        builder = builder.put((Object)"Amacr", (Object)256);
        builder = builder.put((Object)"amalg", (Object)10815);
        builder = builder.put((Object)"amp", (Object)38);
        builder = builder.put((Object)"AMP", (Object)38);
        builder = builder.put((Object)"and", (Object)8743);
        builder = builder.put((Object)"And", (Object)10835);
        builder = builder.put((Object)"andand", (Object)10837);
        builder = builder.put((Object)"andd", (Object)10844);
        builder = builder.put((Object)"andslope", (Object)10840);
        builder = builder.put((Object)"andv", (Object)10842);
        builder = builder.put((Object)"ang", (Object)8736);
        builder = builder.put((Object)"ange", (Object)10660);
        builder = builder.put((Object)"angle", (Object)8736);
        builder = builder.put((Object)"angmsd", (Object)8737);
        builder = builder.put((Object)"angmsdaa", (Object)10664);
        builder = builder.put((Object)"angmsdab", (Object)10665);
        builder = builder.put((Object)"angmsdac", (Object)10666);
        builder = builder.put((Object)"angmsdad", (Object)10667);
        builder = builder.put((Object)"angmsdae", (Object)10668);
        builder = builder.put((Object)"angmsdaf", (Object)10669);
        builder = builder.put((Object)"angmsdag", (Object)10670);
        builder = builder.put((Object)"angmsdah", (Object)10671);
        builder = builder.put((Object)"angrt", (Object)8735);
        builder = builder.put((Object)"angrtvb", (Object)8894);
        builder = builder.put((Object)"angrtvbd", (Object)10653);
        builder = builder.put((Object)"angsph", (Object)8738);
        builder = builder.put((Object)"angst", (Object)197);
        builder = builder.put((Object)"angzarr", (Object)9084);
        builder = builder.put((Object)"aogon", (Object)261);
        builder = builder.put((Object)"Aogon", (Object)260);
        builder = builder.put((Object)"aopf", (Object)120146);
        builder = builder.put((Object)"Aopf", (Object)120120);
        builder = builder.put((Object)"ap", (Object)8776);
        builder = builder.put((Object)"apacir", (Object)10863);
        builder = builder.put((Object)"ape", (Object)8778);
        builder = builder.put((Object)"apE", (Object)10864);
        builder = builder.put((Object)"apid", (Object)8779);
        builder = builder.put((Object)"apos", (Object)39);
        builder = builder.put((Object)"ApplyFunction", (Object)8289);
        builder = builder.put((Object)"approx", (Object)8776);
        builder = builder.put((Object)"approxeq", (Object)8778);
        builder = builder.put((Object)"aring", (Object)229);
        builder = builder.put((Object)"Aring", (Object)197);
        builder = builder.put((Object)"ascr", (Object)119990);
        builder = builder.put((Object)"Ascr", (Object)119964);
        builder = builder.put((Object)"Assign", (Object)8788);
        builder = builder.put((Object)"ast", (Object)42);
        builder = builder.put((Object)"asymp", (Object)8776);
        builder = builder.put((Object)"asympeq", (Object)8781);
        builder = builder.put((Object)"atilde", (Object)227);
        builder = builder.put((Object)"Atilde", (Object)195);
        builder = builder.put((Object)"auml", (Object)228);
        builder = builder.put((Object)"Auml", (Object)196);
        builder = builder.put((Object)"awconint", (Object)8755);
        builder = builder.put((Object)"awint", (Object)10769);
        builder = builder.put((Object)"b.alpha", (Object)120514);
        builder = builder.put((Object)"b.beta", (Object)120515);
        builder = builder.put((Object)"b.chi", (Object)120536);
        builder = builder.put((Object)"b.delta", (Object)120517);
        builder = builder.put((Object)"b.Delta", (Object)120491);
        builder = builder.put((Object)"b.epsi", (Object)120518);
        builder = builder.put((Object)"b.epsiv", (Object)120540);
        builder = builder.put((Object)"b.eta", (Object)120520);
        builder = builder.put((Object)"b.gamma", (Object)120516);
        builder = builder.put((Object)"b.Gamma", (Object)120490);
        builder = builder.put((Object)"b.gammad", (Object)120779);
        builder = builder.put((Object)"b.Gammad", (Object)120778);
        builder = builder.put((Object)"b.iota", (Object)120522);
        builder = builder.put((Object)"b.kappa", (Object)120523);
        builder = builder.put((Object)"b.kappav", (Object)120542);
        builder = builder.put((Object)"b.lambda", (Object)120524);
        builder = builder.put((Object)"b.Lambda", (Object)120498);
        builder = builder.put((Object)"b.mu", (Object)120525);
        builder = builder.put((Object)"b.nu", (Object)120526);
        builder = builder.put((Object)"b.omega", (Object)120538);
        builder = builder.put((Object)"b.Omega", (Object)120512);
        builder = builder.put((Object)"b.phi", (Object)120535);
        builder = builder.put((Object)"b.Phi", (Object)120509);
        builder = builder.put((Object)"b.phiv", (Object)120543);
        builder = builder.put((Object)"b.pi", (Object)120529);
        builder = builder.put((Object)"b.Pi", (Object)120503);
        builder = builder.put((Object)"b.piv", (Object)120545);
        builder = builder.put((Object)"b.psi", (Object)120537);
        builder = builder.put((Object)"b.Psi", (Object)120511);
        builder = builder.put((Object)"b.rho", (Object)120530);
        builder = builder.put((Object)"b.rhov", (Object)120544);
        builder = builder.put((Object)"b.sigma", (Object)120532);
        builder = builder.put((Object)"b.Sigma", (Object)120506);
        builder = builder.put((Object)"b.sigmav", (Object)120531);
        builder = builder.put((Object)"b.tau", (Object)120533);
        builder = builder.put((Object)"b.Theta", (Object)120495);
        builder = builder.put((Object)"b.thetas", (Object)120521);
        builder = builder.put((Object)"b.thetav", (Object)120541);
        builder = builder.put((Object)"b.upsi", (Object)120534);
        builder = builder.put((Object)"b.Upsi", (Object)120508);
        builder = builder.put((Object)"b.xi", (Object)120527);
        builder = builder.put((Object)"b.Xi", (Object)120501);
        builder = builder.put((Object)"b.zeta", (Object)120519);
        builder = builder.put((Object)"backcong", (Object)8780);
        builder = builder.put((Object)"backepsilon", (Object)1014);
        builder = builder.put((Object)"backprime", (Object)8245);
        builder = builder.put((Object)"backsim", (Object)8765);
        builder = builder.put((Object)"backsimeq", (Object)8909);
        builder = builder.put((Object)"Backslash", (Object)8726);
        builder = builder.put((Object)"Barv", (Object)10983);
        builder = builder.put((Object)"barvee", (Object)8893);
        builder = builder.put((Object)"barwed", (Object)8965);
        builder = builder.put((Object)"Barwed", (Object)8966);
        builder = builder.put((Object)"barwedge", (Object)8965);
        builder = builder.put((Object)"bbrk", (Object)9141);
        builder = builder.put((Object)"bbrktbrk", (Object)9142);
        builder = builder.put((Object)"bcong", (Object)8780);
        builder = builder.put((Object)"bcy", (Object)1073);
        builder = builder.put((Object)"Bcy", (Object)1041);
        builder = builder.put((Object)"bdquo", (Object)8222);
        builder = builder.put((Object)"becaus", (Object)8757);
        builder = builder.put((Object)"because", (Object)8757);
        builder = builder.put((Object)"Because", (Object)8757);
        builder = builder.put((Object)"bemptyv", (Object)10672);
        builder = builder.put((Object)"bepsi", (Object)1014);
        builder = builder.put((Object)"bernou", (Object)8492);
        builder = builder.put((Object)"Bernoullis", (Object)8492);
        builder = builder.put((Object)"beta", (Object)946);
        builder = builder.put((Object)"Beta", (Object)914);
        builder = builder.put((Object)"beth", (Object)8502);
        builder = builder.put((Object)"between", (Object)8812);
        builder = builder.put((Object)"bfr", (Object)120095);
        builder = builder.put((Object)"Bfr", (Object)120069);
        builder = builder.put((Object)"bgr", (Object)946);
        builder = builder.put((Object)"Bgr", (Object)914);
        builder = builder.put((Object)"bigcap", (Object)8898);
        builder = builder.put((Object)"bigcirc", (Object)9711);
        builder = builder.put((Object)"bigcup", (Object)8899);
        builder = builder.put((Object)"bigodot", (Object)10752);
        builder = builder.put((Object)"bigoplus", (Object)10753);
        builder = builder.put((Object)"bigotimes", (Object)10754);
        builder = builder.put((Object)"bigsqcup", (Object)10758);
        builder = builder.put((Object)"bigstar", (Object)9733);
        builder = builder.put((Object)"bigtriangledown", (Object)9661);
        builder = builder.put((Object)"bigtriangleup", (Object)9651);
        builder = builder.put((Object)"biguplus", (Object)10756);
        builder = builder.put((Object)"bigvee", (Object)8897);
        builder = builder.put((Object)"bigwedge", (Object)8896);
        builder = builder.put((Object)"bkarow", (Object)10509);
        builder = builder.put((Object)"blacklozenge", (Object)10731);
        builder = builder.put((Object)"blacksquare", (Object)9642);
        builder = builder.put((Object)"blacktriangle", (Object)9652);
        builder = builder.put((Object)"blacktriangledown", (Object)9662);
        builder = builder.put((Object)"blacktriangleleft", (Object)9666);
        builder = builder.put((Object)"blacktriangleright", (Object)9656);
        builder = builder.put((Object)"blank", (Object)9251);
        builder = builder.put((Object)"blk12", (Object)9618);
        builder = builder.put((Object)"blk14", (Object)9617);
        builder = builder.put((Object)"blk34", (Object)9619);
        builder = builder.put((Object)"block", (Object)9608);
        builder = builder.put((Object)"bnot", (Object)8976);
        builder = builder.put((Object)"bNot", (Object)10989);
        builder = builder.put((Object)"bopf", (Object)120147);
        builder = builder.put((Object)"Bopf", (Object)120121);
        builder = builder.put((Object)"bot", (Object)8869);
        builder = builder.put((Object)"bottom", (Object)8869);
        builder = builder.put((Object)"bowtie", (Object)8904);
        builder = builder.put((Object)"boxbox", (Object)10697);
        builder = builder.put((Object)"boxdl", (Object)9488);
        builder = builder.put((Object)"boxdL", (Object)9557);
        builder = builder.put((Object)"boxDl", (Object)9558);
        builder = builder.put((Object)"boxDL", (Object)9559);
        builder = builder.put((Object)"boxdr", (Object)9484);
        builder = builder.put((Object)"boxdR", (Object)9554);
        builder = builder.put((Object)"boxDr", (Object)9555);
        builder = builder.put((Object)"boxDR", (Object)9556);
        builder = builder.put((Object)"boxh", (Object)9472);
        builder = builder.put((Object)"boxH", (Object)9552);
        builder = builder.put((Object)"boxhd", (Object)9516);
        builder = builder.put((Object)"boxhD", (Object)9573);
        builder = builder.put((Object)"boxHd", (Object)9572);
        builder = builder.put((Object)"boxHD", (Object)9574);
        builder = builder.put((Object)"boxhu", (Object)9524);
        builder = builder.put((Object)"boxhU", (Object)9576);
        builder = builder.put((Object)"boxHu", (Object)9575);
        builder = builder.put((Object)"boxHU", (Object)9577);
        builder = builder.put((Object)"boxminus", (Object)8863);
        builder = builder.put((Object)"boxplus", (Object)8862);
        builder = builder.put((Object)"boxtimes", (Object)8864);
        builder = builder.put((Object)"boxul", (Object)9496);
        builder = builder.put((Object)"boxuL", (Object)9563);
        builder = builder.put((Object)"boxUl", (Object)9564);
        builder = builder.put((Object)"boxUL", (Object)9565);
        builder = builder.put((Object)"boxur", (Object)9492);
        builder = builder.put((Object)"boxuR", (Object)9560);
        builder = builder.put((Object)"boxUr", (Object)9561);
        builder = builder.put((Object)"boxUR", (Object)9562);
        builder = builder.put((Object)"boxv", (Object)9474);
        builder = builder.put((Object)"boxV", (Object)9553);
        builder = builder.put((Object)"boxvh", (Object)9532);
        builder = builder.put((Object)"boxvH", (Object)9578);
        builder = builder.put((Object)"boxVh", (Object)9579);
        builder = builder.put((Object)"boxVH", (Object)9580);
        builder = builder.put((Object)"boxvl", (Object)9508);
        builder = builder.put((Object)"boxvL", (Object)9569);
        builder = builder.put((Object)"boxVl", (Object)9570);
        builder = builder.put((Object)"boxVL", (Object)9571);
        builder = builder.put((Object)"boxvr", (Object)9500);
        builder = builder.put((Object)"boxvR", (Object)9566);
        builder = builder.put((Object)"boxVr", (Object)9567);
        builder = builder.put((Object)"boxVR", (Object)9568);
        builder = builder.put((Object)"bprime", (Object)8245);
        builder = builder.put((Object)"breve", (Object)728);
        builder = builder.put((Object)"Breve", (Object)728);
        builder = builder.put((Object)"brvbar", (Object)166);
        builder = builder.put((Object)"bscr", (Object)119991);
        builder = builder.put((Object)"Bscr", (Object)8492);
        builder = builder.put((Object)"bsemi", (Object)8271);
        builder = builder.put((Object)"bsim", (Object)8765);
        builder = builder.put((Object)"bsime", (Object)8909);
        builder = builder.put((Object)"bsol", (Object)92);
        builder = builder.put((Object)"bsolb", (Object)10693);
        builder = builder.put((Object)"bsolhsub", (Object)10184);
        builder = builder.put((Object)"bull", (Object)8226);
        builder = builder.put((Object)"bullet", (Object)8226);
        builder = builder.put((Object)"bump", (Object)8782);
        builder = builder.put((Object)"bumpe", (Object)8783);
        builder = builder.put((Object)"bumpE", (Object)10926);
        builder = builder.put((Object)"bumpeq", (Object)8783);
        builder = builder.put((Object)"Bumpeq", (Object)8782);
        builder = builder.put((Object)"cacute", (Object)263);
        builder = builder.put((Object)"Cacute", (Object)262);
        builder = builder.put((Object)"cap", (Object)8745);
        builder = builder.put((Object)"Cap", (Object)8914);
        builder = builder.put((Object)"capand", (Object)10820);
        builder = builder.put((Object)"capbrcup", (Object)10825);
        builder = builder.put((Object)"capcap", (Object)10827);
        builder = builder.put((Object)"capcup", (Object)10823);
        builder = builder.put((Object)"capdot", (Object)10816);
        builder = builder.put((Object)"CapitalDifferentialD", (Object)8517);
        builder = builder.put((Object)"caret", (Object)8257);
        builder = builder.put((Object)"caron", (Object)711);
        builder = builder.put((Object)"Cayleys", (Object)8493);
        builder = builder.put((Object)"ccaps", (Object)10829);
        builder = builder.put((Object)"ccaron", (Object)269);
        builder = builder.put((Object)"Ccaron", (Object)268);
        builder = builder.put((Object)"ccedil", (Object)231);
        builder = builder.put((Object)"Ccedil", (Object)199);
        builder = builder.put((Object)"ccirc", (Object)265);
        builder = builder.put((Object)"Ccirc", (Object)264);
        builder = builder.put((Object)"Cconint", (Object)8752);
        builder = builder.put((Object)"ccups", (Object)10828);
        builder = builder.put((Object)"ccupssm", (Object)10832);
        builder = builder.put((Object)"cdot", (Object)267);
        builder = builder.put((Object)"Cdot", (Object)266);
        builder = builder.put((Object)"cedil", (Object)184);
        builder = builder.put((Object)"Cedilla", (Object)184);
        builder = builder.put((Object)"cemptyv", (Object)10674);
        builder = builder.put((Object)"cent", (Object)162);
        builder = builder.put((Object)"centerdot", (Object)183);
        builder = builder.put((Object)"CenterDot", (Object)183);
        builder = builder.put((Object)"cfr", (Object)120096);
        builder = builder.put((Object)"Cfr", (Object)8493);
        builder = builder.put((Object)"chcy", (Object)1095);
        builder = builder.put((Object)"CHcy", (Object)1063);
        builder = builder.put((Object)"check", (Object)10003);
        builder = builder.put((Object)"checkmark", (Object)10003);
        builder = builder.put((Object)"chi", (Object)967);
        builder = builder.put((Object)"Chi", (Object)935);
        builder = builder.put((Object)"cir", (Object)9675);
        builder = builder.put((Object)"circ", (Object)710);
        builder = builder.put((Object)"circeq", (Object)8791);
        builder = builder.put((Object)"circlearrowleft", (Object)8634);
        builder = builder.put((Object)"circlearrowright", (Object)8635);
        builder = builder.put((Object)"circledast", (Object)8859);
        builder = builder.put((Object)"circledcirc", (Object)8858);
        builder = builder.put((Object)"circleddash", (Object)8861);
        builder = builder.put((Object)"CircleDot", (Object)8857);
        builder = builder.put((Object)"circledR", (Object)174);
        builder = builder.put((Object)"circledS", (Object)9416);
        builder = builder.put((Object)"CircleMinus", (Object)8854);
        builder = builder.put((Object)"CirclePlus", (Object)8853);
        builder = builder.put((Object)"CircleTimes", (Object)8855);
        builder = builder.put((Object)"cire", (Object)8791);
        builder = builder.put((Object)"cirE", (Object)10691);
        builder = builder.put((Object)"cirfnint", (Object)10768);
        builder = builder.put((Object)"cirmid", (Object)10991);
        builder = builder.put((Object)"cirscir", (Object)10690);
        builder = builder.put((Object)"ClockwiseContourIntegral", (Object)8754);
        builder = builder.put((Object)"CloseCurlyDoubleQuote", (Object)8221);
        builder = builder.put((Object)"CloseCurlyQuote", (Object)8217);
        builder = builder.put((Object)"clubs", (Object)9827);
        builder = builder.put((Object)"clubsuit", (Object)9827);
        builder = builder.put((Object)"colon", (Object)58);
        builder = builder.put((Object)"Colon", (Object)8759);
        builder = builder.put((Object)"colone", (Object)8788);
        builder = builder.put((Object)"Colone", (Object)10868);
        builder = builder.put((Object)"coloneq", (Object)8788);
        builder = builder.put((Object)"comma", (Object)44);
        builder = builder.put((Object)"commat", (Object)64);
        builder = builder.put((Object)"comp", (Object)8705);
        builder = builder.put((Object)"compfn", (Object)8728);
        builder = builder.put((Object)"complement", (Object)8705);
        builder = builder.put((Object)"complexes", (Object)8450);
        builder = builder.put((Object)"cong", (Object)8773);
        builder = builder.put((Object)"congdot", (Object)10861);
        builder = builder.put((Object)"Congruent", (Object)8801);
        builder = builder.put((Object)"conint", (Object)8750);
        builder = builder.put((Object)"Conint", (Object)8751);
        builder = builder.put((Object)"ContourIntegral", (Object)8750);
        builder = builder.put((Object)"copf", (Object)120148);
        builder = builder.put((Object)"Copf", (Object)8450);
        builder = builder.put((Object)"coprod", (Object)8720);
        builder = builder.put((Object)"Coproduct", (Object)8720);
        builder = builder.put((Object)"copy", (Object)169);
        builder = builder.put((Object)"COPY", (Object)169);
        builder = builder.put((Object)"copysr", (Object)8471);
        builder = builder.put((Object)"CounterClockwiseContourIntegral", (Object)8755);
        builder = builder.put((Object)"crarr", (Object)8629);
        builder = builder.put((Object)"cross", (Object)10007);
        builder = builder.put((Object)"Cross", (Object)10799);
        builder = builder.put((Object)"cscr", (Object)119992);
        builder = builder.put((Object)"Cscr", (Object)119966);
        builder = builder.put((Object)"csub", (Object)10959);
        builder = builder.put((Object)"csube", (Object)10961);
        builder = builder.put((Object)"csup", (Object)10960);
        builder = builder.put((Object)"csupe", (Object)10962);
        builder = builder.put((Object)"ctdot", (Object)8943);
        builder = builder.put((Object)"cudarrl", (Object)10552);
        builder = builder.put((Object)"cudarrr", (Object)10549);
        builder = builder.put((Object)"cuepr", (Object)8926);
        builder = builder.put((Object)"cuesc", (Object)8927);
        builder = builder.put((Object)"cularr", (Object)8630);
        builder = builder.put((Object)"cularrp", (Object)10557);
        builder = builder.put((Object)"cup", (Object)8746);
        builder = builder.put((Object)"Cup", (Object)8915);
        builder = builder.put((Object)"cupbrcap", (Object)10824);
        builder = builder.put((Object)"cupcap", (Object)10822);
        builder = builder.put((Object)"CupCap", (Object)8781);
        builder = builder.put((Object)"cupcup", (Object)10826);
        builder = builder.put((Object)"cupdot", (Object)8845);
        builder = builder.put((Object)"cupor", (Object)10821);
        builder = builder.put((Object)"curarr", (Object)8631);
        builder = builder.put((Object)"curarrm", (Object)10556);
        builder = builder.put((Object)"curlyeqprec", (Object)8926);
        builder = builder.put((Object)"curlyeqsucc", (Object)8927);
        builder = builder.put((Object)"curlyvee", (Object)8910);
        builder = builder.put((Object)"curlywedge", (Object)8911);
        builder = builder.put((Object)"curren", (Object)164);
        builder = builder.put((Object)"curvearrowleft", (Object)8630);
        builder = builder.put((Object)"curvearrowright", (Object)8631);
        builder = builder.put((Object)"cuvee", (Object)8910);
        builder = builder.put((Object)"cuwed", (Object)8911);
        builder = builder.put((Object)"cwconint", (Object)8754);
        builder = builder.put((Object)"cwint", (Object)8753);
        builder = builder.put((Object)"cylcty", (Object)9005);
        builder = builder.put((Object)"dagger", (Object)8224);
        builder = builder.put((Object)"Dagger", (Object)8225);
        builder = builder.put((Object)"daleth", (Object)8504);
        builder = builder.put((Object)"darr", (Object)8595);
        builder = builder.put((Object)"dArr", (Object)8659);
        builder = builder.put((Object)"Darr", (Object)8609);
        builder = builder.put((Object)"dash", (Object)8208);
        builder = builder.put((Object)"dashv", (Object)8867);
        builder = builder.put((Object)"Dashv", (Object)10980);
        builder = builder.put((Object)"dbkarow", (Object)10511);
        builder = builder.put((Object)"dblac", (Object)733);
        builder = builder.put((Object)"dcaron", (Object)271);
        builder = builder.put((Object)"Dcaron", (Object)270);
        builder = builder.put((Object)"dcy", (Object)1076);
        builder = builder.put((Object)"Dcy", (Object)1044);
        builder = builder.put((Object)"dd", (Object)8518);
        builder = builder.put((Object)"DD", (Object)8517);
        builder = builder.put((Object)"ddagger", (Object)8225);
        builder = builder.put((Object)"ddarr", (Object)8650);
        builder = builder.put((Object)"DDotrahd", (Object)10513);
        builder = builder.put((Object)"ddotseq", (Object)10871);
        builder = builder.put((Object)"deg", (Object)176);
        builder = builder.put((Object)"Del", (Object)8711);
        builder = builder.put((Object)"delta", (Object)948);
        builder = builder.put((Object)"Delta", (Object)916);
        builder = builder.put((Object)"demptyv", (Object)10673);
        builder = builder.put((Object)"dfisht", (Object)10623);
        builder = builder.put((Object)"dfr", (Object)120097);
        builder = builder.put((Object)"Dfr", (Object)120071);
        builder = builder.put((Object)"dgr", (Object)948);
        builder = builder.put((Object)"Dgr", (Object)916);
        builder = builder.put((Object)"dHar", (Object)10597);
        builder = builder.put((Object)"dharl", (Object)8643);
        builder = builder.put((Object)"dharr", (Object)8642);
        builder = builder.put((Object)"DiacriticalAcute", (Object)180);
        builder = builder.put((Object)"DiacriticalDot", (Object)729);
        builder = builder.put((Object)"DiacriticalDoubleAcute", (Object)733);
        builder = builder.put((Object)"DiacriticalGrave", (Object)96);
        builder = builder.put((Object)"DiacriticalTilde", (Object)732);
        builder = builder.put((Object)"diam", (Object)8900);
        builder = builder.put((Object)"diamond", (Object)8900);
        builder = builder.put((Object)"Diamond", (Object)8900);
        builder = builder.put((Object)"diamondsuit", (Object)9830);
        builder = builder.put((Object)"diams", (Object)9830);
        builder = builder.put((Object)"die", (Object)168);
        builder = builder.put((Object)"DifferentialD", (Object)8518);
        builder = builder.put((Object)"digamma", (Object)989);
        builder = builder.put((Object)"disin", (Object)8946);
        builder = builder.put((Object)"div", (Object)247);
        builder = builder.put((Object)"divide", (Object)247);
        builder = builder.put((Object)"divideontimes", (Object)8903);
        builder = builder.put((Object)"divonx", (Object)8903);
        builder = builder.put((Object)"djcy", (Object)1106);
        builder = builder.put((Object)"DJcy", (Object)1026);
        builder = builder.put((Object)"dlcorn", (Object)8990);
        builder = builder.put((Object)"dlcrop", (Object)8973);
        builder = builder.put((Object)"dollar", (Object)36);
        builder = builder.put((Object)"dopf", (Object)120149);
        builder = builder.put((Object)"Dopf", (Object)120123);
        builder = builder.put((Object)"dot", (Object)729);
        builder = builder.put((Object)"Dot", (Object)168);
        builder = builder.put((Object)"DotDot", (Object)8412);
        builder = builder.put((Object)"doteq", (Object)8784);
        builder = builder.put((Object)"doteqdot", (Object)8785);
        builder = builder.put((Object)"DotEqual", (Object)8784);
        builder = builder.put((Object)"dotminus", (Object)8760);
        builder = builder.put((Object)"dotplus", (Object)8724);
        builder = builder.put((Object)"dotsquare", (Object)8865);
        builder = builder.put((Object)"doublebarwedge", (Object)8966);
        builder = builder.put((Object)"DoubleContourIntegral", (Object)8751);
        builder = builder.put((Object)"DoubleDot", (Object)168);
        builder = builder.put((Object)"DoubleDownArrow", (Object)8659);
        builder = builder.put((Object)"DoubleLeftArrow", (Object)8656);
        builder = builder.put((Object)"DoubleLeftRightArrow", (Object)8660);
        builder = builder.put((Object)"DoubleLeftTee", (Object)10980);
        builder = builder.put((Object)"DoubleLongLeftArrow", (Object)10232);
        builder = builder.put((Object)"DoubleLongLeftRightArrow", (Object)10234);
        builder = builder.put((Object)"DoubleLongRightArrow", (Object)10233);
        builder = builder.put((Object)"DoubleRightArrow", (Object)8658);
        builder = builder.put((Object)"DoubleRightTee", (Object)8872);
        builder = builder.put((Object)"DoubleUpArrow", (Object)8657);
        builder = builder.put((Object)"DoubleUpDownArrow", (Object)8661);
        builder = builder.put((Object)"DoubleVerticalBar", (Object)8741);
        builder = builder.put((Object)"downarrow", (Object)8595);
        builder = builder.put((Object)"Downarrow", (Object)8659);
        builder = builder.put((Object)"DownArrow", (Object)8595);
        builder = builder.put((Object)"DownArrowBar", (Object)10515);
        builder = builder.put((Object)"DownArrowUpArrow", (Object)8693);
        builder = builder.put((Object)"DownBreve", (Object)785);
        builder = builder.put((Object)"downdownarrows", (Object)8650);
        builder = builder.put((Object)"downharpoonleft", (Object)8643);
        builder = builder.put((Object)"downharpoonright", (Object)8642);
        builder = builder.put((Object)"DownLeftRightVector", (Object)10576);
        builder = builder.put((Object)"DownLeftTeeVector", (Object)10590);
        builder = builder.put((Object)"DownLeftVector", (Object)8637);
        builder = builder.put((Object)"DownLeftVectorBar", (Object)10582);
        builder = builder.put((Object)"DownRightTeeVector", (Object)10591);
        builder = builder.put((Object)"DownRightVector", (Object)8641);
        builder = builder.put((Object)"DownRightVectorBar", (Object)10583);
        builder = builder.put((Object)"DownTee", (Object)8868);
        builder = builder.put((Object)"DownTeeArrow", (Object)8615);
        builder = builder.put((Object)"drbkarow", (Object)10512);
        builder = builder.put((Object)"drcorn", (Object)8991);
        builder = builder.put((Object)"drcrop", (Object)8972);
        builder = builder.put((Object)"dscr", (Object)119993);
        builder = builder.put((Object)"Dscr", (Object)119967);
        builder = builder.put((Object)"dscy", (Object)1109);
        builder = builder.put((Object)"DScy", (Object)1029);
        builder = builder.put((Object)"dsol", (Object)10742);
        builder = builder.put((Object)"dstrok", (Object)273);
        builder = builder.put((Object)"Dstrok", (Object)272);
        builder = builder.put((Object)"dtdot", (Object)8945);
        builder = builder.put((Object)"dtri", (Object)9663);
        builder = builder.put((Object)"dtrif", (Object)9662);
        builder = builder.put((Object)"duarr", (Object)8693);
        builder = builder.put((Object)"duhar", (Object)10607);
        builder = builder.put((Object)"dwangle", (Object)10662);
        builder = builder.put((Object)"dzcy", (Object)1119);
        builder = builder.put((Object)"DZcy", (Object)1039);
        builder = builder.put((Object)"dzigrarr", (Object)10239);
        builder = builder.put((Object)"eacgr", (Object)941);
        builder = builder.put((Object)"Eacgr", (Object)904);
        builder = builder.put((Object)"eacute", (Object)233);
        builder = builder.put((Object)"Eacute", (Object)201);
        builder = builder.put((Object)"easter", (Object)10862);
        builder = builder.put((Object)"ecaron", (Object)283);
        builder = builder.put((Object)"Ecaron", (Object)282);
        builder = builder.put((Object)"ecir", (Object)8790);
        builder = builder.put((Object)"ecirc", (Object)234);
        builder = builder.put((Object)"Ecirc", (Object)202);
        builder = builder.put((Object)"ecolon", (Object)8789);
        builder = builder.put((Object)"ecy", (Object)1101);
        builder = builder.put((Object)"Ecy", (Object)1069);
        builder = builder.put((Object)"eDDot", (Object)10871);
        builder = builder.put((Object)"edot", (Object)279);
        builder = builder.put((Object)"eDot", (Object)8785);
        builder = builder.put((Object)"Edot", (Object)278);
        builder = builder.put((Object)"ee", (Object)8519);
        builder = builder.put((Object)"eeacgr", (Object)942);
        builder = builder.put((Object)"EEacgr", (Object)905);
        builder = builder.put((Object)"eegr", (Object)951);
        builder = builder.put((Object)"EEgr", (Object)919);
        builder = builder.put((Object)"efDot", (Object)8786);
        builder = builder.put((Object)"efr", (Object)120098);
        builder = builder.put((Object)"Efr", (Object)120072);
        builder = builder.put((Object)"eg", (Object)10906);
        builder = builder.put((Object)"egr", (Object)949);
        builder = builder.put((Object)"Egr", (Object)917);
        builder = builder.put((Object)"egrave", (Object)232);
        builder = builder.put((Object)"Egrave", (Object)200);
        builder = builder.put((Object)"egs", (Object)10902);
        builder = builder.put((Object)"egsdot", (Object)10904);
        builder = builder.put((Object)"el", (Object)10905);
        builder = builder.put((Object)"Element", (Object)8712);
        builder = builder.put((Object)"elinters", (Object)9191);
        builder = builder.put((Object)"ell", (Object)8467);
        builder = builder.put((Object)"els", (Object)10901);
        builder = builder.put((Object)"elsdot", (Object)10903);
        builder = builder.put((Object)"emacr", (Object)275);
        builder = builder.put((Object)"Emacr", (Object)274);
        builder = builder.put((Object)"empty", (Object)8709);
        builder = builder.put((Object)"emptyset", (Object)8709);
        builder = builder.put((Object)"EmptySmallSquare", (Object)9723);
        builder = builder.put((Object)"emptyv", (Object)8709);
        builder = builder.put((Object)"EmptyVerySmallSquare", (Object)9643);
        builder = builder.put((Object)"emsp", (Object)8195);
        builder = builder.put((Object)"emsp13", (Object)8196);
        builder = builder.put((Object)"emsp14", (Object)8197);
        builder = builder.put((Object)"eng", (Object)331);
        builder = builder.put((Object)"ENG", (Object)330);
        builder = builder.put((Object)"ensp", (Object)8194);
        builder = builder.put((Object)"eogon", (Object)281);
        builder = builder.put((Object)"Eogon", (Object)280);
        builder = builder.put((Object)"eopf", (Object)120150);
        builder = builder.put((Object)"Eopf", (Object)120124);
        builder = builder.put((Object)"epar", (Object)8917);
        builder = builder.put((Object)"eparsl", (Object)10723);
        builder = builder.put((Object)"eplus", (Object)10865);
        builder = builder.put((Object)"epsi", (Object)949);
        builder = builder.put((Object)"epsilon", (Object)949);
        builder = builder.put((Object)"Epsilon", (Object)917);
        builder = builder.put((Object)"epsiv", (Object)1013);
        builder = builder.put((Object)"eqcirc", (Object)8790);
        builder = builder.put((Object)"eqcolon", (Object)8789);
        builder = builder.put((Object)"eqsim", (Object)8770);
        builder = builder.put((Object)"eqslantgtr", (Object)10902);
        builder = builder.put((Object)"eqslantless", (Object)10901);
        builder = builder.put((Object)"Equal", (Object)10869);
        builder = builder.put((Object)"equals", (Object)61);
        builder = builder.put((Object)"EqualTilde", (Object)8770);
        builder = builder.put((Object)"equest", (Object)8799);
        builder = builder.put((Object)"Equilibrium", (Object)8652);
        builder = builder.put((Object)"equiv", (Object)8801);
        builder = builder.put((Object)"equivDD", (Object)10872);
        builder = builder.put((Object)"eqvparsl", (Object)10725);
        builder = builder.put((Object)"erarr", (Object)10609);
        builder = builder.put((Object)"erDot", (Object)8787);
        builder = builder.put((Object)"escr", (Object)8495);
        builder = builder.put((Object)"Escr", (Object)8496);
        builder = builder.put((Object)"esdot", (Object)8784);
        builder = builder.put((Object)"esim", (Object)8770);
        builder = builder.put((Object)"Esim", (Object)10867);
        builder = builder.put((Object)"eta", (Object)951);
        builder = builder.put((Object)"Eta", (Object)919);
        builder = builder.put((Object)"eth", (Object)240);
        builder = builder.put((Object)"ETH", (Object)208);
        builder = builder.put((Object)"euml", (Object)235);
        builder = builder.put((Object)"Euml", (Object)203);
        builder = builder.put((Object)"euro", (Object)8364);
        builder = builder.put((Object)"excl", (Object)33);
        builder = builder.put((Object)"exist", (Object)8707);
        builder = builder.put((Object)"Exists", (Object)8707);
        builder = builder.put((Object)"expectation", (Object)8496);
        builder = builder.put((Object)"exponentiale", (Object)8519);
        builder = builder.put((Object)"ExponentialE", (Object)8519);
        builder = builder.put((Object)"fallingdotseq", (Object)8786);
        builder = builder.put((Object)"fcy", (Object)1092);
        builder = builder.put((Object)"Fcy", (Object)1060);
        builder = builder.put((Object)"female", (Object)9792);
        builder = builder.put((Object)"ffilig", (Object)64259);
        builder = builder.put((Object)"fflig", (Object)64256);
        builder = builder.put((Object)"ffllig", (Object)64260);
        builder = builder.put((Object)"ffr", (Object)120099);
        builder = builder.put((Object)"Ffr", (Object)120073);
        builder = builder.put((Object)"filig", (Object)64257);
        builder = builder.put((Object)"FilledSmallSquare", (Object)9724);
        builder = builder.put((Object)"FilledVerySmallSquare", (Object)9642);
        builder = builder.put((Object)"flat", (Object)9837);
        builder = builder.put((Object)"fllig", (Object)64258);
        builder = builder.put((Object)"fltns", (Object)9649);
        builder = builder.put((Object)"fnof", (Object)402);
        builder = builder.put((Object)"fopf", (Object)120151);
        builder = builder.put((Object)"Fopf", (Object)120125);
        builder = builder.put((Object)"forall", (Object)8704);
        builder = builder.put((Object)"ForAll", (Object)8704);
        builder = builder.put((Object)"fork", (Object)8916);
        builder = builder.put((Object)"forkv", (Object)10969);
        builder = builder.put((Object)"Fouriertrf", (Object)8497);
        builder = builder.put((Object)"fpartint", (Object)10765);
        builder = builder.put((Object)"frac12", (Object)189);
        builder = builder.put((Object)"frac13", (Object)8531);
        builder = builder.put((Object)"frac14", (Object)188);
        builder = builder.put((Object)"frac15", (Object)8533);
        builder = builder.put((Object)"frac16", (Object)8537);
        builder = builder.put((Object)"frac18", (Object)8539);
        builder = builder.put((Object)"frac23", (Object)8532);
        builder = builder.put((Object)"frac25", (Object)8534);
        builder = builder.put((Object)"frac34", (Object)190);
        builder = builder.put((Object)"frac35", (Object)8535);
        builder = builder.put((Object)"frac38", (Object)8540);
        builder = builder.put((Object)"frac45", (Object)8536);
        builder = builder.put((Object)"frac56", (Object)8538);
        builder = builder.put((Object)"frac58", (Object)8541);
        builder = builder.put((Object)"frac78", (Object)8542);
        builder = builder.put((Object)"frasl", (Object)8260);
        builder = builder.put((Object)"frown", (Object)8994);
        builder = builder.put((Object)"fscr", (Object)119995);
        builder = builder.put((Object)"Fscr", (Object)8497);
        builder = builder.put((Object)"gacute", (Object)501);
        builder = builder.put((Object)"gamma", (Object)947);
        builder = builder.put((Object)"Gamma", (Object)915);
        builder = builder.put((Object)"gammad", (Object)989);
        builder = builder.put((Object)"Gammad", (Object)988);
        builder = builder.put((Object)"gap", (Object)10886);
        builder = builder.put((Object)"gbreve", (Object)287);
        builder = builder.put((Object)"Gbreve", (Object)286);
        builder = builder.put((Object)"Gcedil", (Object)290);
        builder = builder.put((Object)"gcirc", (Object)285);
        builder = builder.put((Object)"Gcirc", (Object)284);
        builder = builder.put((Object)"gcy", (Object)1075);
        builder = builder.put((Object)"Gcy", (Object)1043);
        builder = builder.put((Object)"gdot", (Object)289);
        builder = builder.put((Object)"Gdot", (Object)288);
        builder = builder.put((Object)"ge", (Object)8805);
        builder = builder.put((Object)"gE", (Object)8807);
        builder = builder.put((Object)"gel", (Object)8923);
        builder = builder.put((Object)"gEl", (Object)10892);
        builder = builder.put((Object)"geq", (Object)8805);
        builder = builder.put((Object)"geqq", (Object)8807);
        builder = builder.put((Object)"geqslant", (Object)10878);
        builder = builder.put((Object)"ges", (Object)10878);
        builder = builder.put((Object)"gescc", (Object)10921);
        builder = builder.put((Object)"gesdot", (Object)10880);
        builder = builder.put((Object)"gesdoto", (Object)10882);
        builder = builder.put((Object)"gesdotol", (Object)10884);
        builder = builder.put((Object)"gesles", (Object)10900);
        builder = builder.put((Object)"gfr", (Object)120100);
        builder = builder.put((Object)"Gfr", (Object)120074);
        builder = builder.put((Object)"gg", (Object)8811);
        builder = builder.put((Object)"Gg", (Object)8921);
        builder = builder.put((Object)"ggg", (Object)8921);
        builder = builder.put((Object)"ggr", (Object)947);
        builder = builder.put((Object)"Ggr", (Object)915);
        builder = builder.put((Object)"gimel", (Object)8503);
        builder = builder.put((Object)"gjcy", (Object)1107);
        builder = builder.put((Object)"GJcy", (Object)1027);
        builder = builder.put((Object)"gl", (Object)8823);
        builder = builder.put((Object)"gla", (Object)10917);
        builder = builder.put((Object)"glE", (Object)10898);
        builder = builder.put((Object)"glj", (Object)10916);
        builder = builder.put((Object)"gnap", (Object)10890);
        builder = builder.put((Object)"gnapprox", (Object)10890);
        builder = builder.put((Object)"gne", (Object)10888);
        builder = builder.put((Object)"gnE", (Object)8809);
        builder = builder.put((Object)"gneq", (Object)10888);
        builder = builder.put((Object)"gneqq", (Object)8809);
        builder = builder.put((Object)"gnsim", (Object)8935);
        builder = builder.put((Object)"gopf", (Object)120152);
        builder = builder.put((Object)"Gopf", (Object)120126);
        builder = builder.put((Object)"grave", (Object)96);
        builder = builder.put((Object)"GreaterEqual", (Object)8805);
        builder = builder.put((Object)"GreaterEqualLess", (Object)8923);
        builder = builder.put((Object)"GreaterFullEqual", (Object)8807);
        builder = builder.put((Object)"GreaterGreater", (Object)10914);
        builder = builder.put((Object)"GreaterLess", (Object)8823);
        builder = builder.put((Object)"GreaterSlantEqual", (Object)10878);
        builder = builder.put((Object)"GreaterTilde", (Object)8819);
        builder = builder.put((Object)"gscr", (Object)8458);
        builder = builder.put((Object)"Gscr", (Object)119970);
        builder = builder.put((Object)"gsim", (Object)8819);
        builder = builder.put((Object)"gsime", (Object)10894);
        builder = builder.put((Object)"gsiml", (Object)10896);
        builder = builder.put((Object)"gt", (Object)62);
        builder = builder.put((Object)"Gt", (Object)8811);
        builder = builder.put((Object)"GT", (Object)62);
        builder = builder.put((Object)"gtcc", (Object)10919);
        builder = builder.put((Object)"gtcir", (Object)10874);
        builder = builder.put((Object)"gtdot", (Object)8919);
        builder = builder.put((Object)"gtlPar", (Object)10645);
        builder = builder.put((Object)"gtquest", (Object)10876);
        builder = builder.put((Object)"gtrapprox", (Object)10886);
        builder = builder.put((Object)"gtrarr", (Object)10616);
        builder = builder.put((Object)"gtrdot", (Object)8919);
        builder = builder.put((Object)"gtreqless", (Object)8923);
        builder = builder.put((Object)"gtreqqless", (Object)10892);
        builder = builder.put((Object)"gtrless", (Object)8823);
        builder = builder.put((Object)"gtrsim", (Object)8819);
        builder = builder.put((Object)"Hacek", (Object)711);
        builder = builder.put((Object)"hairsp", (Object)8202);
        builder = builder.put((Object)"half", (Object)189);
        builder = builder.put((Object)"hamilt", (Object)8459);
        builder = builder.put((Object)"hardcy", (Object)1098);
        builder = builder.put((Object)"HARDcy", (Object)1066);
        builder = builder.put((Object)"harr", (Object)8596);
        builder = builder.put((Object)"hArr", (Object)8660);
        builder = builder.put((Object)"harrcir", (Object)10568);
        builder = builder.put((Object)"harrw", (Object)8621);
        builder = builder.put((Object)"Hat", (Object)94);
        builder = builder.put((Object)"hbar", (Object)8463);
        builder = builder.put((Object)"hcirc", (Object)293);
        builder = builder.put((Object)"Hcirc", (Object)292);
        builder = builder.put((Object)"hearts", (Object)9829);
        builder = builder.put((Object)"heartsuit", (Object)9829);
        builder = builder.put((Object)"hellip", (Object)8230);
        builder = builder.put((Object)"hercon", (Object)8889);
        builder = builder.put((Object)"hfr", (Object)120101);
        builder = builder.put((Object)"Hfr", (Object)8460);
        builder = builder.put((Object)"HilbertSpace", (Object)8459);
        builder = builder.put((Object)"hksearow", (Object)10533);
        builder = builder.put((Object)"hkswarow", (Object)10534);
        builder = builder.put((Object)"hoarr", (Object)8703);
        builder = builder.put((Object)"homtht", (Object)8763);
        builder = builder.put((Object)"hookleftarrow", (Object)8617);
        builder = builder.put((Object)"hookrightarrow", (Object)8618);
        builder = builder.put((Object)"hopf", (Object)120153);
        builder = builder.put((Object)"Hopf", (Object)8461);
        builder = builder.put((Object)"horbar", (Object)8213);
        builder = builder.put((Object)"HorizontalLine", (Object)9472);
        builder = builder.put((Object)"hscr", (Object)119997);
        builder = builder.put((Object)"Hscr", (Object)8459);
        builder = builder.put((Object)"hslash", (Object)8463);
        builder = builder.put((Object)"hstrok", (Object)295);
        builder = builder.put((Object)"Hstrok", (Object)294);
        builder = builder.put((Object)"HumpDownHump", (Object)8782);
        builder = builder.put((Object)"HumpEqual", (Object)8783);
        builder = builder.put((Object)"hybull", (Object)8259);
        builder = builder.put((Object)"hyphen", (Object)8208);
        builder = builder.put((Object)"iacgr", (Object)943);
        builder = builder.put((Object)"Iacgr", (Object)906);
        builder = builder.put((Object)"iacute", (Object)237);
        builder = builder.put((Object)"Iacute", (Object)205);
        builder = builder.put((Object)"ic", (Object)8291);
        builder = builder.put((Object)"icirc", (Object)238);
        builder = builder.put((Object)"Icirc", (Object)206);
        builder = builder.put((Object)"icy", (Object)1080);
        builder = builder.put((Object)"Icy", (Object)1048);
        builder = builder.put((Object)"idiagr", (Object)912);
        builder = builder.put((Object)"idigr", (Object)970);
        builder = builder.put((Object)"Idigr", (Object)938);
        builder = builder.put((Object)"Idot", (Object)304);
        builder = builder.put((Object)"iecy", (Object)1077);
        builder = builder.put((Object)"IEcy", (Object)1045);
        builder = builder.put((Object)"iexcl", (Object)161);
        builder = builder.put((Object)"iff", (Object)8660);
        builder = builder.put((Object)"ifr", (Object)120102);
        builder = builder.put((Object)"Ifr", (Object)8465);
        builder = builder.put((Object)"igr", (Object)953);
        builder = builder.put((Object)"Igr", (Object)921);
        builder = builder.put((Object)"igrave", (Object)236);
        builder = builder.put((Object)"Igrave", (Object)204);
        builder = builder.put((Object)"ii", (Object)8520);
        builder = builder.put((Object)"iiiint", (Object)10764);
        builder = builder.put((Object)"iiint", (Object)8749);
        builder = builder.put((Object)"iinfin", (Object)10716);
        builder = builder.put((Object)"iiota", (Object)8489);
        builder = builder.put((Object)"ijlig", (Object)307);
        builder = builder.put((Object)"IJlig", (Object)306);
        builder = builder.put((Object)"Im", (Object)8465);
        builder = builder.put((Object)"imacr", (Object)299);
        builder = builder.put((Object)"Imacr", (Object)298);
        builder = builder.put((Object)"image", (Object)8465);
        builder = builder.put((Object)"ImaginaryI", (Object)8520);
        builder = builder.put((Object)"imagline", (Object)8464);
        builder = builder.put((Object)"imagpart", (Object)8465);
        builder = builder.put((Object)"imath", (Object)305);
        builder = builder.put((Object)"imof", (Object)8887);
        builder = builder.put((Object)"imped", (Object)437);
        builder = builder.put((Object)"Implies", (Object)8658);
        builder = builder.put((Object)"in", (Object)8712);
        builder = builder.put((Object)"incare", (Object)8453);
        builder = builder.put((Object)"infin", (Object)8734);
        builder = builder.put((Object)"infintie", (Object)10717);
        builder = builder.put((Object)"inodot", (Object)305);
        builder = builder.put((Object)"int", (Object)8747);
        builder = builder.put((Object)"Int", (Object)8748);
        builder = builder.put((Object)"intcal", (Object)8890);
        builder = builder.put((Object)"integers", (Object)8484);
        builder = builder.put((Object)"Integral", (Object)8747);
        builder = builder.put((Object)"intercal", (Object)8890);
        builder = builder.put((Object)"Intersection", (Object)8898);
        builder = builder.put((Object)"intlarhk", (Object)10775);
        builder = builder.put((Object)"intprod", (Object)10812);
        builder = builder.put((Object)"InvisibleComma", (Object)8291);
        builder = builder.put((Object)"InvisibleTimes", (Object)8290);
        builder = builder.put((Object)"iocy", (Object)1105);
        builder = builder.put((Object)"IOcy", (Object)1025);
        builder = builder.put((Object)"iogon", (Object)303);
        builder = builder.put((Object)"Iogon", (Object)302);
        builder = builder.put((Object)"iopf", (Object)120154);
        builder = builder.put((Object)"Iopf", (Object)120128);
        builder = builder.put((Object)"iota", (Object)953);
        builder = builder.put((Object)"Iota", (Object)921);
        builder = builder.put((Object)"iprod", (Object)10812);
        builder = builder.put((Object)"iquest", (Object)191);
        builder = builder.put((Object)"iscr", (Object)119998);
        builder = builder.put((Object)"Iscr", (Object)8464);
        builder = builder.put((Object)"isin", (Object)8712);
        builder = builder.put((Object)"isindot", (Object)8949);
        builder = builder.put((Object)"isinE", (Object)8953);
        builder = builder.put((Object)"isins", (Object)8948);
        builder = builder.put((Object)"isinsv", (Object)8947);
        builder = builder.put((Object)"isinv", (Object)8712);
        builder = builder.put((Object)"it", (Object)8290);
        builder = builder.put((Object)"itilde", (Object)297);
        builder = builder.put((Object)"Itilde", (Object)296);
        builder = builder.put((Object)"iukcy", (Object)1110);
        builder = builder.put((Object)"Iukcy", (Object)1030);
        builder = builder.put((Object)"iuml", (Object)239);
        builder = builder.put((Object)"Iuml", (Object)207);
        builder = builder.put((Object)"jcirc", (Object)309);
        builder = builder.put((Object)"Jcirc", (Object)308);
        builder = builder.put((Object)"jcy", (Object)1081);
        builder = builder.put((Object)"Jcy", (Object)1049);
        builder = builder.put((Object)"jfr", (Object)120103);
        builder = builder.put((Object)"Jfr", (Object)120077);
        builder = builder.put((Object)"jmath", (Object)567);
        builder = builder.put((Object)"jopf", (Object)120155);
        builder = builder.put((Object)"Jopf", (Object)120129);
        builder = builder.put((Object)"jscr", (Object)119999);
        builder = builder.put((Object)"Jscr", (Object)119973);
        builder = builder.put((Object)"jsercy", (Object)1112);
        builder = builder.put((Object)"Jsercy", (Object)1032);
        builder = builder.put((Object)"jukcy", (Object)1108);
        builder = builder.put((Object)"Jukcy", (Object)1028);
        builder = builder.put((Object)"kappa", (Object)954);
        builder = builder.put((Object)"Kappa", (Object)922);
        builder = builder.put((Object)"kappav", (Object)1008);
        builder = builder.put((Object)"kcedil", (Object)311);
        builder = builder.put((Object)"Kcedil", (Object)310);
        builder = builder.put((Object)"kcy", (Object)1082);
        builder = builder.put((Object)"Kcy", (Object)1050);
        builder = builder.put((Object)"kfr", (Object)120104);
        builder = builder.put((Object)"Kfr", (Object)120078);
        builder = builder.put((Object)"kgr", (Object)954);
        builder = builder.put((Object)"Kgr", (Object)922);
        builder = builder.put((Object)"kgreen", (Object)312);
        builder = builder.put((Object)"khcy", (Object)1093);
        builder = builder.put((Object)"KHcy", (Object)1061);
        builder = builder.put((Object)"khgr", (Object)967);
        builder = builder.put((Object)"KHgr", (Object)935);
        builder = builder.put((Object)"kjcy", (Object)1116);
        builder = builder.put((Object)"KJcy", (Object)1036);
        builder = builder.put((Object)"kopf", (Object)120156);
        builder = builder.put((Object)"Kopf", (Object)120130);
        builder = builder.put((Object)"kscr", (Object)120000);
        builder = builder.put((Object)"Kscr", (Object)119974);
        builder = builder.put((Object)"lAarr", (Object)8666);
        builder = builder.put((Object)"lacute", (Object)314);
        builder = builder.put((Object)"Lacute", (Object)313);
        builder = builder.put((Object)"laemptyv", (Object)10676);
        builder = builder.put((Object)"lagran", (Object)8466);
        builder = builder.put((Object)"lambda", (Object)955);
        builder = builder.put((Object)"Lambda", (Object)923);
        builder = builder.put((Object)"lang", (Object)10216);
        builder = builder.put((Object)"Lang", (Object)10218);
        builder = builder.put((Object)"langd", (Object)10641);
        builder = builder.put((Object)"langle", (Object)10216);
        builder = builder.put((Object)"lap", (Object)10885);
        builder = builder.put((Object)"Laplacetrf", (Object)8466);
        builder = builder.put((Object)"laquo", (Object)171);
        builder = builder.put((Object)"larr", (Object)8592);
        builder = builder.put((Object)"lArr", (Object)8656);
        builder = builder.put((Object)"Larr", (Object)8606);
        builder = builder.put((Object)"larrb", (Object)8676);
        builder = builder.put((Object)"larrbfs", (Object)10527);
        builder = builder.put((Object)"larrfs", (Object)10525);
        builder = builder.put((Object)"larrhk", (Object)8617);
        builder = builder.put((Object)"larrlp", (Object)8619);
        builder = builder.put((Object)"larrpl", (Object)10553);
        builder = builder.put((Object)"larrsim", (Object)10611);
        builder = builder.put((Object)"larrtl", (Object)8610);
        builder = builder.put((Object)"lat", (Object)10923);
        builder = builder.put((Object)"latail", (Object)10521);
        builder = builder.put((Object)"lAtail", (Object)10523);
        builder = builder.put((Object)"late", (Object)10925);
        builder = builder.put((Object)"lbarr", (Object)10508);
        builder = builder.put((Object)"lBarr", (Object)10510);
        builder = builder.put((Object)"lbbrk", (Object)10098);
        builder = builder.put((Object)"lbrace", (Object)123);
        builder = builder.put((Object)"lbrack", (Object)91);
        builder = builder.put((Object)"lbrke", (Object)10635);
        builder = builder.put((Object)"lbrksld", (Object)10639);
        builder = builder.put((Object)"lbrkslu", (Object)10637);
        builder = builder.put((Object)"lcaron", (Object)318);
        builder = builder.put((Object)"Lcaron", (Object)317);
        builder = builder.put((Object)"lcedil", (Object)316);
        builder = builder.put((Object)"Lcedil", (Object)315);
        builder = builder.put((Object)"lceil", (Object)8968);
        builder = builder.put((Object)"lcub", (Object)123);
        builder = builder.put((Object)"lcy", (Object)1083);
        builder = builder.put((Object)"Lcy", (Object)1051);
        builder = builder.put((Object)"ldca", (Object)10550);
        builder = builder.put((Object)"ldquo", (Object)8220);
        builder = builder.put((Object)"ldquor", (Object)8222);
        builder = builder.put((Object)"ldrdhar", (Object)10599);
        builder = builder.put((Object)"ldrushar", (Object)10571);
        builder = builder.put((Object)"ldsh", (Object)8626);
        builder = builder.put((Object)"le", (Object)8804);
        builder = builder.put((Object)"lE", (Object)8806);
        builder = builder.put((Object)"LeftAngleBracket", (Object)10216);
        builder = builder.put((Object)"leftarrow", (Object)8592);
        builder = builder.put((Object)"Leftarrow", (Object)8656);
        builder = builder.put((Object)"LeftArrow", (Object)8592);
        builder = builder.put((Object)"LeftArrowBar", (Object)8676);
        builder = builder.put((Object)"LeftArrowRightArrow", (Object)8646);
        builder = builder.put((Object)"leftarrowtail", (Object)8610);
        builder = builder.put((Object)"LeftCeiling", (Object)8968);
        builder = builder.put((Object)"LeftDoubleBracket", (Object)10214);
        builder = builder.put((Object)"LeftDownTeeVector", (Object)10593);
        builder = builder.put((Object)"LeftDownVector", (Object)8643);
        builder = builder.put((Object)"LeftDownVectorBar", (Object)10585);
        builder = builder.put((Object)"LeftFloor", (Object)8970);
        builder = builder.put((Object)"leftharpoondown", (Object)8637);
        builder = builder.put((Object)"leftharpoonup", (Object)8636);
        builder = builder.put((Object)"leftleftarrows", (Object)8647);
        builder = builder.put((Object)"leftrightarrow", (Object)8596);
        builder = builder.put((Object)"Leftrightarrow", (Object)8660);
        builder = builder.put((Object)"LeftRightArrow", (Object)8596);
        builder = builder.put((Object)"leftrightarrows", (Object)8646);
        builder = builder.put((Object)"leftrightharpoons", (Object)8651);
        builder = builder.put((Object)"leftrightsquigarrow", (Object)8621);
        builder = builder.put((Object)"LeftRightVector", (Object)10574);
        builder = builder.put((Object)"LeftTee", (Object)8867);
        builder = builder.put((Object)"LeftTeeArrow", (Object)8612);
        builder = builder.put((Object)"LeftTeeVector", (Object)10586);
        builder = builder.put((Object)"leftthreetimes", (Object)8907);
        builder = builder.put((Object)"LeftTriangle", (Object)8882);
        builder = builder.put((Object)"LeftTriangleBar", (Object)10703);
        builder = builder.put((Object)"LeftTriangleEqual", (Object)8884);
        builder = builder.put((Object)"LeftUpDownVector", (Object)10577);
        builder = builder.put((Object)"LeftUpTeeVector", (Object)10592);
        builder = builder.put((Object)"LeftUpVector", (Object)8639);
        builder = builder.put((Object)"LeftUpVectorBar", (Object)10584);
        builder = builder.put((Object)"LeftVector", (Object)8636);
        builder = builder.put((Object)"LeftVectorBar", (Object)10578);
        builder = builder.put((Object)"leg", (Object)8922);
        builder = builder.put((Object)"lEg", (Object)10891);
        builder = builder.put((Object)"leq", (Object)8804);
        builder = builder.put((Object)"leqq", (Object)8806);
        builder = builder.put((Object)"leqslant", (Object)10877);
        builder = builder.put((Object)"les", (Object)10877);
        builder = builder.put((Object)"lescc", (Object)10920);
        builder = builder.put((Object)"lesdot", (Object)10879);
        builder = builder.put((Object)"lesdoto", (Object)10881);
        builder = builder.put((Object)"lesdotor", (Object)10883);
        builder = builder.put((Object)"lesges", (Object)10899);
        builder = builder.put((Object)"lessapprox", (Object)10885);
        builder = builder.put((Object)"lessdot", (Object)8918);
        builder = builder.put((Object)"lesseqgtr", (Object)8922);
        builder = builder.put((Object)"lesseqqgtr", (Object)10891);
        builder = builder.put((Object)"LessEqualGreater", (Object)8922);
        builder = builder.put((Object)"LessFullEqual", (Object)8806);
        builder = builder.put((Object)"LessGreater", (Object)8822);
        builder = builder.put((Object)"lessgtr", (Object)8822);
        builder = builder.put((Object)"LessLess", (Object)10913);
        builder = builder.put((Object)"lesssim", (Object)8818);
        builder = builder.put((Object)"LessSlantEqual", (Object)10877);
        builder = builder.put((Object)"LessTilde", (Object)8818);
        builder = builder.put((Object)"lfisht", (Object)10620);
        builder = builder.put((Object)"lfloor", (Object)8970);
        builder = builder.put((Object)"lfr", (Object)120105);
        builder = builder.put((Object)"Lfr", (Object)120079);
        builder = builder.put((Object)"lg", (Object)8822);
        builder = builder.put((Object)"lgE", (Object)10897);
        builder = builder.put((Object)"lgr", (Object)955);
        builder = builder.put((Object)"Lgr", (Object)923);
        builder = builder.put((Object)"lHar", (Object)10594);
        builder = builder.put((Object)"lhard", (Object)8637);
        builder = builder.put((Object)"lharu", (Object)8636);
        builder = builder.put((Object)"lharul", (Object)10602);
        builder = builder.put((Object)"lhblk", (Object)9604);
        builder = builder.put((Object)"ljcy", (Object)1113);
        builder = builder.put((Object)"LJcy", (Object)1033);
        builder = builder.put((Object)"ll", (Object)8810);
        builder = builder.put((Object)"Ll", (Object)8920);
        builder = builder.put((Object)"llarr", (Object)8647);
        builder = builder.put((Object)"llcorner", (Object)8990);
        builder = builder.put((Object)"Lleftarrow", (Object)8666);
        builder = builder.put((Object)"llhard", (Object)10603);
        builder = builder.put((Object)"lltri", (Object)9722);
        builder = builder.put((Object)"lmidot", (Object)320);
        builder = builder.put((Object)"Lmidot", (Object)319);
        builder = builder.put((Object)"lmoust", (Object)9136);
        builder = builder.put((Object)"lmoustache", (Object)9136);
        builder = builder.put((Object)"lnap", (Object)10889);
        builder = builder.put((Object)"lnapprox", (Object)10889);
        builder = builder.put((Object)"lne", (Object)10887);
        builder = builder.put((Object)"lnE", (Object)8808);
        builder = builder.put((Object)"lneq", (Object)10887);
        builder = builder.put((Object)"lneqq", (Object)8808);
        builder = builder.put((Object)"lnsim", (Object)8934);
        builder = builder.put((Object)"loang", (Object)10220);
        builder = builder.put((Object)"loarr", (Object)8701);
        builder = builder.put((Object)"lobrk", (Object)10214);
        builder = builder.put((Object)"longleftarrow", (Object)10229);
        builder = builder.put((Object)"Longleftarrow", (Object)10232);
        builder = builder.put((Object)"LongLeftArrow", (Object)10229);
        builder = builder.put((Object)"longleftrightarrow", (Object)10231);
        builder = builder.put((Object)"Longleftrightarrow", (Object)10234);
        builder = builder.put((Object)"LongLeftRightArrow", (Object)10231);
        builder = builder.put((Object)"longmapsto", (Object)10236);
        builder = builder.put((Object)"longrightarrow", (Object)10230);
        builder = builder.put((Object)"Longrightarrow", (Object)10233);
        builder = builder.put((Object)"LongRightArrow", (Object)10230);
        builder = builder.put((Object)"looparrowleft", (Object)8619);
        builder = builder.put((Object)"looparrowright", (Object)8620);
        builder = builder.put((Object)"lopar", (Object)10629);
        builder = builder.put((Object)"lopf", (Object)120157);
        builder = builder.put((Object)"Lopf", (Object)120131);
        builder = builder.put((Object)"loplus", (Object)10797);
        builder = builder.put((Object)"lotimes", (Object)10804);
        builder = builder.put((Object)"lowast", (Object)8727);
        builder = builder.put((Object)"lowbar", (Object)95);
        builder = builder.put((Object)"LowerLeftArrow", (Object)8601);
        builder = builder.put((Object)"LowerRightArrow", (Object)8600);
        builder = builder.put((Object)"loz", (Object)9674);
        builder = builder.put((Object)"lozenge", (Object)9674);
        builder = builder.put((Object)"lozf", (Object)10731);
        builder = builder.put((Object)"lpar", (Object)40);
        builder = builder.put((Object)"lparlt", (Object)10643);
        builder = builder.put((Object)"lrarr", (Object)8646);
        builder = builder.put((Object)"lrcorner", (Object)8991);
        builder = builder.put((Object)"lrhar", (Object)8651);
        builder = builder.put((Object)"lrhard", (Object)10605);
        builder = builder.put((Object)"lrm", (Object)8206);
        builder = builder.put((Object)"lrtri", (Object)8895);
        builder = builder.put((Object)"lsaquo", (Object)8249);
        builder = builder.put((Object)"lscr", (Object)120001);
        builder = builder.put((Object)"Lscr", (Object)8466);
        builder = builder.put((Object)"lsh", (Object)8624);
        builder = builder.put((Object)"Lsh", (Object)8624);
        builder = builder.put((Object)"lsim", (Object)8818);
        builder = builder.put((Object)"lsime", (Object)10893);
        builder = builder.put((Object)"lsimg", (Object)10895);
        builder = builder.put((Object)"lsqb", (Object)91);
        builder = builder.put((Object)"lsquo", (Object)8216);
        builder = builder.put((Object)"lsquor", (Object)8218);
        builder = builder.put((Object)"lstrok", (Object)322);
        builder = builder.put((Object)"Lstrok", (Object)321);
        builder = builder.put((Object)"lt", (Object)60);
        builder = builder.put((Object)"Lt", (Object)8810);
        builder = builder.put((Object)"LT", (Object)60);
        builder = builder.put((Object)"ltcc", (Object)10918);
        builder = builder.put((Object)"ltcir", (Object)10873);
        builder = builder.put((Object)"ltdot", (Object)8918);
        builder = builder.put((Object)"lthree", (Object)8907);
        builder = builder.put((Object)"ltimes", (Object)8905);
        builder = builder.put((Object)"ltlarr", (Object)10614);
        builder = builder.put((Object)"ltquest", (Object)10875);
        builder = builder.put((Object)"ltri", (Object)9667);
        builder = builder.put((Object)"ltrie", (Object)8884);
        builder = builder.put((Object)"ltrif", (Object)9666);
        builder = builder.put((Object)"ltrPar", (Object)10646);
        builder = builder.put((Object)"lurdshar", (Object)10570);
        builder = builder.put((Object)"luruhar", (Object)10598);
        builder = builder.put((Object)"macr", (Object)175);
        builder = builder.put((Object)"male", (Object)9794);
        builder = builder.put((Object)"malt", (Object)10016);
        builder = builder.put((Object)"maltese", (Object)10016);
        builder = builder.put((Object)"map", (Object)8614);
        builder = builder.put((Object)"Map", (Object)10501);
        builder = builder.put((Object)"mapsto", (Object)8614);
        builder = builder.put((Object)"mapstodown", (Object)8615);
        builder = builder.put((Object)"mapstoleft", (Object)8612);
        builder = builder.put((Object)"mapstoup", (Object)8613);
        builder = builder.put((Object)"marker", (Object)9646);
        builder = builder.put((Object)"mcomma", (Object)10793);
        builder = builder.put((Object)"mcy", (Object)1084);
        builder = builder.put((Object)"Mcy", (Object)1052);
        builder = builder.put((Object)"mdash", (Object)8212);
        builder = builder.put((Object)"mDDot", (Object)8762);
        builder = builder.put((Object)"measuredangle", (Object)8737);
        builder = builder.put((Object)"MediumSpace", (Object)8287);
        builder = builder.put((Object)"Mellintrf", (Object)8499);
        builder = builder.put((Object)"mfr", (Object)120106);
        builder = builder.put((Object)"Mfr", (Object)120080);
        builder = builder.put((Object)"mgr", (Object)956);
        builder = builder.put((Object)"Mgr", (Object)924);
        builder = builder.put((Object)"mho", (Object)8487);
        builder = builder.put((Object)"micro", (Object)181);
        builder = builder.put((Object)"mid", (Object)8739);
        builder = builder.put((Object)"midast", (Object)42);
        builder = builder.put((Object)"midcir", (Object)10992);
        builder = builder.put((Object)"middot", (Object)183);
        builder = builder.put((Object)"minus", (Object)8722);
        builder = builder.put((Object)"minusb", (Object)8863);
        builder = builder.put((Object)"minusd", (Object)8760);
        builder = builder.put((Object)"minusdu", (Object)10794);
        builder = builder.put((Object)"MinusPlus", (Object)8723);
        builder = builder.put((Object)"mlcp", (Object)10971);
        builder = builder.put((Object)"mldr", (Object)8230);
        builder = builder.put((Object)"mnplus", (Object)8723);
        builder = builder.put((Object)"models", (Object)8871);
        builder = builder.put((Object)"mopf", (Object)120158);
        builder = builder.put((Object)"Mopf", (Object)120132);
        builder = builder.put((Object)"mp", (Object)8723);
        builder = builder.put((Object)"mscr", (Object)120002);
        builder = builder.put((Object)"Mscr", (Object)8499);
        builder = builder.put((Object)"mstpos", (Object)8766);
        builder = builder.put((Object)"mu", (Object)956);
        builder = builder.put((Object)"Mu", (Object)924);
        builder = builder.put((Object)"multimap", (Object)8888);
        builder = builder.put((Object)"mumap", (Object)8888);
        builder = builder.put((Object)"nabla", (Object)8711);
        builder = builder.put((Object)"nacute", (Object)324);
        builder = builder.put((Object)"Nacute", (Object)323);
        builder = builder.put((Object)"nap", (Object)8777);
        builder = builder.put((Object)"napos", (Object)329);
        builder = builder.put((Object)"napprox", (Object)8777);
        builder = builder.put((Object)"natur", (Object)9838);
        builder = builder.put((Object)"natural", (Object)9838);
        builder = builder.put((Object)"naturals", (Object)8469);
        builder = builder.put((Object)"nbsp", (Object)160);
        builder = builder.put((Object)"ncap", (Object)10819);
        builder = builder.put((Object)"ncaron", (Object)328);
        builder = builder.put((Object)"Ncaron", (Object)327);
        builder = builder.put((Object)"ncedil", (Object)326);
        builder = builder.put((Object)"Ncedil", (Object)325);
        builder = builder.put((Object)"ncong", (Object)8775);
        builder = builder.put((Object)"ncup", (Object)10818);
        builder = builder.put((Object)"ncy", (Object)1085);
        builder = builder.put((Object)"Ncy", (Object)1053);
        builder = builder.put((Object)"ndash", (Object)8211);
        builder = builder.put((Object)"ne", (Object)8800);
        builder = builder.put((Object)"nearhk", (Object)10532);
        builder = builder.put((Object)"nearr", (Object)8599);
        builder = builder.put((Object)"neArr", (Object)8663);
        builder = builder.put((Object)"nearrow", (Object)8599);
        builder = builder.put((Object)"NegativeMediumSpace", (Object)8203);
        builder = builder.put((Object)"NegativeThickSpace", (Object)8203);
        builder = builder.put((Object)"NegativeThinSpace", (Object)8203);
        builder = builder.put((Object)"NegativeVeryThinSpace", (Object)8203);
        builder = builder.put((Object)"nequiv", (Object)8802);
        builder = builder.put((Object)"nesear", (Object)10536);
        builder = builder.put((Object)"NestedGreaterGreater", (Object)8811);
        builder = builder.put((Object)"NestedLessLess", (Object)8810);
        builder = builder.put((Object)"NewLine", (Object)10);
        builder = builder.put((Object)"nexist", (Object)8708);
        builder = builder.put((Object)"nexists", (Object)8708);
        builder = builder.put((Object)"nfr", (Object)120107);
        builder = builder.put((Object)"Nfr", (Object)120081);
        builder = builder.put((Object)"nge", (Object)8817);
        builder = builder.put((Object)"ngeq", (Object)8817);
        builder = builder.put((Object)"ngr", (Object)957);
        builder = builder.put((Object)"Ngr", (Object)925);
        builder = builder.put((Object)"ngsim", (Object)8821);
        builder = builder.put((Object)"ngt", (Object)8815);
        builder = builder.put((Object)"ngtr", (Object)8815);
        builder = builder.put((Object)"nharr", (Object)8622);
        builder = builder.put((Object)"nhArr", (Object)8654);
        builder = builder.put((Object)"nhpar", (Object)10994);
        builder = builder.put((Object)"ni", (Object)8715);
        builder = builder.put((Object)"nis", (Object)8956);
        builder = builder.put((Object)"nisd", (Object)8954);
        builder = builder.put((Object)"niv", (Object)8715);
        builder = builder.put((Object)"njcy", (Object)1114);
        builder = builder.put((Object)"NJcy", (Object)1034);
        builder = builder.put((Object)"nlarr", (Object)8602);
        builder = builder.put((Object)"nlArr", (Object)8653);
        builder = builder.put((Object)"nldr", (Object)8229);
        builder = builder.put((Object)"nle", (Object)8816);
        builder = builder.put((Object)"nleftarrow", (Object)8602);
        builder = builder.put((Object)"nLeftarrow", (Object)8653);
        builder = builder.put((Object)"nleftrightarrow", (Object)8622);
        builder = builder.put((Object)"nLeftrightarrow", (Object)8654);
        builder = builder.put((Object)"nleq", (Object)8816);
        builder = builder.put((Object)"nless", (Object)8814);
        builder = builder.put((Object)"nlsim", (Object)8820);
        builder = builder.put((Object)"nlt", (Object)8814);
        builder = builder.put((Object)"nltri", (Object)8938);
        builder = builder.put((Object)"nltrie", (Object)8940);
        builder = builder.put((Object)"nmid", (Object)8740);
        builder = builder.put((Object)"NoBreak", (Object)8288);
        builder = builder.put((Object)"NonBreakingSpace", (Object)160);
        builder = builder.put((Object)"nopf", (Object)120159);
        builder = builder.put((Object)"Nopf", (Object)8469);
        builder = builder.put((Object)"not", (Object)172);
        builder = builder.put((Object)"Not", (Object)10988);
        builder = builder.put((Object)"NotCongruent", (Object)8802);
        builder = builder.put((Object)"NotCupCap", (Object)8813);
        builder = builder.put((Object)"NotDoubleVerticalBar", (Object)8742);
        builder = builder.put((Object)"NotElement", (Object)8713);
        builder = builder.put((Object)"NotEqual", (Object)8800);
        builder = builder.put((Object)"NotExists", (Object)8708);
        builder = builder.put((Object)"NotGreater", (Object)8815);
        builder = builder.put((Object)"NotGreaterEqual", (Object)8817);
        builder = builder.put((Object)"NotGreaterLess", (Object)8825);
        builder = builder.put((Object)"NotGreaterTilde", (Object)8821);
        builder = builder.put((Object)"notin", (Object)8713);
        builder = builder.put((Object)"notinva", (Object)8713);
        builder = builder.put((Object)"notinvb", (Object)8951);
        builder = builder.put((Object)"notinvc", (Object)8950);
        builder = builder.put((Object)"NotLeftTriangle", (Object)8938);
        builder = builder.put((Object)"NotLeftTriangleEqual", (Object)8940);
        builder = builder.put((Object)"NotLess", (Object)8814);
        builder = builder.put((Object)"NotLessEqual", (Object)8816);
        builder = builder.put((Object)"NotLessGreater", (Object)8824);
        builder = builder.put((Object)"NotLessTilde", (Object)8820);
        builder = builder.put((Object)"notni", (Object)8716);
        builder = builder.put((Object)"notniva", (Object)8716);
        builder = builder.put((Object)"notnivb", (Object)8958);
        builder = builder.put((Object)"notnivc", (Object)8957);
        builder = builder.put((Object)"NotPrecedes", (Object)8832);
        builder = builder.put((Object)"NotPrecedesSlantEqual", (Object)8928);
        builder = builder.put((Object)"NotReverseElement", (Object)8716);
        builder = builder.put((Object)"NotRightTriangle", (Object)8939);
        builder = builder.put((Object)"NotRightTriangleEqual", (Object)8941);
        builder = builder.put((Object)"NotSquareSubsetEqual", (Object)8930);
        builder = builder.put((Object)"NotSquareSupersetEqual", (Object)8931);
        builder = builder.put((Object)"NotSubsetEqual", (Object)8840);
        builder = builder.put((Object)"NotSucceeds", (Object)8833);
        builder = builder.put((Object)"NotSucceedsSlantEqual", (Object)8929);
        builder = builder.put((Object)"NotSupersetEqual", (Object)8841);
        builder = builder.put((Object)"NotTilde", (Object)8769);
        builder = builder.put((Object)"NotTildeEqual", (Object)8772);
        builder = builder.put((Object)"NotTildeFullEqual", (Object)8775);
        builder = builder.put((Object)"NotTildeTilde", (Object)8777);
        builder = builder.put((Object)"NotVerticalBar", (Object)8740);
        builder = builder.put((Object)"npar", (Object)8742);
        builder = builder.put((Object)"nparallel", (Object)8742);
        builder = builder.put((Object)"npolint", (Object)10772);
        builder = builder.put((Object)"npr", (Object)8832);
        builder = builder.put((Object)"nprcue", (Object)8928);
        builder = builder.put((Object)"nprec", (Object)8832);
        builder = builder.put((Object)"nrarr", (Object)8603);
        builder = builder.put((Object)"nrArr", (Object)8655);
        builder = builder.put((Object)"nrightarrow", (Object)8603);
        builder = builder.put((Object)"nRightarrow", (Object)8655);
        builder = builder.put((Object)"nrtri", (Object)8939);
        builder = builder.put((Object)"nrtrie", (Object)8941);
        builder = builder.put((Object)"nsc", (Object)8833);
        builder = builder.put((Object)"nsccue", (Object)8929);
        builder = builder.put((Object)"nscr", (Object)120003);
        builder = builder.put((Object)"Nscr", (Object)119977);
        builder = builder.put((Object)"nshortmid", (Object)8740);
        builder = builder.put((Object)"nshortparallel", (Object)8742);
        builder = builder.put((Object)"nsim", (Object)8769);
        builder = builder.put((Object)"nsime", (Object)8772);
        builder = builder.put((Object)"nsimeq", (Object)8772);
        builder = builder.put((Object)"nsmid", (Object)8740);
        builder = builder.put((Object)"nspar", (Object)8742);
        builder = builder.put((Object)"nsqsube", (Object)8930);
        builder = builder.put((Object)"nsqsupe", (Object)8931);
        builder = builder.put((Object)"nsub", (Object)8836);
        builder = builder.put((Object)"nsube", (Object)8840);
        builder = builder.put((Object)"nsubseteq", (Object)8840);
        builder = builder.put((Object)"nsucc", (Object)8833);
        builder = builder.put((Object)"nsup", (Object)8837);
        builder = builder.put((Object)"nsupe", (Object)8841);
        builder = builder.put((Object)"nsupseteq", (Object)8841);
        builder = builder.put((Object)"ntgl", (Object)8825);
        builder = builder.put((Object)"ntilde", (Object)241);
        builder = builder.put((Object)"Ntilde", (Object)209);
        builder = builder.put((Object)"ntlg", (Object)8824);
        builder = builder.put((Object)"ntriangleleft", (Object)8938);
        builder = builder.put((Object)"ntrianglelefteq", (Object)8940);
        builder = builder.put((Object)"ntriangleright", (Object)8939);
        builder = builder.put((Object)"ntrianglerighteq", (Object)8941);
        builder = builder.put((Object)"nu", (Object)957);
        builder = builder.put((Object)"Nu", (Object)925);
        builder = builder.put((Object)"num", (Object)35);
        builder = builder.put((Object)"numero", (Object)8470);
        builder = builder.put((Object)"numsp", (Object)8199);
        builder = builder.put((Object)"nvdash", (Object)8876);
        builder = builder.put((Object)"nvDash", (Object)8877);
        builder = builder.put((Object)"nVdash", (Object)8878);
        builder = builder.put((Object)"nVDash", (Object)8879);
        builder = builder.put((Object)"nvHarr", (Object)10500);
        builder = builder.put((Object)"nvinfin", (Object)10718);
        builder = builder.put((Object)"nvlArr", (Object)10498);
        builder = builder.put((Object)"nvrArr", (Object)10499);
        builder = builder.put((Object)"nwarhk", (Object)10531);
        builder = builder.put((Object)"nwarr", (Object)8598);
        builder = builder.put((Object)"nwArr", (Object)8662);
        builder = builder.put((Object)"nwarrow", (Object)8598);
        builder = builder.put((Object)"nwnear", (Object)10535);
        builder = builder.put((Object)"oacgr", (Object)972);
        builder = builder.put((Object)"Oacgr", (Object)908);
        builder = builder.put((Object)"oacute", (Object)243);
        builder = builder.put((Object)"Oacute", (Object)211);
        builder = builder.put((Object)"oast", (Object)8859);
        builder = builder.put((Object)"ocir", (Object)8858);
        builder = builder.put((Object)"ocirc", (Object)244);
        builder = builder.put((Object)"Ocirc", (Object)212);
        builder = builder.put((Object)"ocy", (Object)1086);
        builder = builder.put((Object)"Ocy", (Object)1054);
        builder = builder.put((Object)"odash", (Object)8861);
        builder = builder.put((Object)"odblac", (Object)337);
        builder = builder.put((Object)"Odblac", (Object)336);
        builder = builder.put((Object)"odiv", (Object)10808);
        builder = builder.put((Object)"odot", (Object)8857);
        builder = builder.put((Object)"odsold", (Object)10684);
        builder = builder.put((Object)"oelig", (Object)339);
        builder = builder.put((Object)"OElig", (Object)338);
        builder = builder.put((Object)"ofcir", (Object)10687);
        builder = builder.put((Object)"ofr", (Object)120108);
        builder = builder.put((Object)"Ofr", (Object)120082);
        builder = builder.put((Object)"ogon", (Object)731);
        builder = builder.put((Object)"ogr", (Object)959);
        builder = builder.put((Object)"Ogr", (Object)927);
        builder = builder.put((Object)"ograve", (Object)242);
        builder = builder.put((Object)"Ograve", (Object)210);
        builder = builder.put((Object)"ogt", (Object)10689);
        builder = builder.put((Object)"ohacgr", (Object)974);
        builder = builder.put((Object)"OHacgr", (Object)911);
        builder = builder.put((Object)"ohbar", (Object)10677);
        builder = builder.put((Object)"ohgr", (Object)969);
        builder = builder.put((Object)"OHgr", (Object)937);
        builder = builder.put((Object)"ohm", (Object)937);
        builder = builder.put((Object)"oint", (Object)8750);
        builder = builder.put((Object)"olarr", (Object)8634);
        builder = builder.put((Object)"olcir", (Object)10686);
        builder = builder.put((Object)"olcross", (Object)10683);
        builder = builder.put((Object)"oline", (Object)8254);
        builder = builder.put((Object)"olt", (Object)10688);
        builder = builder.put((Object)"omacr", (Object)333);
        builder = builder.put((Object)"Omacr", (Object)332);
        builder = builder.put((Object)"omega", (Object)969);
        builder = builder.put((Object)"Omega", (Object)937);
        builder = builder.put((Object)"omicron", (Object)959);
        builder = builder.put((Object)"Omicron", (Object)927);
        builder = builder.put((Object)"omid", (Object)10678);
        builder = builder.put((Object)"ominus", (Object)8854);
        builder = builder.put((Object)"oopf", (Object)120160);
        builder = builder.put((Object)"Oopf", (Object)120134);
        builder = builder.put((Object)"opar", (Object)10679);
        builder = builder.put((Object)"OpenCurlyDoubleQuote", (Object)8220);
        builder = builder.put((Object)"OpenCurlyQuote", (Object)8216);
        builder = builder.put((Object)"operp", (Object)10681);
        builder = builder.put((Object)"oplus", (Object)8853);
        builder = builder.put((Object)"or", (Object)8744);
        builder = builder.put((Object)"Or", (Object)10836);
        builder = builder.put((Object)"orarr", (Object)8635);
        builder = builder.put((Object)"ord", (Object)10845);
        builder = builder.put((Object)"order", (Object)8500);
        builder = builder.put((Object)"orderof", (Object)8500);
        builder = builder.put((Object)"ordf", (Object)170);
        builder = builder.put((Object)"ordm", (Object)186);
        builder = builder.put((Object)"origof", (Object)8886);
        builder = builder.put((Object)"oror", (Object)10838);
        builder = builder.put((Object)"orslope", (Object)10839);
        builder = builder.put((Object)"orv", (Object)10843);
        builder = builder.put((Object)"oS", (Object)9416);
        builder = builder.put((Object)"oscr", (Object)8500);
        builder = builder.put((Object)"Oscr", (Object)119978);
        builder = builder.put((Object)"oslash", (Object)248);
        builder = builder.put((Object)"Oslash", (Object)216);
        builder = builder.put((Object)"osol", (Object)8856);
        builder = builder.put((Object)"otilde", (Object)245);
        builder = builder.put((Object)"Otilde", (Object)213);
        builder = builder.put((Object)"otimes", (Object)8855);
        builder = builder.put((Object)"Otimes", (Object)10807);
        builder = builder.put((Object)"otimesas", (Object)10806);
        builder = builder.put((Object)"ouml", (Object)246);
        builder = builder.put((Object)"Ouml", (Object)214);
        builder = builder.put((Object)"ovbar", (Object)9021);
        builder = builder.put((Object)"OverBar", (Object)8254);
        builder = builder.put((Object)"OverBrace", (Object)9182);
        builder = builder.put((Object)"OverBracket", (Object)9140);
        builder = builder.put((Object)"OverParenthesis", (Object)9180);
        builder = builder.put((Object)"par", (Object)8741);
        builder = builder.put((Object)"para", (Object)182);
        builder = builder.put((Object)"parallel", (Object)8741);
        builder = builder.put((Object)"parsim", (Object)10995);
        builder = builder.put((Object)"parsl", (Object)11005);
        builder = builder.put((Object)"part", (Object)8706);
        builder = builder.put((Object)"PartialD", (Object)8706);
        builder = builder.put((Object)"pcy", (Object)1087);
        builder = builder.put((Object)"Pcy", (Object)1055);
        builder = builder.put((Object)"percnt", (Object)37);
        builder = builder.put((Object)"period", (Object)46);
        builder = builder.put((Object)"permil", (Object)8240);
        builder = builder.put((Object)"perp", (Object)8869);
        builder = builder.put((Object)"pertenk", (Object)8241);
        builder = builder.put((Object)"pfr", (Object)120109);
        builder = builder.put((Object)"Pfr", (Object)120083);
        builder = builder.put((Object)"pgr", (Object)960);
        builder = builder.put((Object)"Pgr", (Object)928);
        builder = builder.put((Object)"phgr", (Object)966);
        builder = builder.put((Object)"PHgr", (Object)934);
        builder = builder.put((Object)"phi", (Object)966);
        builder = builder.put((Object)"Phi", (Object)934);
        builder = builder.put((Object)"phiv", (Object)981);
        builder = builder.put((Object)"phmmat", (Object)8499);
        builder = builder.put((Object)"phone", (Object)9742);
        builder = builder.put((Object)"pi", (Object)960);
        builder = builder.put((Object)"Pi", (Object)928);
        builder = builder.put((Object)"pitchfork", (Object)8916);
        builder = builder.put((Object)"piv", (Object)982);
        builder = builder.put((Object)"planck", (Object)8463);
        builder = builder.put((Object)"planckh", (Object)8462);
        builder = builder.put((Object)"plankv", (Object)8463);
        builder = builder.put((Object)"plus", (Object)43);
        builder = builder.put((Object)"plusacir", (Object)10787);
        builder = builder.put((Object)"plusb", (Object)8862);
        builder = builder.put((Object)"pluscir", (Object)10786);
        builder = builder.put((Object)"plusdo", (Object)8724);
        builder = builder.put((Object)"plusdu", (Object)10789);
        builder = builder.put((Object)"pluse", (Object)10866);
        builder = builder.put((Object)"PlusMinus", (Object)177);
        builder = builder.put((Object)"plusmn", (Object)177);
        builder = builder.put((Object)"plussim", (Object)10790);
        builder = builder.put((Object)"plustwo", (Object)10791);
        builder = builder.put((Object)"pm", (Object)177);
        builder = builder.put((Object)"Poincareplane", (Object)8460);
        builder = builder.put((Object)"pointint", (Object)10773);
        builder = builder.put((Object)"popf", (Object)120161);
        builder = builder.put((Object)"Popf", (Object)8473);
        builder = builder.put((Object)"pound", (Object)163);
        builder = builder.put((Object)"pr", (Object)8826);
        builder = builder.put((Object)"Pr", (Object)10939);
        builder = builder.put((Object)"prap", (Object)10935);
        builder = builder.put((Object)"prcue", (Object)8828);
        builder = builder.put((Object)"pre", (Object)10927);
        builder = builder.put((Object)"prE", (Object)10931);
        builder = builder.put((Object)"prec", (Object)8826);
        builder = builder.put((Object)"precapprox", (Object)10935);
        builder = builder.put((Object)"preccurlyeq", (Object)8828);
        builder = builder.put((Object)"Precedes", (Object)8826);
        builder = builder.put((Object)"PrecedesEqual", (Object)10927);
        builder = builder.put((Object)"PrecedesSlantEqual", (Object)8828);
        builder = builder.put((Object)"PrecedesTilde", (Object)8830);
        builder = builder.put((Object)"preceq", (Object)10927);
        builder = builder.put((Object)"precnapprox", (Object)10937);
        builder = builder.put((Object)"precneqq", (Object)10933);
        builder = builder.put((Object)"precnsim", (Object)8936);
        builder = builder.put((Object)"precsim", (Object)8830);
        builder = builder.put((Object)"prime", (Object)8242);
        builder = builder.put((Object)"Prime", (Object)8243);
        builder = builder.put((Object)"primes", (Object)8473);
        builder = builder.put((Object)"prnap", (Object)10937);
        builder = builder.put((Object)"prnE", (Object)10933);
        builder = builder.put((Object)"prnsim", (Object)8936);
        builder = builder.put((Object)"prod", (Object)8719);
        builder = builder.put((Object)"Product", (Object)8719);
        builder = builder.put((Object)"profalar", (Object)9006);
        builder = builder.put((Object)"profline", (Object)8978);
        builder = builder.put((Object)"profsurf", (Object)8979);
        builder = builder.put((Object)"prop", (Object)8733);
        builder = builder.put((Object)"Proportion", (Object)8759);
        builder = builder.put((Object)"Proportional", (Object)8733);
        builder = builder.put((Object)"propto", (Object)8733);
        builder = builder.put((Object)"prsim", (Object)8830);
        builder = builder.put((Object)"prurel", (Object)8880);
        builder = builder.put((Object)"pscr", (Object)120005);
        builder = builder.put((Object)"Pscr", (Object)119979);
        builder = builder.put((Object)"psgr", (Object)968);
        builder = builder.put((Object)"PSgr", (Object)936);
        builder = builder.put((Object)"psi", (Object)968);
        builder = builder.put((Object)"Psi", (Object)936);
        builder = builder.put((Object)"puncsp", (Object)8200);
        builder = builder.put((Object)"qfr", (Object)120110);
        builder = builder.put((Object)"Qfr", (Object)120084);
        builder = builder.put((Object)"qint", (Object)10764);
        builder = builder.put((Object)"qopf", (Object)120162);
        builder = builder.put((Object)"Qopf", (Object)8474);
        builder = builder.put((Object)"qprime", (Object)8279);
        builder = builder.put((Object)"qscr", (Object)120006);
        builder = builder.put((Object)"Qscr", (Object)119980);
        builder = builder.put((Object)"quaternions", (Object)8461);
        builder = builder.put((Object)"quatint", (Object)10774);
        builder = builder.put((Object)"quest", (Object)63);
        builder = builder.put((Object)"questeq", (Object)8799);
        builder = builder.put((Object)"quot", (Object)34);
        builder = builder.put((Object)"QUOT", (Object)34);
        builder = builder.put((Object)"rAarr", (Object)8667);
        builder = builder.put((Object)"racute", (Object)341);
        builder = builder.put((Object)"Racute", (Object)340);
        builder = builder.put((Object)"radic", (Object)8730);
        builder = builder.put((Object)"raemptyv", (Object)10675);
        builder = builder.put((Object)"rang", (Object)10217);
        builder = builder.put((Object)"Rang", (Object)10219);
        builder = builder.put((Object)"rangd", (Object)10642);
        builder = builder.put((Object)"range", (Object)10661);
        builder = builder.put((Object)"rangle", (Object)10217);
        builder = builder.put((Object)"raquo", (Object)187);
        builder = builder.put((Object)"rarr", (Object)8594);
        builder = builder.put((Object)"rArr", (Object)8658);
        builder = builder.put((Object)"Rarr", (Object)8608);
        builder = builder.put((Object)"rarrap", (Object)10613);
        builder = builder.put((Object)"rarrb", (Object)8677);
        builder = builder.put((Object)"rarrbfs", (Object)10528);
        builder = builder.put((Object)"rarrc", (Object)10547);
        builder = builder.put((Object)"rarrfs", (Object)10526);
        builder = builder.put((Object)"rarrhk", (Object)8618);
        builder = builder.put((Object)"rarrlp", (Object)8620);
        builder = builder.put((Object)"rarrpl", (Object)10565);
        builder = builder.put((Object)"rarrsim", (Object)10612);
        builder = builder.put((Object)"rarrtl", (Object)8611);
        builder = builder.put((Object)"Rarrtl", (Object)10518);
        builder = builder.put((Object)"rarrw", (Object)8605);
        builder = builder.put((Object)"ratail", (Object)10522);
        builder = builder.put((Object)"rAtail", (Object)10524);
        builder = builder.put((Object)"ratio", (Object)8758);
        builder = builder.put((Object)"rationals", (Object)8474);
        builder = builder.put((Object)"rbarr", (Object)10509);
        builder = builder.put((Object)"rBarr", (Object)10511);
        builder = builder.put((Object)"RBarr", (Object)10512);
        builder = builder.put((Object)"rbbrk", (Object)10099);
        builder = builder.put((Object)"rbrace", (Object)125);
        builder = builder.put((Object)"rbrack", (Object)93);
        builder = builder.put((Object)"rbrke", (Object)10636);
        builder = builder.put((Object)"rbrksld", (Object)10638);
        builder = builder.put((Object)"rbrkslu", (Object)10640);
        builder = builder.put((Object)"rcaron", (Object)345);
        builder = builder.put((Object)"Rcaron", (Object)344);
        builder = builder.put((Object)"rcedil", (Object)343);
        builder = builder.put((Object)"Rcedil", (Object)342);
        builder = builder.put((Object)"rceil", (Object)8969);
        builder = builder.put((Object)"rcub", (Object)125);
        builder = builder.put((Object)"rcy", (Object)1088);
        builder = builder.put((Object)"Rcy", (Object)1056);
        builder = builder.put((Object)"rdca", (Object)10551);
        builder = builder.put((Object)"rdldhar", (Object)10601);
        builder = builder.put((Object)"rdquo", (Object)8221);
        builder = builder.put((Object)"rdquor", (Object)8221);
        builder = builder.put((Object)"rdsh", (Object)8627);
        builder = builder.put((Object)"Re", (Object)8476);
        builder = builder.put((Object)"real", (Object)8476);
        builder = builder.put((Object)"realine", (Object)8475);
        builder = builder.put((Object)"realpart", (Object)8476);
        builder = builder.put((Object)"reals", (Object)8477);
        builder = builder.put((Object)"rect", (Object)9645);
        builder = builder.put((Object)"reg", (Object)174);
        builder = builder.put((Object)"REG", (Object)174);
        builder = builder.put((Object)"ReverseElement", (Object)8715);
        builder = builder.put((Object)"ReverseEquilibrium", (Object)8651);
        builder = builder.put((Object)"ReverseUpEquilibrium", (Object)10607);
        builder = builder.put((Object)"rfisht", (Object)10621);
        builder = builder.put((Object)"rfloor", (Object)8971);
        builder = builder.put((Object)"rfr", (Object)120111);
        builder = builder.put((Object)"Rfr", (Object)8476);
        builder = builder.put((Object)"rgr", (Object)961);
        builder = builder.put((Object)"Rgr", (Object)929);
        builder = builder.put((Object)"rHar", (Object)10596);
        builder = builder.put((Object)"rhard", (Object)8641);
        builder = builder.put((Object)"rharu", (Object)8640);
        builder = builder.put((Object)"rharul", (Object)10604);
        builder = builder.put((Object)"rho", (Object)961);
        builder = builder.put((Object)"Rho", (Object)929);
        builder = builder.put((Object)"rhov", (Object)1009);
        builder = builder.put((Object)"RightAngleBracket", (Object)10217);
        builder = builder.put((Object)"rightarrow", (Object)8594);
        builder = builder.put((Object)"Rightarrow", (Object)8658);
        builder = builder.put((Object)"RightArrow", (Object)8594);
        builder = builder.put((Object)"RightArrowBar", (Object)8677);
        builder = builder.put((Object)"RightArrowLeftArrow", (Object)8644);
        builder = builder.put((Object)"rightarrowtail", (Object)8611);
        builder = builder.put((Object)"RightCeiling", (Object)8969);
        builder = builder.put((Object)"RightDoubleBracket", (Object)10215);
        builder = builder.put((Object)"RightDownTeeVector", (Object)10589);
        builder = builder.put((Object)"RightDownVector", (Object)8642);
        builder = builder.put((Object)"RightDownVectorBar", (Object)10581);
        builder = builder.put((Object)"RightFloor", (Object)8971);
        builder = builder.put((Object)"rightharpoondown", (Object)8641);
        builder = builder.put((Object)"rightharpoonup", (Object)8640);
        builder = builder.put((Object)"rightleftarrows", (Object)8644);
        builder = builder.put((Object)"rightleftharpoons", (Object)8652);
        builder = builder.put((Object)"rightrightarrows", (Object)8649);
        builder = builder.put((Object)"rightsquigarrow", (Object)8605);
        builder = builder.put((Object)"RightTee", (Object)8866);
        builder = builder.put((Object)"RightTeeArrow", (Object)8614);
        builder = builder.put((Object)"RightTeeVector", (Object)10587);
        builder = builder.put((Object)"rightthreetimes", (Object)8908);
        builder = builder.put((Object)"RightTriangle", (Object)8883);
        builder = builder.put((Object)"RightTriangleBar", (Object)10704);
        builder = builder.put((Object)"RightTriangleEqual", (Object)8885);
        builder = builder.put((Object)"RightUpDownVector", (Object)10575);
        builder = builder.put((Object)"RightUpTeeVector", (Object)10588);
        builder = builder.put((Object)"RightUpVector", (Object)8638);
        builder = builder.put((Object)"RightUpVectorBar", (Object)10580);
        builder = builder.put((Object)"RightVector", (Object)8640);
        builder = builder.put((Object)"RightVectorBar", (Object)10579);
        builder = builder.put((Object)"ring", (Object)730);
        builder = builder.put((Object)"risingdotseq", (Object)8787);
        builder = builder.put((Object)"rlarr", (Object)8644);
        builder = builder.put((Object)"rlhar", (Object)8652);
        builder = builder.put((Object)"rlm", (Object)8207);
        builder = builder.put((Object)"rmoust", (Object)9137);
        builder = builder.put((Object)"rmoustache", (Object)9137);
        builder = builder.put((Object)"rnmid", (Object)10990);
        builder = builder.put((Object)"roang", (Object)10221);
        builder = builder.put((Object)"roarr", (Object)8702);
        builder = builder.put((Object)"robrk", (Object)10215);
        builder = builder.put((Object)"ropar", (Object)10630);
        builder = builder.put((Object)"ropf", (Object)120163);
        builder = builder.put((Object)"Ropf", (Object)8477);
        builder = builder.put((Object)"roplus", (Object)10798);
        builder = builder.put((Object)"rotimes", (Object)10805);
        builder = builder.put((Object)"RoundImplies", (Object)10608);
        builder = builder.put((Object)"rpar", (Object)41);
        builder = builder.put((Object)"rpargt", (Object)10644);
        builder = builder.put((Object)"rppolint", (Object)10770);
        builder = builder.put((Object)"rrarr", (Object)8649);
        builder = builder.put((Object)"Rrightarrow", (Object)8667);
        builder = builder.put((Object)"rsaquo", (Object)8250);
        builder = builder.put((Object)"rscr", (Object)120007);
        builder = builder.put((Object)"Rscr", (Object)8475);
        builder = builder.put((Object)"rsh", (Object)8625);
        builder = builder.put((Object)"Rsh", (Object)8625);
        builder = builder.put((Object)"rsqb", (Object)93);
        builder = builder.put((Object)"rsquo", (Object)8217);
        builder = builder.put((Object)"rsquor", (Object)8217);
        builder = builder.put((Object)"rthree", (Object)8908);
        builder = builder.put((Object)"rtimes", (Object)8906);
        builder = builder.put((Object)"rtri", (Object)9657);
        builder = builder.put((Object)"rtrie", (Object)8885);
        builder = builder.put((Object)"rtrif", (Object)9656);
        builder = builder.put((Object)"rtriltri", (Object)10702);
        builder = builder.put((Object)"RuleDelayed", (Object)10740);
        builder = builder.put((Object)"ruluhar", (Object)10600);
        builder = builder.put((Object)"rx", (Object)8478);
        builder = builder.put((Object)"sacute", (Object)347);
        builder = builder.put((Object)"Sacute", (Object)346);
        builder = builder.put((Object)"sbquo", (Object)8218);
        builder = builder.put((Object)"sc", (Object)8827);
        builder = builder.put((Object)"Sc", (Object)10940);
        builder = builder.put((Object)"scap", (Object)10936);
        builder = builder.put((Object)"scaron", (Object)353);
        builder = builder.put((Object)"Scaron", (Object)352);
        builder = builder.put((Object)"sccue", (Object)8829);
        builder = builder.put((Object)"sce", (Object)10928);
        builder = builder.put((Object)"scE", (Object)10932);
        builder = builder.put((Object)"scedil", (Object)351);
        builder = builder.put((Object)"Scedil", (Object)350);
        builder = builder.put((Object)"scirc", (Object)349);
        builder = builder.put((Object)"Scirc", (Object)348);
        builder = builder.put((Object)"scnap", (Object)10938);
        builder = builder.put((Object)"scnE", (Object)10934);
        builder = builder.put((Object)"scnsim", (Object)8937);
        builder = builder.put((Object)"scpolint", (Object)10771);
        builder = builder.put((Object)"scsim", (Object)8831);
        builder = builder.put((Object)"scy", (Object)1089);
        builder = builder.put((Object)"Scy", (Object)1057);
        builder = builder.put((Object)"sdot", (Object)8901);
        builder = builder.put((Object)"sdotb", (Object)8865);
        builder = builder.put((Object)"sdote", (Object)10854);
        builder = builder.put((Object)"searhk", (Object)10533);
        builder = builder.put((Object)"searr", (Object)8600);
        builder = builder.put((Object)"seArr", (Object)8664);
        builder = builder.put((Object)"searrow", (Object)8600);
        builder = builder.put((Object)"sect", (Object)167);
        builder = builder.put((Object)"semi", (Object)59);
        builder = builder.put((Object)"seswar", (Object)10537);
        builder = builder.put((Object)"setminus", (Object)8726);
        builder = builder.put((Object)"setmn", (Object)8726);
        builder = builder.put((Object)"sext", (Object)10038);
        builder = builder.put((Object)"sfgr", (Object)962);
        builder = builder.put((Object)"sfr", (Object)120112);
        builder = builder.put((Object)"Sfr", (Object)120086);
        builder = builder.put((Object)"sfrown", (Object)8994);
        builder = builder.put((Object)"sgr", (Object)963);
        builder = builder.put((Object)"Sgr", (Object)931);
        builder = builder.put((Object)"sharp", (Object)9839);
        builder = builder.put((Object)"shchcy", (Object)1097);
        builder = builder.put((Object)"SHCHcy", (Object)1065);
        builder = builder.put((Object)"shcy", (Object)1096);
        builder = builder.put((Object)"SHcy", (Object)1064);
        builder = builder.put((Object)"ShortDownArrow", (Object)8595);
        builder = builder.put((Object)"ShortLeftArrow", (Object)8592);
        builder = builder.put((Object)"shortmid", (Object)8739);
        builder = builder.put((Object)"shortparallel", (Object)8741);
        builder = builder.put((Object)"ShortRightArrow", (Object)8594);
        builder = builder.put((Object)"ShortUpArrow", (Object)8593);
        builder = builder.put((Object)"shy", (Object)173);
        builder = builder.put((Object)"sigma", (Object)963);
        builder = builder.put((Object)"Sigma", (Object)931);
        builder = builder.put((Object)"sigmaf", (Object)962);
        builder = builder.put((Object)"sigmav", (Object)962);
        builder = builder.put((Object)"sim", (Object)8764);
        builder = builder.put((Object)"simdot", (Object)10858);
        builder = builder.put((Object)"sime", (Object)8771);
        builder = builder.put((Object)"simeq", (Object)8771);
        builder = builder.put((Object)"simg", (Object)10910);
        builder = builder.put((Object)"simgE", (Object)10912);
        builder = builder.put((Object)"siml", (Object)10909);
        builder = builder.put((Object)"simlE", (Object)10911);
        builder = builder.put((Object)"simne", (Object)8774);
        builder = builder.put((Object)"simplus", (Object)10788);
        builder = builder.put((Object)"simrarr", (Object)10610);
        builder = builder.put((Object)"slarr", (Object)8592);
        builder = builder.put((Object)"SmallCircle", (Object)8728);
        builder = builder.put((Object)"smallsetminus", (Object)8726);
        builder = builder.put((Object)"smashp", (Object)10803);
        builder = builder.put((Object)"smeparsl", (Object)10724);
        builder = builder.put((Object)"smid", (Object)8739);
        builder = builder.put((Object)"smile", (Object)8995);
        builder = builder.put((Object)"smt", (Object)10922);
        builder = builder.put((Object)"smte", (Object)10924);
        builder = builder.put((Object)"softcy", (Object)1100);
        builder = builder.put((Object)"SOFTcy", (Object)1068);
        builder = builder.put((Object)"sol", (Object)47);
        builder = builder.put((Object)"solb", (Object)10692);
        builder = builder.put((Object)"solbar", (Object)9023);
        builder = builder.put((Object)"sopf", (Object)120164);
        builder = builder.put((Object)"Sopf", (Object)120138);
        builder = builder.put((Object)"spades", (Object)9824);
        builder = builder.put((Object)"spadesuit", (Object)9824);
        builder = builder.put((Object)"spar", (Object)8741);
        builder = builder.put((Object)"sqcap", (Object)8851);
        builder = builder.put((Object)"sqcup", (Object)8852);
        builder = builder.put((Object)"Sqrt", (Object)8730);
        builder = builder.put((Object)"sqsub", (Object)8847);
        builder = builder.put((Object)"sqsube", (Object)8849);
        builder = builder.put((Object)"sqsubset", (Object)8847);
        builder = builder.put((Object)"sqsubseteq", (Object)8849);
        builder = builder.put((Object)"sqsup", (Object)8848);
        builder = builder.put((Object)"sqsupe", (Object)8850);
        builder = builder.put((Object)"sqsupset", (Object)8848);
        builder = builder.put((Object)"sqsupseteq", (Object)8850);
        builder = builder.put((Object)"squ", (Object)9633);
        builder = builder.put((Object)"square", (Object)9633);
        builder = builder.put((Object)"Square", (Object)9633);
        builder = builder.put((Object)"SquareIntersection", (Object)8851);
        builder = builder.put((Object)"SquareSubset", (Object)8847);
        builder = builder.put((Object)"SquareSubsetEqual", (Object)8849);
        builder = builder.put((Object)"SquareSuperset", (Object)8848);
        builder = builder.put((Object)"SquareSupersetEqual", (Object)8850);
        builder = builder.put((Object)"SquareUnion", (Object)8852);
        builder = builder.put((Object)"squarf", (Object)9642);
        builder = builder.put((Object)"squf", (Object)9642);
        builder = builder.put((Object)"srarr", (Object)8594);
        builder = builder.put((Object)"sscr", (Object)120008);
        builder = builder.put((Object)"Sscr", (Object)119982);
        builder = builder.put((Object)"ssetmn", (Object)8726);
        builder = builder.put((Object)"ssmile", (Object)8995);
        builder = builder.put((Object)"sstarf", (Object)8902);
        builder = builder.put((Object)"star", (Object)9734);
        builder = builder.put((Object)"Star", (Object)8902);
        builder = builder.put((Object)"starf", (Object)9733);
        builder = builder.put((Object)"straightepsilon", (Object)1013);
        builder = builder.put((Object)"straightphi", (Object)981);
        builder = builder.put((Object)"strns", (Object)175);
        builder = builder.put((Object)"sub", (Object)8834);
        builder = builder.put((Object)"Sub", (Object)8912);
        builder = builder.put((Object)"subdot", (Object)10941);
        builder = builder.put((Object)"sube", (Object)8838);
        builder = builder.put((Object)"subE", (Object)10949);
        builder = builder.put((Object)"subedot", (Object)10947);
        builder = builder.put((Object)"submult", (Object)10945);
        builder = builder.put((Object)"subne", (Object)8842);
        builder = builder.put((Object)"subnE", (Object)10955);
        builder = builder.put((Object)"subplus", (Object)10943);
        builder = builder.put((Object)"subrarr", (Object)10617);
        builder = builder.put((Object)"subset", (Object)8834);
        builder = builder.put((Object)"Subset", (Object)8912);
        builder = builder.put((Object)"subseteq", (Object)8838);
        builder = builder.put((Object)"subseteqq", (Object)10949);
        builder = builder.put((Object)"SubsetEqual", (Object)8838);
        builder = builder.put((Object)"subsetneq", (Object)8842);
        builder = builder.put((Object)"subsetneqq", (Object)10955);
        builder = builder.put((Object)"subsim", (Object)10951);
        builder = builder.put((Object)"subsub", (Object)10965);
        builder = builder.put((Object)"subsup", (Object)10963);
        builder = builder.put((Object)"succ", (Object)8827);
        builder = builder.put((Object)"succapprox", (Object)10936);
        builder = builder.put((Object)"succcurlyeq", (Object)8829);
        builder = builder.put((Object)"Succeeds", (Object)8827);
        builder = builder.put((Object)"SucceedsEqual", (Object)10928);
        builder = builder.put((Object)"SucceedsSlantEqual", (Object)8829);
        builder = builder.put((Object)"SucceedsTilde", (Object)8831);
        builder = builder.put((Object)"succeq", (Object)10928);
        builder = builder.put((Object)"succnapprox", (Object)10938);
        builder = builder.put((Object)"succneqq", (Object)10934);
        builder = builder.put((Object)"succnsim", (Object)8937);
        builder = builder.put((Object)"succsim", (Object)8831);
        builder = builder.put((Object)"SuchThat", (Object)8715);
        builder = builder.put((Object)"sum", (Object)8721);
        builder = builder.put((Object)"Sum", (Object)8721);
        builder = builder.put((Object)"sung", (Object)9834);
        builder = builder.put((Object)"sup", (Object)8835);
        builder = builder.put((Object)"Sup", (Object)8913);
        builder = builder.put((Object)"sup1", (Object)185);
        builder = builder.put((Object)"sup2", (Object)178);
        builder = builder.put((Object)"sup3", (Object)179);
        builder = builder.put((Object)"supdot", (Object)10942);
        builder = builder.put((Object)"supdsub", (Object)10968);
        builder = builder.put((Object)"supe", (Object)8839);
        builder = builder.put((Object)"supE", (Object)10950);
        builder = builder.put((Object)"supedot", (Object)10948);
        builder = builder.put((Object)"Superset", (Object)8835);
        builder = builder.put((Object)"SupersetEqual", (Object)8839);
        builder = builder.put((Object)"suphsol", (Object)10185);
        builder = builder.put((Object)"suphsub", (Object)10967);
        builder = builder.put((Object)"suplarr", (Object)10619);
        builder = builder.put((Object)"supmult", (Object)10946);
        builder = builder.put((Object)"supne", (Object)8843);
        builder = builder.put((Object)"supnE", (Object)10956);
        builder = builder.put((Object)"supplus", (Object)10944);
        builder = builder.put((Object)"supset", (Object)8835);
        builder = builder.put((Object)"Supset", (Object)8913);
        builder = builder.put((Object)"supseteq", (Object)8839);
        builder = builder.put((Object)"supseteqq", (Object)10950);
        builder = builder.put((Object)"supsetneq", (Object)8843);
        builder = builder.put((Object)"supsetneqq", (Object)10956);
        builder = builder.put((Object)"supsim", (Object)10952);
        builder = builder.put((Object)"supsub", (Object)10964);
        builder = builder.put((Object)"supsup", (Object)10966);
        builder = builder.put((Object)"swarhk", (Object)10534);
        builder = builder.put((Object)"swarr", (Object)8601);
        builder = builder.put((Object)"swArr", (Object)8665);
        builder = builder.put((Object)"swarrow", (Object)8601);
        builder = builder.put((Object)"swnwar", (Object)10538);
        builder = builder.put((Object)"szlig", (Object)223);
        builder = builder.put((Object)"Tab", (Object)9);
        builder = builder.put((Object)"target", (Object)8982);
        builder = builder.put((Object)"tau", (Object)964);
        builder = builder.put((Object)"Tau", (Object)932);
        builder = builder.put((Object)"tbrk", (Object)9140);
        builder = builder.put((Object)"tcaron", (Object)357);
        builder = builder.put((Object)"Tcaron", (Object)356);
        builder = builder.put((Object)"tcedil", (Object)355);
        builder = builder.put((Object)"Tcedil", (Object)354);
        builder = builder.put((Object)"tcy", (Object)1090);
        builder = builder.put((Object)"Tcy", (Object)1058);
        builder = builder.put((Object)"tdot", (Object)8411);
        builder = builder.put((Object)"telrec", (Object)8981);
        builder = builder.put((Object)"tfr", (Object)120113);
        builder = builder.put((Object)"Tfr", (Object)120087);
        builder = builder.put((Object)"tgr", (Object)964);
        builder = builder.put((Object)"Tgr", (Object)932);
        builder = builder.put((Object)"there4", (Object)8756);
        builder = builder.put((Object)"therefore", (Object)8756);
        builder = builder.put((Object)"Therefore", (Object)8756);
        builder = builder.put((Object)"theta", (Object)952);
        builder = builder.put((Object)"Theta", (Object)920);
        builder = builder.put((Object)"thetasym", (Object)977);
        builder = builder.put((Object)"thetav", (Object)977);
        builder = builder.put((Object)"thgr", (Object)952);
        builder = builder.put((Object)"THgr", (Object)920);
        builder = builder.put((Object)"thickapprox", (Object)8776);
        builder = builder.put((Object)"thicksim", (Object)8764);
        builder = builder.put((Object)"thinsp", (Object)8201);
        builder = builder.put((Object)"ThinSpace", (Object)8201);
        builder = builder.put((Object)"thkap", (Object)8776);
        builder = builder.put((Object)"thksim", (Object)8764);
        builder = builder.put((Object)"thorn", (Object)254);
        builder = builder.put((Object)"THORN", (Object)222);
        builder = builder.put((Object)"tilde", (Object)732);
        builder = builder.put((Object)"Tilde", (Object)8764);
        builder = builder.put((Object)"TildeEqual", (Object)8771);
        builder = builder.put((Object)"TildeFullEqual", (Object)8773);
        builder = builder.put((Object)"TildeTilde", (Object)8776);
        builder = builder.put((Object)"times", (Object)215);
        builder = builder.put((Object)"timesb", (Object)8864);
        builder = builder.put((Object)"timesbar", (Object)10801);
        builder = builder.put((Object)"timesd", (Object)10800);
        builder = builder.put((Object)"tint", (Object)8749);
        builder = builder.put((Object)"toea", (Object)10536);
        builder = builder.put((Object)"top", (Object)8868);
        builder = builder.put((Object)"topbot", (Object)9014);
        builder = builder.put((Object)"topcir", (Object)10993);
        builder = builder.put((Object)"topf", (Object)120165);
        builder = builder.put((Object)"Topf", (Object)120139);
        builder = builder.put((Object)"topfork", (Object)10970);
        builder = builder.put((Object)"tosa", (Object)10537);
        builder = builder.put((Object)"tprime", (Object)8244);
        builder = builder.put((Object)"trade", (Object)8482);
        builder = builder.put((Object)"TRADE", (Object)8482);
        builder = builder.put((Object)"triangle", (Object)9653);
        builder = builder.put((Object)"triangledown", (Object)9663);
        builder = builder.put((Object)"triangleleft", (Object)9667);
        builder = builder.put((Object)"trianglelefteq", (Object)8884);
        builder = builder.put((Object)"triangleq", (Object)8796);
        builder = builder.put((Object)"triangleright", (Object)9657);
        builder = builder.put((Object)"trianglerighteq", (Object)8885);
        builder = builder.put((Object)"tridot", (Object)9708);
        builder = builder.put((Object)"trie", (Object)8796);
        builder = builder.put((Object)"triminus", (Object)10810);
        builder = builder.put((Object)"TripleDot", (Object)8411);
        builder = builder.put((Object)"triplus", (Object)10809);
        builder = builder.put((Object)"trisb", (Object)10701);
        builder = builder.put((Object)"tritime", (Object)10811);
        builder = builder.put((Object)"trpezium", (Object)9186);
        builder = builder.put((Object)"tscr", (Object)120009);
        builder = builder.put((Object)"Tscr", (Object)119983);
        builder = builder.put((Object)"tscy", (Object)1094);
        builder = builder.put((Object)"TScy", (Object)1062);
        builder = builder.put((Object)"tshcy", (Object)1115);
        builder = builder.put((Object)"TSHcy", (Object)1035);
        builder = builder.put((Object)"tstrok", (Object)359);
        builder = builder.put((Object)"Tstrok", (Object)358);
        builder = builder.put((Object)"twixt", (Object)8812);
        builder = builder.put((Object)"twoheadleftarrow", (Object)8606);
        builder = builder.put((Object)"twoheadrightarrow", (Object)8608);
        builder = builder.put((Object)"uacgr", (Object)973);
        builder = builder.put((Object)"Uacgr", (Object)910);
        builder = builder.put((Object)"uacute", (Object)250);
        builder = builder.put((Object)"Uacute", (Object)218);
        builder = builder.put((Object)"uarr", (Object)8593);
        builder = builder.put((Object)"uArr", (Object)8657);
        builder = builder.put((Object)"Uarr", (Object)8607);
        builder = builder.put((Object)"Uarrocir", (Object)10569);
        builder = builder.put((Object)"ubrcy", (Object)1118);
        builder = builder.put((Object)"Ubrcy", (Object)1038);
        builder = builder.put((Object)"ubreve", (Object)365);
        builder = builder.put((Object)"Ubreve", (Object)364);
        builder = builder.put((Object)"ucirc", (Object)251);
        builder = builder.put((Object)"Ucirc", (Object)219);
        builder = builder.put((Object)"ucy", (Object)1091);
        builder = builder.put((Object)"Ucy", (Object)1059);
        builder = builder.put((Object)"udarr", (Object)8645);
        builder = builder.put((Object)"udblac", (Object)369);
        builder = builder.put((Object)"Udblac", (Object)368);
        builder = builder.put((Object)"udhar", (Object)10606);
        builder = builder.put((Object)"udiagr", (Object)944);
        builder = builder.put((Object)"udigr", (Object)971);
        builder = builder.put((Object)"Udigr", (Object)939);
        builder = builder.put((Object)"ufisht", (Object)10622);
        builder = builder.put((Object)"ufr", (Object)120114);
        builder = builder.put((Object)"Ufr", (Object)120088);
        builder = builder.put((Object)"ugr", (Object)965);
        builder = builder.put((Object)"Ugr", (Object)933);
        builder = builder.put((Object)"ugrave", (Object)249);
        builder = builder.put((Object)"Ugrave", (Object)217);
        builder = builder.put((Object)"uHar", (Object)10595);
        builder = builder.put((Object)"uharl", (Object)8639);
        builder = builder.put((Object)"uharr", (Object)8638);
        builder = builder.put((Object)"uhblk", (Object)9600);
        builder = builder.put((Object)"ulcorn", (Object)8988);
        builder = builder.put((Object)"ulcorner", (Object)8988);
        builder = builder.put((Object)"ulcrop", (Object)8975);
        builder = builder.put((Object)"ultri", (Object)9720);
        builder = builder.put((Object)"umacr", (Object)363);
        builder = builder.put((Object)"Umacr", (Object)362);
        builder = builder.put((Object)"uml", (Object)168);
        builder = builder.put((Object)"UnderBar", (Object)95);
        builder = builder.put((Object)"UnderBrace", (Object)9183);
        builder = builder.put((Object)"UnderBracket", (Object)9141);
        builder = builder.put((Object)"UnderParenthesis", (Object)9181);
        builder = builder.put((Object)"Union", (Object)8899);
        builder = builder.put((Object)"UnionPlus", (Object)8846);
        builder = builder.put((Object)"uogon", (Object)371);
        builder = builder.put((Object)"Uogon", (Object)370);
        builder = builder.put((Object)"uopf", (Object)120166);
        builder = builder.put((Object)"Uopf", (Object)120140);
        builder = builder.put((Object)"uparrow", (Object)8593);
        builder = builder.put((Object)"Uparrow", (Object)8657);
        builder = builder.put((Object)"UpArrow", (Object)8593);
        builder = builder.put((Object)"UpArrowBar", (Object)10514);
        builder = builder.put((Object)"UpArrowDownArrow", (Object)8645);
        builder = builder.put((Object)"updownarrow", (Object)8597);
        builder = builder.put((Object)"Updownarrow", (Object)8661);
        builder = builder.put((Object)"UpDownArrow", (Object)8597);
        builder = builder.put((Object)"UpEquilibrium", (Object)10606);
        builder = builder.put((Object)"upharpoonleft", (Object)8639);
        builder = builder.put((Object)"upharpoonright", (Object)8638);
        builder = builder.put((Object)"uplus", (Object)8846);
        builder = builder.put((Object)"UpperLeftArrow", (Object)8598);
        builder = builder.put((Object)"UpperRightArrow", (Object)8599);
        builder = builder.put((Object)"upsi", (Object)965);
        builder = builder.put((Object)"Upsi", (Object)978);
        builder = builder.put((Object)"upsih", (Object)978);
        builder = builder.put((Object)"upsilon", (Object)965);
        builder = builder.put((Object)"Upsilon", (Object)933);
        builder = builder.put((Object)"UpTee", (Object)8869);
        builder = builder.put((Object)"UpTeeArrow", (Object)8613);
        builder = builder.put((Object)"upuparrows", (Object)8648);
        builder = builder.put((Object)"urcorn", (Object)8989);
        builder = builder.put((Object)"urcorner", (Object)8989);
        builder = builder.put((Object)"urcrop", (Object)8974);
        builder = builder.put((Object)"uring", (Object)367);
        builder = builder.put((Object)"Uring", (Object)366);
        builder = builder.put((Object)"urtri", (Object)9721);
        builder = builder.put((Object)"uscr", (Object)120010);
        builder = builder.put((Object)"Uscr", (Object)119984);
        builder = builder.put((Object)"utdot", (Object)8944);
        builder = builder.put((Object)"utilde", (Object)361);
        builder = builder.put((Object)"Utilde", (Object)360);
        builder = builder.put((Object)"utri", (Object)9653);
        builder = builder.put((Object)"utrif", (Object)9652);
        builder = builder.put((Object)"uuarr", (Object)8648);
        builder = builder.put((Object)"uuml", (Object)252);
        builder = builder.put((Object)"Uuml", (Object)220);
        builder = builder.put((Object)"uwangle", (Object)10663);
        builder = builder.put((Object)"vangrt", (Object)10652);
        builder = builder.put((Object)"varepsilon", (Object)1013);
        builder = builder.put((Object)"varkappa", (Object)1008);
        builder = builder.put((Object)"varnothing", (Object)8709);
        builder = builder.put((Object)"varphi", (Object)981);
        builder = builder.put((Object)"varpi", (Object)982);
        builder = builder.put((Object)"varpropto", (Object)8733);
        builder = builder.put((Object)"varr", (Object)8597);
        builder = builder.put((Object)"vArr", (Object)8661);
        builder = builder.put((Object)"varrho", (Object)1009);
        builder = builder.put((Object)"varsigma", (Object)962);
        builder = builder.put((Object)"vartheta", (Object)977);
        builder = builder.put((Object)"vartriangleleft", (Object)8882);
        builder = builder.put((Object)"vartriangleright", (Object)8883);
        builder = builder.put((Object)"vBar", (Object)10984);
        builder = builder.put((Object)"Vbar", (Object)10987);
        builder = builder.put((Object)"vBarv", (Object)10985);
        builder = builder.put((Object)"vcy", (Object)1074);
        builder = builder.put((Object)"Vcy", (Object)1042);
        builder = builder.put((Object)"vdash", (Object)8866);
        builder = builder.put((Object)"vDash", (Object)8872);
        builder = builder.put((Object)"Vdash", (Object)8873);
        builder = builder.put((Object)"VDash", (Object)8875);
        builder = builder.put((Object)"Vdashl", (Object)10982);
        builder = builder.put((Object)"vee", (Object)8744);
        builder = builder.put((Object)"Vee", (Object)8897);
        builder = builder.put((Object)"veebar", (Object)8891);
        builder = builder.put((Object)"veeeq", (Object)8794);
        builder = builder.put((Object)"vellip", (Object)8942);
        builder = builder.put((Object)"verbar", (Object)124);
        builder = builder.put((Object)"Verbar", (Object)8214);
        builder = builder.put((Object)"vert", (Object)124);
        builder = builder.put((Object)"Vert", (Object)8214);
        builder = builder.put((Object)"VerticalBar", (Object)8739);
        builder = builder.put((Object)"VerticalLine", (Object)124);
        builder = builder.put((Object)"VerticalSeparator", (Object)10072);
        builder = builder.put((Object)"VerticalTilde", (Object)8768);
        builder = builder.put((Object)"VeryThinSpace", (Object)8202);
        builder = builder.put((Object)"vfr", (Object)120115);
        builder = builder.put((Object)"Vfr", (Object)120089);
        builder = builder.put((Object)"vltri", (Object)8882);
        builder = builder.put((Object)"vopf", (Object)120167);
        builder = builder.put((Object)"Vopf", (Object)120141);
        builder = builder.put((Object)"vprop", (Object)8733);
        builder = builder.put((Object)"vrtri", (Object)8883);
        builder = builder.put((Object)"vscr", (Object)120011);
        builder = builder.put((Object)"Vscr", (Object)119985);
        builder = builder.put((Object)"Vvdash", (Object)8874);
        builder = builder.put((Object)"vzigzag", (Object)10650);
        builder = builder.put((Object)"wcirc", (Object)373);
        builder = builder.put((Object)"Wcirc", (Object)372);
        builder = builder.put((Object)"wedbar", (Object)10847);
        builder = builder.put((Object)"wedge", (Object)8743);
        builder = builder.put((Object)"Wedge", (Object)8896);
        builder = builder.put((Object)"wedgeq", (Object)8793);
        builder = builder.put((Object)"weierp", (Object)8472);
        builder = builder.put((Object)"wfr", (Object)120116);
        builder = builder.put((Object)"Wfr", (Object)120090);
        builder = builder.put((Object)"wopf", (Object)120168);
        builder = builder.put((Object)"Wopf", (Object)120142);
        builder = builder.put((Object)"wp", (Object)8472);
        builder = builder.put((Object)"wr", (Object)8768);
        builder = builder.put((Object)"wreath", (Object)8768);
        builder = builder.put((Object)"wscr", (Object)120012);
        builder = builder.put((Object)"Wscr", (Object)119986);
        builder = builder.put((Object)"xcap", (Object)8898);
        builder = builder.put((Object)"xcirc", (Object)9711);
        builder = builder.put((Object)"xcup", (Object)8899);
        builder = builder.put((Object)"xdtri", (Object)9661);
        builder = builder.put((Object)"xfr", (Object)120117);
        builder = builder.put((Object)"Xfr", (Object)120091);
        builder = builder.put((Object)"xgr", (Object)958);
        builder = builder.put((Object)"Xgr", (Object)926);
        builder = builder.put((Object)"xharr", (Object)10231);
        builder = builder.put((Object)"xhArr", (Object)10234);
        builder = builder.put((Object)"xi", (Object)958);
        builder = builder.put((Object)"Xi", (Object)926);
        builder = builder.put((Object)"xlarr", (Object)10229);
        builder = builder.put((Object)"xlArr", (Object)10232);
        builder = builder.put((Object)"xmap", (Object)10236);
        builder = builder.put((Object)"xnis", (Object)8955);
        builder = builder.put((Object)"xodot", (Object)10752);
        builder = builder.put((Object)"xopf", (Object)120169);
        builder = builder.put((Object)"Xopf", (Object)120143);
        builder = builder.put((Object)"xoplus", (Object)10753);
        builder = builder.put((Object)"xotime", (Object)10754);
        builder = builder.put((Object)"xrarr", (Object)10230);
        builder = builder.put((Object)"xrArr", (Object)10233);
        builder = builder.put((Object)"xscr", (Object)120013);
        builder = builder.put((Object)"Xscr", (Object)119987);
        builder = builder.put((Object)"xsqcup", (Object)10758);
        builder = builder.put((Object)"xuplus", (Object)10756);
        builder = builder.put((Object)"xutri", (Object)9651);
        builder = builder.put((Object)"xvee", (Object)8897);
        builder = builder.put((Object)"xwedge", (Object)8896);
        builder = builder.put((Object)"yacute", (Object)253);
        builder = builder.put((Object)"Yacute", (Object)221);
        builder = builder.put((Object)"yacy", (Object)1103);
        builder = builder.put((Object)"YAcy", (Object)1071);
        builder = builder.put((Object)"ycirc", (Object)375);
        builder = builder.put((Object)"Ycirc", (Object)374);
        builder = builder.put((Object)"ycy", (Object)1099);
        builder = builder.put((Object)"Ycy", (Object)1067);
        builder = builder.put((Object)"yen", (Object)165);
        builder = builder.put((Object)"yfr", (Object)120118);
        builder = builder.put((Object)"Yfr", (Object)120092);
        builder = builder.put((Object)"yicy", (Object)1111);
        builder = builder.put((Object)"YIcy", (Object)1031);
        builder = builder.put((Object)"yopf", (Object)120170);
        builder = builder.put((Object)"Yopf", (Object)120144);
        builder = builder.put((Object)"yscr", (Object)120014);
        builder = builder.put((Object)"Yscr", (Object)119988);
        builder = builder.put((Object)"yucy", (Object)1102);
        builder = builder.put((Object)"YUcy", (Object)1070);
        builder = builder.put((Object)"yuml", (Object)255);
        builder = builder.put((Object)"Yuml", (Object)376);
        builder = builder.put((Object)"zacute", (Object)378);
        builder = builder.put((Object)"Zacute", (Object)377);
        builder = builder.put((Object)"zcaron", (Object)382);
        builder = builder.put((Object)"Zcaron", (Object)381);
        builder = builder.put((Object)"zcy", (Object)1079);
        builder = builder.put((Object)"Zcy", (Object)1047);
        builder = builder.put((Object)"zdot", (Object)380);
        builder = builder.put((Object)"Zdot", (Object)379);
        builder = builder.put((Object)"zeetrf", (Object)8488);
        builder = builder.put((Object)"ZeroWidthSpace", (Object)8203);
        builder = builder.put((Object)"zeta", (Object)950);
        builder = builder.put((Object)"Zeta", (Object)918);
        builder = builder.put((Object)"zfr", (Object)120119);
        builder = builder.put((Object)"Zfr", (Object)8488);
        builder = builder.put((Object)"zgr", (Object)950);
        builder = builder.put((Object)"Zgr", (Object)918);
        builder = builder.put((Object)"zhcy", (Object)1078);
        builder = builder.put((Object)"ZHcy", (Object)1046);
        builder = builder.put((Object)"zigrarr", (Object)8669);
        builder = builder.put((Object)"zopf", (Object)120171);
        builder = builder.put((Object)"Zopf", (Object)8484);
        builder = builder.put((Object)"zscr", (Object)120015);
        builder = builder.put((Object)"Zscr", (Object)119989);
        builder = builder.put((Object)"zwj", (Object)8205);
        builder = builder.put((Object)"zwnj", (Object)8204);
        ENTITY_TRIE = new Trie((Map<String, Integer>)builder.build());
    }
}

