/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.owasp.html.AttributePolicy;

@Immutable
final class JoinedAttributePolicy
implements AttributePolicy {
    final AttributePolicy[] policies;

    JoinedAttributePolicy(Collection<? extends AttributePolicy> policies) {
        this.policies = policies.toArray(new AttributePolicy[policies.size()]);
    }

    @Override
    @Nullable
    public String apply(String elementName, String attributeName, @Nullable String rawValue) {
        String value = rawValue;
        for (AttributePolicy p : this.policies) {
            if (value == null) break;
            value = p.apply(elementName, attributeName, value);
        }
        return value;
    }

    public boolean equals(Object o) {
        return o != null && this.getClass() == o.getClass() && Arrays.equals(this.policies, ((JoinedAttributePolicy)o).policies);
    }

    public int hashCode() {
        return this.policies.hashCode();
    }
}

