/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css;

import com.helger.commons.string.StringHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSFilenameHelper {
    private static final CSSFilenameHelper s_aInstance = new CSSFilenameHelper();

    private CSSFilenameHelper() {
    }

    public static boolean isCSSFilename(@Nullable String sFilename) {
        return StringHelper.endsWith((String)sFilename, (String)".css");
    }

    public static boolean isMinifiedCSSFilename(@Nullable String sFilename) {
        return StringHelper.endsWith((String)sFilename, (String)".min.css");
    }

    public static boolean isRegularCSSFilename(@Nullable String sFilename) {
        return CSSFilenameHelper.isCSSFilename(sFilename) && !CSSFilenameHelper.isMinifiedCSSFilename(sFilename);
    }

    @Nonnull
    public static String getMinifiedCSSFilename(@Nonnull String sCSSFilename) {
        if (!CSSFilenameHelper.isCSSFilename(sCSSFilename)) {
            throw new IllegalArgumentException("Passed file name '" + sCSSFilename + "' is not a CSS file name!");
        }
        if (CSSFilenameHelper.isMinifiedCSSFilename(sCSSFilename)) {
            return sCSSFilename;
        }
        return StringHelper.trimEnd((String)sCSSFilename, (String)".css") + ".min.css";
    }
}

