/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class CSSSourceArea
implements Serializable {
    private final int m_nBeginLineNumber;
    private final int m_nBeginColumnNumber;
    private final int m_nEndLineNumber;
    private final int m_nEndColumnNumber;

    public CSSSourceArea(int nBeginLineNumber, int nBeginColumnNumber, int nEndLineNumber, int nEndColumnNumber) {
        this.m_nBeginLineNumber = nBeginLineNumber;
        this.m_nBeginColumnNumber = nBeginColumnNumber;
        this.m_nEndLineNumber = nEndLineNumber;
        this.m_nEndColumnNumber = nEndColumnNumber;
    }

    @CheckForSigned
    public int getTokenBeginLineNumber() {
        return this.m_nBeginLineNumber;
    }

    @CheckForSigned
    public int getTokenBeginColumnNumber() {
        return this.m_nBeginColumnNumber;
    }

    @CheckForSigned
    public int getTokenEndLineNumber() {
        return this.m_nEndLineNumber;
    }

    @CheckForSigned
    public int getTokenEndColumnNumber() {
        return this.m_nEndColumnNumber;
    }

    @Nonnull
    @Nonempty
    public String getTokenLocationAsString() {
        if (this.m_nBeginLineNumber == this.m_nEndLineNumber && this.m_nBeginColumnNumber == this.m_nEndColumnNumber) {
            return "(" + this.m_nBeginLineNumber + ":" + this.m_nBeginColumnNumber + ")";
        }
        return "(" + this.m_nBeginLineNumber + ":" + this.m_nBeginColumnNumber + "/" + this.m_nEndLineNumber + ":" + this.m_nEndColumnNumber + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSSourceArea rhs = (CSSSourceArea)o;
        return this.m_nBeginLineNumber == rhs.m_nBeginLineNumber && this.m_nBeginColumnNumber == rhs.m_nBeginColumnNumber && this.m_nEndLineNumber == rhs.m_nEndLineNumber && this.m_nEndColumnNumber == rhs.m_nEndColumnNumber;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_nBeginLineNumber).append(this.m_nBeginColumnNumber).append(this.m_nEndLineNumber).append(this.m_nEndColumnNumber).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("beginLine", this.m_nBeginLineNumber).append("beginColumn", this.m_nBeginColumnNumber).append("endLine", this.m_nEndLineNumber).append("endColumn", this.m_nEndColumnNumber).getToString();
    }
}

