/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceArea;
import java.io.Serializable;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class CSSSourceLocation
implements Serializable {
    private final CSSSourceArea m_aFirstTokenArea;
    private final CSSSourceArea m_aLastTokenArea;

    public CSSSourceLocation(@Nullable CSSSourceArea aFirstTokenArea, @Nullable CSSSourceArea aLastTokenArea) {
        if (aFirstTokenArea == null && aLastTokenArea == null) {
            throw new IllegalArgumentException("At least one of the areas must be set!");
        }
        this.m_aFirstTokenArea = aFirstTokenArea;
        this.m_aLastTokenArea = aLastTokenArea;
    }

    @Nullable
    public CSSSourceArea getFirstTokenArea() {
        return this.m_aFirstTokenArea;
    }

    public boolean hasFirstTokenArea() {
        return this.m_aFirstTokenArea != null;
    }

    @CheckForSigned
    public int getFirstTokenBeginLineNumber() {
        return this.m_aFirstTokenArea == null ? -1 : this.m_aFirstTokenArea.getTokenBeginLineNumber();
    }

    @CheckForSigned
    public int getFirstTokenBeginColumnNumber() {
        return this.m_aFirstTokenArea == null ? -1 : this.m_aFirstTokenArea.getTokenBeginColumnNumber();
    }

    @CheckForSigned
    public int getFirstTokenEndLineNumber() {
        return this.m_aFirstTokenArea == null ? -1 : this.m_aFirstTokenArea.getTokenEndLineNumber();
    }

    @CheckForSigned
    public int getFirstTokenEndColumnNumber() {
        return this.m_aFirstTokenArea == null ? -1 : this.m_aFirstTokenArea.getTokenEndColumnNumber();
    }

    @Nullable
    public CSSSourceArea getLastTokenArea() {
        return this.m_aLastTokenArea;
    }

    public boolean hasLastTokenArea() {
        return this.m_aLastTokenArea != null;
    }

    @CheckForSigned
    public int getLastTokenBeginLineNumber() {
        return this.m_aLastTokenArea == null ? -1 : this.m_aLastTokenArea.getTokenBeginLineNumber();
    }

    @CheckForSigned
    public int getLastTokenBeginColumnNumber() {
        return this.m_aLastTokenArea == null ? -1 : this.m_aLastTokenArea.getTokenBeginColumnNumber();
    }

    @CheckForSigned
    public int getLastTokenEndLineNumber() {
        return this.m_aLastTokenArea == null ? -1 : this.m_aLastTokenArea.getTokenEndLineNumber();
    }

    @CheckForSigned
    public int getLastTokenEndColumnNumber() {
        return this.m_aLastTokenArea == null ? -1 : this.m_aLastTokenArea.getTokenEndColumnNumber();
    }

    @Nullable
    public String getFirstTokenLocationAsString() {
        return this.m_aFirstTokenArea == null ? null : this.m_aFirstTokenArea.getTokenLocationAsString();
    }

    @Nullable
    public String getLastTokenLocationAsString() {
        return this.m_aLastTokenArea == null ? null : this.m_aLastTokenArea.getTokenLocationAsString();
    }

    @Nonnull
    @Nonempty
    public String getLocationAsString() {
        String sFirst = this.getFirstTokenLocationAsString();
        String sLast = this.getLastTokenLocationAsString();
        return StringHelper.getNotNull((String)sFirst, (String)"") + "-" + StringHelper.getNotNull((String)sLast, (String)"");
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSSourceLocation rhs = (CSSSourceLocation)o;
        return EqualsHelper.equals((Object)this.m_aFirstTokenArea, (Object)rhs.m_aFirstTokenArea) && EqualsHelper.equals((Object)this.m_aLastTokenArea, (Object)rhs.m_aLastTokenArea);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aFirstTokenArea).append((Object)this.m_aLastTokenArea).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("firstTokenArea", (Object)this.m_aFirstTokenArea).append("lastTokenArea", (Object)this.m_aLastTokenArea).getToString();
    }
}

