/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.name.IHasDisplayName;
import com.helger.commons.string.StringHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum ECSSVendorPrefix implements IHasDisplayName
{
    APPLE("-apple-", "Safari"),
    ATSC("-atsc-", "Advanced Television Standards Committee"),
    EPUB("-epub-", "EPUB"),
    KHTML("-khtml-", "Konqueror browser"),
    MICROSOFT("-ms-", "Microsoft"),
    MICROSOFT_OFFICE("mso-", "Microsoft Office"),
    MOZILLA("-moz-", "Mozilla"),
    OPERA("-o-", "Opera"),
    SCROLLBAR("scrollbar-", "Scrollbars"),
    WAP("-wap-", "The WAP forum"),
    WEBKIT("-webkit-", "WebKit-based browsers");

    private final String m_sPrefix;
    private final String m_sDisplayName;

    private ECSSVendorPrefix(String sPrefix, String sDisplayName) {
        this.m_sPrefix = sPrefix;
        this.m_sDisplayName = sDisplayName;
    }

    @Nonnull
    @Nonempty
    public String getPrefix() {
        return this.m_sPrefix;
    }

    @Nonnull
    @Nonempty
    public String getDisplayName() {
        return this.m_sDisplayName;
    }

    @Nullable
    public static ECSSVendorPrefix getFromPrefixOrNull(@Nullable String sPrefix) {
        if (StringHelper.hasText((String)sPrefix)) {
            for (ECSSVendorPrefix e : ECSSVendorPrefix.values()) {
                if (!e.m_sPrefix.equals(sPrefix)) continue;
                return e;
            }
        }
        return null;
    }
}

