/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.state.EChange;
import com.helger.css.decl.CSSFontFaceRule;
import com.helger.css.decl.CSSKeyframesRule;
import com.helger.css.decl.CSSMediaRule;
import com.helger.css.decl.CSSPageRule;
import com.helger.css.decl.CSSStyleRule;
import com.helger.css.decl.CSSSupportsRule;
import com.helger.css.decl.CSSUnknownRule;
import com.helger.css.decl.CSSViewportRule;
import com.helger.css.decl.ICSSTopLevelRule;
import java.io.Serializable;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractHasTopLevelRules
implements Serializable {
    protected final ICommonsList<ICSSTopLevelRule> m_aRules = new CommonsArrayList();

    public boolean hasRules() {
        return this.m_aRules.isNotEmpty();
    }

    @Nonnegative
    public int getRuleCount() {
        return this.m_aRules.size();
    }

    @Nullable
    @Deprecated
    public ICSSTopLevelRule getRule(@Nonnegative int nIndex) {
        return this.getRuleAtIndex(nIndex);
    }

    @Nullable
    public ICSSTopLevelRule getRuleAtIndex(@Nonnegative int nIndex) {
        return (ICSSTopLevelRule)this.m_aRules.getAtIndex(nIndex);
    }

    @Nonnull
    public AbstractHasTopLevelRules addRule(@Nonnull ICSSTopLevelRule aRule) {
        ValueEnforcer.notNull((Object)aRule, (String)"Rule");
        this.m_aRules.add((Object)aRule);
        return this;
    }

    @Nonnull
    public AbstractHasTopLevelRules addRule(@Nonnegative int nIndex, @Nonnull ICSSTopLevelRule aRule) {
        ValueEnforcer.isGE0((int)nIndex, (String)"Index");
        ValueEnforcer.notNull((Object)aRule, (String)"Rule");
        if (nIndex >= this.getRuleCount()) {
            this.m_aRules.add((Object)aRule);
        } else {
            this.m_aRules.add(nIndex, (Object)aRule);
        }
        return this;
    }

    @Nonnull
    public EChange removeRule(@Nullable ICSSTopLevelRule aRule) {
        return this.m_aRules.removeObject((Object)aRule);
    }

    @Nonnull
    public EChange removeRule(@Nonnegative int nRuleIndex) {
        return this.m_aRules.removeAtIndex(nRuleIndex);
    }

    @Nonnull
    public EChange removeRules(@Nonnull Predicate<? super ICSSTopLevelRule> aFilter) {
        return EChange.valueOf((boolean)this.m_aRules.removeIf(aFilter));
    }

    @Nonnull
    public EChange removeAllRules() {
        return this.m_aRules.removeAll();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ICSSTopLevelRule> getAllRules() {
        return (ICommonsList)this.m_aRules.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ICSSTopLevelRule> getAllRules(@Nonnull Predicate<? super ICSSTopLevelRule> aFilter) {
        return this.m_aRules.getAll(aFilter);
    }

    public boolean hasStyleRules() {
        return this.m_aRules.containsAny(r -> r instanceof CSSStyleRule);
    }

    @Nonnegative
    public int getStyleRuleCount() {
        return this.m_aRules.getCount(r -> r instanceof CSSStyleRule);
    }

    @Nullable
    public CSSStyleRule getStyleRuleAtIndex(@Nonnegative int nIndex) {
        return (CSSStyleRule)this.m_aRules.getAtIndexMapped(r -> r instanceof CSSStyleRule, nIndex, r -> (CSSStyleRule)r);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSStyleRule> getAllStyleRules() {
        return this.m_aRules.getAllMapped(r -> r instanceof CSSStyleRule, r -> (CSSStyleRule)r);
    }

    public boolean hasPageRules() {
        return this.m_aRules.containsAny(r -> r instanceof CSSPageRule);
    }

    @Nonnegative
    public int getPageRuleCount() {
        return this.m_aRules.getCount(r -> r instanceof CSSPageRule);
    }

    @Nullable
    public CSSPageRule getPageRuleAtIndex(@Nonnegative int nIndex) {
        return (CSSPageRule)this.m_aRules.getAtIndexMapped(r -> r instanceof CSSPageRule, nIndex, r -> (CSSPageRule)r);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSPageRule> getAllPageRules() {
        return this.m_aRules.getAllMapped(r -> r instanceof CSSPageRule, r -> (CSSPageRule)r);
    }

    public boolean hasMediaRules() {
        return this.m_aRules.containsAny(r -> r instanceof CSSMediaRule);
    }

    @Nonnegative
    public int getMediaRuleCount() {
        return this.m_aRules.getCount(r -> r instanceof CSSMediaRule);
    }

    @Nullable
    public CSSMediaRule getMediaRuleAtIndex(@Nonnegative int nIndex) {
        return (CSSMediaRule)this.m_aRules.getAtIndexMapped(r -> r instanceof CSSMediaRule, nIndex, r -> (CSSMediaRule)r);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSMediaRule> getAllMediaRules() {
        return this.m_aRules.getAllMapped(r -> r instanceof CSSMediaRule, r -> (CSSMediaRule)r);
    }

    public boolean hasFontFaceRules() {
        return this.m_aRules.containsAny(r -> r instanceof CSSFontFaceRule);
    }

    @Nonnegative
    public int getFontFaceRuleCount() {
        return this.m_aRules.getCount(r -> r instanceof CSSFontFaceRule);
    }

    @Nullable
    public CSSFontFaceRule getFontFaceRuleAtIndex(@Nonnegative int nIndex) {
        return (CSSFontFaceRule)this.m_aRules.getAtIndexMapped(r -> r instanceof CSSFontFaceRule, nIndex, r -> (CSSFontFaceRule)r);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSFontFaceRule> getAllFontFaceRules() {
        return this.m_aRules.getAllMapped(r -> r instanceof CSSFontFaceRule, r -> (CSSFontFaceRule)r);
    }

    public boolean hasKeyframesRules() {
        return this.m_aRules.containsAny(r -> r instanceof CSSKeyframesRule);
    }

    @Nonnegative
    public int getKeyframesRuleCount() {
        return this.m_aRules.getCount(r -> r instanceof CSSKeyframesRule);
    }

    @Nullable
    public CSSKeyframesRule getKeyframesRuleAtIndex(@Nonnegative int nIndex) {
        return (CSSKeyframesRule)this.m_aRules.getAtIndexMapped(r -> r instanceof CSSKeyframesRule, nIndex, r -> (CSSKeyframesRule)r);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSKeyframesRule> getAllKeyframesRules() {
        return this.m_aRules.getAllMapped(r -> r instanceof CSSKeyframesRule, r -> (CSSKeyframesRule)r);
    }

    public boolean hasViewportRules() {
        return this.m_aRules.containsAny(r -> r instanceof CSSViewportRule);
    }

    @Nonnegative
    public int getViewportRuleCount() {
        return this.m_aRules.getCount(r -> r instanceof CSSViewportRule);
    }

    @Nullable
    public CSSViewportRule getViewportRuleAtIndex(@Nonnegative int nIndex) {
        return (CSSViewportRule)this.m_aRules.getAtIndexMapped(r -> r instanceof CSSViewportRule, nIndex, r -> (CSSViewportRule)r);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSViewportRule> getAllViewportRules() {
        return this.m_aRules.getAllMapped(r -> r instanceof CSSViewportRule, r -> (CSSViewportRule)r);
    }

    public boolean hasSupportsRules() {
        return this.m_aRules.containsAny(r -> r instanceof CSSSupportsRule);
    }

    @Nonnegative
    public int getSupportsRuleCount() {
        return this.m_aRules.getCount(r -> r instanceof CSSSupportsRule);
    }

    @Nullable
    public CSSSupportsRule getSupportsRuleAtIndex(@Nonnegative int nIndex) {
        return (CSSSupportsRule)this.m_aRules.getAtIndexMapped(r -> r instanceof CSSSupportsRule, nIndex, r -> (CSSSupportsRule)r);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSSupportsRule> getAllSupportsRules() {
        return this.m_aRules.getAllMapped(r -> r instanceof CSSSupportsRule, r -> (CSSSupportsRule)r);
    }

    public boolean hasUnknownRules() {
        return this.m_aRules.containsAny(r -> r instanceof CSSUnknownRule);
    }

    @Nonnegative
    public int getUnknownRuleCount() {
        return this.m_aRules.getCount(r -> r instanceof CSSUnknownRule);
    }

    @Nullable
    public CSSUnknownRule getUnknownRuleAtIndex(@Nonnegative int nIndex) {
        return (CSSUnknownRule)this.m_aRules.getAtIndexMapped(r -> r instanceof CSSUnknownRule, nIndex, r -> (CSSUnknownRule)r);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSUnknownRule> getAllUnknownRules() {
        return this.m_aRules.getAllMapped(r -> r instanceof CSSUnknownRule, r -> (CSSUnknownRule)r);
    }
}

