/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.annotation.Nonempty;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSDeclarationList;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSDeclarationContainer
extends CSSDeclarationList {
    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        boolean bOptimizedOutput = aSettings.isOptimizedOutput();
        StringBuilder aSB = new StringBuilder();
        int nDeclCount = this.getDeclarationCount();
        if (nDeclCount == 0) {
            aSB.append(bOptimizedOutput ? "{}" : " {}");
        } else if (nDeclCount == 1) {
            aSB.append(bOptimizedOutput ? "{" : " { ");
            aSB.append(super.getAsCSSString(aSettings, nIndentLevel));
            aSB.append(bOptimizedOutput ? "}" : " }");
        } else {
            aSB.append(bOptimizedOutput ? "{" : " {" + aSettings.getNewLineString());
            aSB.append(super.getAsCSSString(aSettings, nIndentLevel));
            if (!bOptimizedOutput) {
                aSB.append(aSettings.getIndent(nIndentLevel));
            }
            aSB.append('}');
        }
        return aSB.toString();
    }
}

